c     -*- mode: FORTRAN -*-
c
c     This file is part of krot,
c     a program for the simulation, assignment and fit of HRLIF spectra.
c
c     Copyright (C) 1994-1998 Arnim Westphal
c     Copyright (C) 1997-1999 Jochen Kpper
c
c     If you use this program for your scientific work, please cite it according to
c     the file CITATION included with this package.
c
c     krot-arnirot
c     a program to calculate rotational resolved vibrational/vibronic bands


#include "arni.h"


      subroutine expth2( maxnl, nexpli, pqnexp, freasn, asfile,
     *                   Jmxexp, dKmexp, shorti )
c     input and sort experimental line frequencies

      implicit none

      integer        maxnli, maxnl
      parameter      ( maxnli = ARNIROT_MAXNLI )

      integer        Jmxexp, dKmexp
      integer        lqnexp(maxnli,6)
      integer        nexpli
      integer        shorti
      real*8         freasn(maxnl)
      real*8         pqnexp(maxnl)
c     assignment file name (not with short input)
      character*250  asfile

      ARNIROT_LAUNCH ( "Launching expth2." )

c     input the experimental lines set
      call inexp2( maxnli, nexpli, lqnexp, freasn, asfile, Jmxexp, dKmexp, shorti )
c     have we found any lines ?
      if ( nexpli .gt. 0 ) then
c        restructure experimental lines set in terms of packed quantum numbers
         call qnpac1( pqnexp, lqnexp, maxnli, nexpli )
c        sort the assigned data by packed quantum numbers into DESCENDING order
         call sort( maxnli, nexpli, pqnexp, freasn )
      end if

      return
      end


c------------------------------------------------------------------------------
c     input the set of assigned experimental lines
      subroutine inexp2( maxnli, nexpli, lqnexp, freasn, asfile,
     *                   Jmxexp, dKmexp, shorti )

      implicit none

      integer        maxnli
      integer        i
      integer        J, Jmxexp, dK, dKmexp
      integer        lqnexp(maxnli,6)
      integer        nexpli
      integer        shorti
      integer        strlen
      real*8         freasn(maxnli)
      character*2    type
      character*250  asfile

      ARNIROT_LAUNCH ( "Launching inexp2." )

c     initialize maximum value of qn J'' and DeltaK in assigned transitions
      Jmxexp = 0
      dKmexp = 0

c     set counter of experimental lines
      nexpli = 1

c     input assigned lines ...
      if ( shorti .eq. 0 ) then
c        ... from file
         open(20, file = asfile(1:strlen(asfile)), status = 'unknown')
    1    continue
            read(20,*,end=2) type, (lqnexp(nexpli,i),i=1,6,1), freasn(nexpli)
c           determine Jmxexp ( maximum J'' )
            J  = max0( lqnexp(nexpli,1), lqnexp(nexpli,4) )
            dK = max0( iabs( lqnexp(nexpli,2) - lqnexp(nexpli,5) ),
     *                 iabs( lqnexp(nexpli,3) - lqnexp(nexpli,6) ) )
            if ( J  .gt. Jmxexp ) Jmxexp = J
            if ( dK .gt. dKmexp ) dKmexp = dK
            nexpli = nexpli + 1
         goto 1
c        close experimental lines data unit
    2    close(20)
      else
c        ... from stdin
    3    continue
            read(*,*,end=4) (lqnexp(nexpli,i),i=1,6,1), freasn(nexpli)
            J  = max0( lqnexp(nexpli,1), lqnexp(nexpli,4) )
            dK = max0( iabs( lqnexp(nexpli,2) - lqnexp(nexpli,5) ),
     *                 iabs( lqnexp(nexpli,3) - lqnexp(nexpli,6) ) )
            if ( J  .gt. Jmxexp ) Jmxexp = J
            if ( dK .gt. dKmexp ) dKmexp = dK
            nexpli = nexpli + 1
         goto 3
    4    continue
      end if
c     correct value of nexpli
      nexpli = nexpli - 1

      ARNIROT_DEBUG1( "inexp2: number of read assignments = ", nexpli )
      
      return
      end


c------------------------------------------------------------------------------
      subroutine qnpac1( pqn, lqn1, maxnli, nlines )
c     pack quantum numbers into one floating point number for each transition

      implicit none

      integer        maxnli
      integer        i, nlines
      integer        lqn1(maxnli,6)
      real*8         pqn(maxnli)

      ARNIROT_LAUNCH ( "Launching qnpac1." )

      do i = 1, nlines, 1
c        corrected for Jmax < 1000: XXXYYYZZZ.xxxyyyzzz
c                                   J' Ka'Kc' J" Ka"Kc"
         pqn(i) = lqn1(i,1)*1.d6 + lqn1(i,2)*1.d3 + lqn1(i,3)*1.d0 + lqn1(i,4)*1.d-3 + lqn1(i,5)*1.d-6 + lqn1(i,6)*1.d-9
      end do

      return
      end


c------------------------------------------------------------------------------
      subroutine sort( nmax, n, ra, rb )
c     a fast sorting algorithm according to NUMERICAL RECIPES p.231 to sort the assigned lines
c     Sorts an array RA of logical length N (physical length NMAX) into DESCENDING numerical
c     order using the Heapsort algorithm, while making the corresponding rearrangement of the array RB.

      implicit none

      integer        i, ir, j, l, n, nmax
      real*8         ra(nmax), rb(nmax), rra, rrb

      ARNIROT_LAUNCH ( "Launching sort." )

      l = n/2 + 1
      ir = n
   10 continue
      if ( l .gt. 1 ) then
         l = l - 1
         rra = ra(l)
         rrb = rb(l)
      else
         rra = ra(ir)
         rrb = rb(ir)
         ra(ir) = ra(1)
         rb(ir) = rb(1)
         ir = ir - 1
         if ( ir .eq. 1 ) then
            ra(1) = rra
            rb(1) = rrb
            return
         end if
      end if
      i = l
      j = l + l
   20 if ( j .le. ir ) then
         if ( j .lt. ir ) then
c           sort into DESCENDING order
            if ( ra(j) .gt. ra(j+1) ) then
               j = j + 1
            end if
         end if
c        sort into DESCENDING order
         if ( rra .gt. ra(j) ) then
            ra(i) = ra(j)
            rb(i) = rb(j)
            i = j
            j = j + j
         else
            j = ir + 1
         end if
         goto 20
      end if
      ra(i) = rra
      rb(i) = rrb
      goto 10
      
      end
