c     -*- mode: FORTRAN -*-
c
c     This file is part of krot,
c     a program for the simulation, assignment and fit of HRLIF spectra.
c
c     Copyright (C) 1994-1998 Arnim Westphal
c     Copyright (C) 1997-1999 Jochen Kpper
c
c     If you use this program for your scientific work, please cite it according to
c     the file CITATION included with this package.
c
c     krot-arnirot
c     a program to calculate rotational resolved vibrational/vibronic bands


#include "arni.h"

c     output eigenvector elements for debugging purposes
      subroutine sdebug( Jmax, dmeval, dmevec, ntheli,
     *                   Jmxcal, icqn, lifile,
     *                   evalg, evale,
     *                   evecgr, evecer, evecgi, evecei,
     *                   symdes,
     *                   lngbar,
     *                   ivpt )

      implicit none

      integer        Jmax, dmeval, dmevec
      integer        nmax
      parameter      ( nmax = 200 )
c     concerning degdif cf. subroutine CHEVEC
      real*8         degdif, genau
      parameter      ( degdif = 1.d-6, genau = 1.d-4 )

      integer        icqn(dmeval,3)
      integer        ivpt(0:Jmax)
      integer        Jmxcal
      integer        ntheli

      real*8         evale(dmeval), evalg(dmeval)
      real*8         evecei(dmevec), evecgi(dmevec)
      real*8         evecer(dmevec), evecgr(dmevec)

      character*2    symdes(0:1,0:1)
      character*220  lngbar
      character*250  lifile

#ifdef DEBUG_VERBOSE
      integer        i, i1, i2, k, k1, k2, kk, l, m
      integer        index
      integer        iept
      integer        ipv
      integer        ipvec
      integer        J, Je, Jg, Kae, Kce, Kag, Kcg
      integer        kneg, kpos
      integer        strlen

      real*8         fl(0:nmax)
      real*8         listfa
      real*8         tfre
      real*8         xint

      character*1    s1, s2
      character*2    sec, specKK, sym
      character*3    degg, dege
      character*5    remark
      character*13   dummy

c     common block of data with subroutines/functions in this module
      common/ factor/ fl
#endif


      ARNIROT_LAUNCH ( "Launching sdebug." )

#ifdef DEBUG_VERBOSE
      i1 = 0
      i2 = 0

      open(12, file = lifile(1:strlen(lifile))//'.deb', status = 'unknown')

      write(12,'('' Index  J  Ka Kc  Symm.   evecgr   evecer   evecgi   evecei     evalg              evale           remark'')')
      write(12,'(a)') lngbar(1:105)

      index = 0
c     loop through every J block
      do J = 0, Jmxcal, 1
         write(12,*) ' '
         iept = J*J
         ipvec = ivpt(J)
c        loop through every state of the current J block
         do l = 1, 2*J+1, 1
            remark = '   ok'
            index = index + 1
            ipv   = ipvec + (l - 1)*(2*J + 1)
c           cf. subroutine CHEVEC
c           loop through row to find first element of significant size
            do kneg = 1, 2*J+1, 1
               if ( dabs( evecgr(ipv+kneg) ) .gt. 0.001 ) then
                  k = kneg - (J + 1)
                  if ( mod( iabs(k),2 ) .eq. 0 ) then
                     s1 = 'E'
                     i1 = 0
                  else
                     s1 = 'O'
                     i1 = 1
                  end if
                  kpos = 2*(J + 1) - kneg
                  if ( evecgr(ipv+kneg) * evecgr(ipv+kpos) .gt. 0 ) then
                     s2 = '+'
                     i2 = 0
                  else
                     s2 = '-'
                     i2 = 1
                  end if
                  goto 1
               end if
            end do
            
    1       sec = s1//s2
            if ( mod( J, 2 ) .eq. 1 ) i2 = 1 - i2
            sym = symdes(i1,i2)
            
            k1 = mod( icqn(l+iept,2), 2 )
            k2 = mod( icqn(l+iept,3), 2 )
c           exchange k2 value if k1=1 (Ka odd) for a correct match with
c           SYMmetry DESignation array elements
            if ( k1 .eq. 1 ) k2 = 1 - k2
            specKK = symdes(k1,k2)
            if ( specKK .ne. sym ) remark = 'ERROR'
            
            degg = ' '
            dege = ' '
            if ( J .gt. 0 ) then
               if ( dabs( evalg(l+iept) - evalg(l+iept-1) ) .le. degdif ) then
                  if ( mod( l, 2 ) .eq. 0 ) then
                     degg = '(d)'
                  else
                     degg = ' d '
                  end if
               end if
               if ( dabs( evalg(l+iept) - evalg(l+iept+1) ) .le. degdif ) then
                  if ( mod( l, 2 ) .eq. 0 ) then
                     degg = ' d '
                  else
                     degg = '(d)'
                  end if
               end if
               if ( dabs( evale(l+iept) - evale(l+iept-1) ) .le. degdif ) then
                  if ( mod( l, 2 ) .eq. 0 ) then
                     dege = '(d)'
                  else
                     dege = ' d '
                  end if
               end if
               if ( dabs( evale(l+iept) - evale(l+iept+1) ) .le. degdif ) then
                  if ( mod( l, 2 ) .eq. 0 ) then
                     dege = ' d '
                  else
                     dege = '(d)'
                  end if
               end if
            end if
            
            write(12, fmt = 100) index, (icqn(l+iept,kk), kk = 1, 3, 1),
     *      sym, sec, evecgr(ipv+1), evecer(ipv+1), evecgi(ipv+1), evecei(ipv+1),
     *      evalg(l+iept), degg, evale(l+iept), dege, remark
            do m = 2, 2*J+1, 1
               index = index + 1
               if (    ((dabs(evecgr(ipv+m)) + dabs(evecer(ipv+m))).ge.genau)
     *            .or. ((dabs(evecgi(ipv+m)) + dabs(evecei(ipv+m))).ge.genau) ) then
                  write(12,'(i6, 17x, 4(2x,f7.4))') index,
     *            evecgr(ipv+m), evecer(ipv+m), evecgi(ipv+m), evecei(ipv+m)
               end if
            end do
         end do
      end do

  100 format (i6, 1x, 3(i3), 2x, a2, 1x, a2, 4(2x,f7.4),2(f15.6,1x,a3), 2x, a5)
      close(12)

c- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
c     calculate line strength factors in an alternative way using a formula similar to ZARE eq.(6.123)

c     set up logarithmic factorials
      call setfac

      open(11, file = lifile(1:strlen(lifile)), status = 'unknown')
      open(13, file = lifile(1:strlen(lifile))//'.lsf', status = 'unknown')

      do i = 1, ntheli, 1
         read(11, fmt = 200) dummy, Je, Kae, Kce, Jg, Kag, Kcg, xint, tfre
         xint = listfa( Je, Kae, Kce, Jg, Kag, Kcg,
     *                  evecgr, evecer, dmevec,
     *                  ivpt, Jmax ) * 1.d4
         write(13, fmt = 200) dummy, Je, Kae, Kce, Jg, Kag, Kcg, xint, tfre
      end do
  200 format (a13, 1x, 6(i4), f11.3, f18.6)
c 200 format (a13, 1x, 6(i4), 2(1x,f18.6))

      close(13)
      close(11)
#endif

      return
      end


c------------------------------------------------------------------------------
#ifdef DEBUG_VERBOSE
      real*8 function listfa( Je, Kae, Kce, Jg, Kag, Kcg,
     *                        evecgr, evecer, dmevec,
     *                        ivpt, Jmax )
c     function to evaluate the line strength factor of an asymmetric top transition following ZARE eq.(6.123)

      implicit none

      integer        Jmax, dmevec, nmax
      parameter      ( nmax = 200 )

      integer        ipev, ipevec, ipgv, ipgvec
      integer        ivpt(0:Jmax)
      integer        Je, Kae, Kce, Jg, Kag, Kcg
      integer        ke, kg, taue, taug
      integer        DeltaJ, Jmin, koffe, koffg, kp, kpp

      real*8         evecer(dmevec), evecgr(dmevec)
      real*8         fl(0:nmax)
      real*8         sfac1, sfac2, sfac3, sum1, sum2, sum3
      real*8         vint3j

      common/ factor/ fl

      ARNIROT_LAUNCH ( "Launching listfa." )

c     determine initial positions of the needed eigenvector coefficients
      taue   = Kae - Kce
      ipevec = ivpt(Je)
      ipev   = ipevec + (taue + Je)*(2*Je + 1)

      taug   = Kag - Kcg
      ipgvec = ivpt(Jg)
      ipgv   = ipgvec + (taug + Jg)*(2*Jg + 1)

      DeltaJ = Je - Jg
      koffe  = 1 + DeltaJ
      koffg  = 1 - DeltaJ
      Jmin   = min0(Je,Jg)

c                DeltaJ  koffe  koffe   Jmin
c     P branch     -1      0      2      Je
c     Q branch      0      1      1      Je=Jg
c     R branch     +1      2      0      Jg

c     only diagonal and one-off-diagonal matrix elements are nonvanishing
c     upper diagonal elements
      sum1    = 0.d0
      do kp = -Je, Je-koffe, 1
         ke = kp + koffe
         kg = ke - 1
         sfac1 = evecer(ipev + ke + (Je + 1))
         sfac2 = evecgr(ipgv + kg + (Jg + 1))
         sfac3 = vint3j( Jg, 1, Je, kg, ke-kg, -ke )
         sum1  = sum1 + sfac1*sfac2*sfac3
      end do
c     diagonal elements
      sum2    = 0.d0
      do kp = -Jmin, Jmin, 1
         ke = kp
         kg = kp
         sfac1 = evecer(ipev + ke + (Je + 1))
         sfac2 = evecgr(ipgv + kg + (Jg + 1))
         sfac3 = vint3j( Jg, 1, Je, kg, ke-kg, -ke )
         sum2  = sum2 + sfac1*sfac2*sfac3
      end do
c     lower diagonal elements
      sum3    = 0.d0
      do kpp = -Jg, Jg-koffg, 1
         kg = kpp + koffg
         ke = kg - 1
         sfac1 = evecer(ipev + ke + (Je + 1))
         sfac2 = evecgr(ipgv + kg + (Jg + 1))
         sfac3 = vint3j( Jg, 1, Je, kg, ke-kg, -ke )
         sum3  = sum3 + sfac1*sfac2*sfac3
      end do

      listfa = (2*Je + 1)*(2*Jg + 1)*(sum1**2 + sum2**2 + sum3**2)

      return
      end
#endif


c------------------------------------------------------------------------------
#ifdef DEBUG_VERBOSE
      real*8 function vint3j( j1, j2, j3, m1, m2, m3 )
c     WIGNER 3j symbol function

      implicit none

      integer        nmax
      parameter      ( nmax = 200 )
      integer        j1, j2, j3, m1, m2, m3
      integer        kmax1, kmax2, kmax3, kmin1, kmin2
      integer        msign, nu, numax, numin, nusign
      real*8         fl(0:nmax)
      real*8         fterms, sum, term, term1, term2, thrj

      common/ factor/ fl

      ARNIROT_LAUNCH ( "Launching vint3j." )

      thrj = 0.d0

      if ( m1 + m2 + m3 .ne. 0 ) goto 999

      if ( j1 + j2 - j3 .lt. 0 ) goto 999
      if ( j1 + j3 - j2 .lt. 0 ) goto 999
      if ( j2 + j3 - j1 .lt. 0 ) goto 999

      if ( iabs(m1) .gt. j1 ) goto 999
      if ( iabs(m2) .gt. j2 ) goto 999
      if ( iabs(m3) .gt. j3 ) goto 999

      numin = j3 - j2 + m1
      kmin1 = numin
      kmin2 = j3 - j1 - m2
      if ( kmin2 .lt. numin ) numin = kmin2
      if     ( 0 .lt. numin ) numin = 0
      numin = (-1)*numin

      numax = j1 + j2 - j3
      kmax1 = numax
      kmax2 = j1 - m1
      kmax3 = j2 + m2
      if ( kmax2 .lt. numax ) numax = kmax2
      if ( kmax3 .lt. numax ) numax = kmax3

      if ( numin .gt. numax ) goto 999

      msign = (-1)**iabs(j1 - j2 - m3)
      term1 = fterms( j1, j2, j3, m1, m2, m3 )
      sum = 0.d0

      do nu = numin, numax, 1
         nusign = (-1)**nu
         term2 = fl(nu) + fl(kmax1 - nu) + fl(kmax2 - nu) + fl(kmax3 - nu) + fl(kmin1 + nu) + fl(kmin2 + nu)
         term = dexp(term1 - term2)
         term = nusign*term
         sum = sum + term
      end do

      thrj = msign*sum
  999 vint3j = thrj

      return
      end
#endif


c------------------------------------------------------------------------------
#ifdef DEBUG_VERBOSE
      real*8 function fterms( j1, j2, j3, m1, m2, m3 )

      implicit none

      integer        nmax
      parameter      ( nmax = 200 )
      integer        j1, j2, j3, m1, m2, m3
      integer        l1, l2, l3, l4, l5, l6, l7, l8, l9, l10
      real*8         fl(0:nmax)

      common/ factor/ fl

      ARNIROT_LAUNCH ( "Launching fterms." )

      l1  = j1 + j2 - j3
      l2  = j1 + j3 - j2
      l3  = j2 + j3 - j1
      l4  = j1 + j2 + j3 + 1
      l5  = j1 + m1
      l6  = j1 - m1
      l7  = j2 + m2
      l8  = j2 - m2
      l9  = j3 + m3
      l10 = j3 - m3

      fterms = fl(l1) + fl(l2) + fl(l3) - fl(l4) + fl(l5) + fl(l6) + fl(l7) + fl(l8) + fl(l9) + fl(l10)
      fterms = fterms*0.5d0

      return
      end
#endif


c------------------------------------------------------------------------------
#ifdef DEBUG_VERBOSE
      subroutine setfac
c     calculate and store the factorials for N = 0 to 200

      implicit none

      integer        nmax
      parameter      ( nmax = 200 )
      integer        i
      real*8         facl(0:nmax)

      common/ factor/ facl

      ARNIROT_LAUNCH ( "Launching setfac." )

      facl(0) = 0.d0
      do i = 1, nmax, 1
         facl(i) = facl(i - 1) + dlog(dble(i))
      end do

      return
      end
#endif
