#include "xyplot.h"


static void fmt_dummy (char* buffer, double)
{
  strcpy(buffer,"n/a");
}

static void fmt_simple (char* buffer, double value)
{
  sprintf(buffer,"%f",value);
}

static void fmt_1dec (char* buffer, double value)
{
  sprintf(buffer,"%.1f",value);
}

static void fmt_2dec (char* buffer, double value)
{
  sprintf(buffer,"%.2f",value);
}

static void fmt_3dec (char* buffer, double value)
{
  sprintf(buffer,"%.3f",value);
}

static void fmt_4dec (char* buffer, double value)
{
  sprintf(buffer,"%.4f",value);
}

//static void fmt_ (char* buffer, double value)
//{
//}

//static void fmt_ (char* buffer, double value)
//{
//}


QList<XYPlotFormat>& XYPlotFormatList ()
{
  static QList<XYPlotFormat> formatList;
  if (formatList.count() == 0) {
	formatList.setAutoDelete(TRUE);
	formatList.append(new XYPlotFormat("Simple",fmt_simple));
	formatList.append(new XYPlotFormat("1 decimal" ,fmt_1dec));
	formatList.append(new XYPlotFormat("2 decimals",fmt_2dec));
	formatList.append(new XYPlotFormat("3 decimals",fmt_3dec));
	formatList.append(new XYPlotFormat("4 decimals",fmt_4dec));
	//formatList.append(new XYPlotFormat("",fmt_));
	//formatList.append(new XYPlotFormat("",fmt_));
	//formatList.append(new XYPlotFormat("",fmt_));
	//formatList.append(new XYPlotFormat("",fmt_));
  }
  return formatList;
}


XYPlotFormat::XYPlotFormat ()
{
  name[0] = 0;
  formatter = fmt_dummy;
}


XYPlotFormat::XYPlotFormat (const char* n, XYPlotFormatProc f)
{
  strcpy(name,n);
  formatter = f;
}
