#ifndef __EXPORTHTML_H
#define __EXPORTHTML_H 


/*
 *    Interface for the Export HTML class.
 *
 *    As you can see, this class inherits exportFilter
 *    for defining the interface. Clone this file for
 *    further export filters.
 *
 *
 *    Dont copy this file into the korigin include path!
 *    It is not needed there.
 *
 *
 *    When writing new filters watch the initialization class
 *    in the exportHTML.cc file (at the end).
 *
 *
 *
 *    Written by Martin Hfner for the KOrigin Project
 *
 */

#include <qobject.h>
#include <qstring.h>

#include <kconfig.h>

#include <export.h>

#include "colors.h"
#include "stylewidget.h"
#include "filter.h"


class exportHTML : public QObject, public exportFilter
{
  Q_OBJECT
  public: 
    exportHTML ();
    ~exportHTML ();

    QString getDescription ();
    const char* getFileFilter ();

    void getOptionsSlot ();
    void writeTable (const char* filename, Table* T);

    QString getLatestDirectory ();
    void setLatestDirectory (const char* dir);

    QString getDefaultDirectory ();
    void setDefaultDirectory (const char* dir);

  private:
    KConfig* k;

    QString latestDirectory;

    colors* co;
    StyleW* st;
    filter* fi;

  private slots:
    void applyPressed ();
};



#endif

