#include <qwidget.h>
#include <qdialog.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qmlined.h>
#include <qlistbox.h>
#include <qlabel.h>

#include "page.h"
#include "pg_info.h"
#include "pg_info.moc"

#include <kapp.h>


PageInfoDialog::PageInfoDialog (Page* page, QWidget* parent, const char* name,
								bool modal, WFlags f)
  : QDialog(parent,name,modal,f)
{
  uint i;
  char buffer [1024];
  QLabel* label;

  whatPage = page;

  setCaption("Page Information");
  setFixedSize(400,380);

  ok = new QPushButton (this,"item_1");
  ok->setGeometry(50,345,90,25);
  ok->setText("Ok");
  ok->setAutoRepeat(false);
  ok->setAutoResize(false);
  ok->setDefault(false);
  connect(ok,SIGNAL(clicked()),SLOT(OK()));

  helpb = new QPushButton (this,"item_2");
  helpb->setGeometry(155,345,90,25);
  helpb->setText("Help");
  helpb->setAutoRepeat(false);
  helpb->setAutoResize(false);
  helpb->setDefault(false);
  connect(helpb,SIGNAL(clicked()),SLOT(help()));

  cancel = new QPushButton (this,"item_3");
  cancel->setGeometry(260,345,90,25);
  cancel->setText("Cancel");
  cancel->setAutoRepeat(false);
  cancel->setAutoResize(false);
  cancel->setDefault(false);
  connect(cancel,SIGNAL(clicked()),SLOT(reject()));

  label = new QLabel (this,"item_4");
  label->setGeometry(15,5,370,25);
  label->setText("Caption:");
  capt = new QLineEdit (this,"item_5");
  capt->setGeometry(100,5,120,25);
  capt->setMaxLength(50);
  capt->setText(whatPage->caption());

  sprintf(buffer,"Page width = %.1f cm, height = %.1f cm",
		  whatPage->cm_width,whatPage->cm_height);
  label = new QLabel (this,"item_6");
  label->setGeometry(15,35,370,20);
  label->setText(buffer);

  switch(whatPage->objectList.count()) {
  case 0:
	sprintf(buffer,"There are no objects on this page.");
	break;
  case 1:
	sprintf(buffer,"There is one object on this page.");
	break;
  default:
	sprintf(buffer,"There are %i objects on this page.",
			whatPage->objectList.count());
  }
  label = new QLabel (this,"item_7");
  label->setGeometry(15,60,370,20);
  label->setText(buffer);

  list = new QListBox (this,"item_8");
  list->setGeometry(25,85,350,100);
  for (i=0; i<whatPage->objectList.count(); i++)
	list->insertItem( whatPage->objectList.at(i)->description() );

  label = new QLabel (this,"item_9");
  label->setGeometry(15,190,370,20);
  label->setText("Notes for this page:");
  mledit = new QMultiLineEdit (this,"item_10");
  mledit->setGeometry(25,215,350,100);
  mledit->setReadOnly(false);
  mledit->setText(whatPage->notes);
}


PageInfoDialog::~PageInfoDialog ()
{
}


void PageInfoDialog::OK ()
{
  apply();
  accept();
}


void PageInfoDialog::apply ()
{
  char buffer [1024];
  cout << "PageInfoDialog::apply()" << endl;
  strncpy(buffer,(const char*)(capt->text()),1022);
  if (buffer[strlen(buffer)-1] == 10)
	buffer[strlen(buffer)-1] = 0; // kill trailing linebreak
  whatPage->setCaption(buffer);
  strncpy(whatPage->notes,(const char*)(mledit->text()),2047);
  whatPage->notes[2047] = 0;
  while (whatPage->notes[strlen(whatPage->notes)-1] == 10)
	whatPage->notes[strlen(whatPage->notes)-1] = 0; // kill trailing linebreaks
}


void PageInfoDialog::help ()
{
  KApplication::getKApplication()->invokeHTMLHelp("korigin/page-info.html","");
}
