#include <stdio.h>
#include <stdlib.h>

#include "d56ioctl.h"
#include "dsp56utils.h"

/****************************************************************************************/
/*											*/
/*	load_bootloader									*/
/*											*/
/****************************************************************************************/

int load_bootloader(int hdriver, const char* filename)
{
	FILE*	bootfile;
	char	line[100];
	int	count, val, ret;
	DSP56BOOT	dsp56boot;
	DSP56STRUCT	dsp56struct;
	
	if((bootfile = fopen(filename,"rt")) == NULL)
	{
		printf("can't open %s\n", filename);
		return 0;
	}

	memset(dsp56boot.Bootloader, 0, sizeof(dsp56boot.Bootloader));

	count = 0;
	while(fscanf(bootfile, "%s", line) != EOF)
	{
		if(sscanf(line, "%06x", &val) && (strlen(line) == 6))
		{
			dsp56boot.Bootloader[count++] = val;
		}
	}
	fclose(bootfile);
	
	if((ret = ioctl(hdriver, IOCTL_D56_BOOTLOAD, (char *)&dsp56boot)) < 0)
	{
		printf("BOOTLOAD error 1\n");
		return 0;
	}
	
	dsp56struct.Register = (char) 0x92;
	if((ret = ioctl(hdriver, IOCTL_D56_CVR_WRITE, (char *)&dsp56struct)) < 0)
	{
		printf("BOOTLOAD error 2\n");
		return 0;
	}
	return 1;
}

/****************************************************************************************/
/*											*/
/*	load_application								*/
/*											*/
/****************************************************************************************/

int load_application(int hdriver, const char* filename)
{
	FILE*	applicationfile;
	char	line[100];
	int	data_found, ret, data;
	DSP56STRUCT	dsp56struct;

	if((applicationfile = fopen(filename,"rt")) == NULL)
	{
		printf("can't open %s\n", filename);
		return 0;
	}
	
	data_found = 0;
	while(EOF != fscanf(applicationfile, "%s\n", line))
	{
		if(strcmp(line, "_DATA") == 0)
		{
			if(!data_found)
				data_found = 1;
			else
			{
				dsp56struct.Register = (char) 0x08;
				if((ret = ioctl(hdriver, IOCTL_D56_ICR_WRITE, (char *)&dsp56struct))<0)
				{
					printf("APP error 1: %s\n", line);
					goto error;
				}
				
				dsp56struct.Register = (char) 0x00;
				if((ret = ioctl(hdriver, IOCTL_D56_ICR_WRITE, (char *)&dsp56struct))<0)
				{
					printf("APP error 2: %s\n", line);
					goto error;
				}
			}
		}
		else if(strcmp(line, "_END") == 0)
			data_found = 0;
		else if(strcmp(line, "_SYMBOL") == 0)
			data_found = 0;
		else if(data_found)
		{
			if(strcmp(line, "P") == 0)
			{
				fscanf(applicationfile, "%x", &data);
				
				dsp56struct.HostPort = data;
				if((ret = ioctl(hdriver, IOCTL_D56_HP_WRITE, (char *)&dsp56struct))<0)
				{
					printf("APP error 3: %s\n", line);
					goto error;
				}
				
				dsp56struct.HostPort = 0x08586B;
				if((ret = ioctl(hdriver, IOCTL_D56_HP_WRITE, (char *)&dsp56struct))<0)
				{
					printf("APP error 4: %s\n", line);
					goto error;
				}
			}
			else if(strcmp(line, "X") == 0)
			{
				fscanf(applicationfile, "%x", &data);
				
				dsp56struct.HostPort = data;
				if((ret = ioctl(hdriver, IOCTL_D56_HP_WRITE, (char *)&dsp56struct))<0)
				{
					printf("APP error 5: %s\n", line);
					goto error;
				}

				dsp56struct.HostPort = 0x0858AB;
				if((ret = ioctl(hdriver, IOCTL_D56_HP_WRITE, (char *)&dsp56struct))<0)
				{
					printf("APP error 6: %s\n", line);
					goto error;
				}
			}
			else if(strcmp(line, "Y") == 0)
			{
				fscanf(applicationfile, "%x", &data);
			
				dsp56struct.HostPort = data;
				if((ret = ioctl(hdriver, IOCTL_D56_HP_WRITE, (char *)&dsp56struct))<0)
				{
					printf("APP error 7: %s\n", line);
					goto error;
				}
				dsp56struct.HostPort = 0x0858EB;
				if((ret = ioctl(hdriver, IOCTL_D56_HP_WRITE, (char *)&dsp56struct)) < 0)
				{
					printf("APP error 8: %s\n", line);
					goto error;
				}
			}
			else
			{
				sscanf(line, "%x", &data);
				dsp56struct.HostPort = data;
				if((ret = ioctl(hdriver, IOCTL_D56_HP_WRITE, (char *)&dsp56struct))<0)
				{
					printf("APP error 9: %s\n", line);
					goto error;
				}
			}
		}
	}
	fclose(applicationfile);

	dsp56struct.Register = (char) 0x10;
	if((ret = ioctl(hdriver, IOCTL_D56_ICR_WRITE, (char *)&dsp56struct)) < 0)
	{
		printf("APP error 10: %s\n", line);
		return 0;
	}

	dsp56struct.Register = (char) 0x00;
	if((ret = ioctl(hdriver, IOCTL_D56_ICR_WRITE, (char *)&dsp56struct)) < 0)
	{
		printf("APP error 11: %s\n", line);
		return 0;
	}

	dsp56struct.Register = (char) 0x92;
	if((ret = ioctl(hdriver, IOCTL_D56_CVR_WRITE, (char *)&dsp56struct)) < 0)
	{
		printf("APP error 12: %s\n", line);
		return 0;
	}

	dsp56struct.HostPort = 0;
	if((ret = ioctl(hdriver, IOCTL_D56_HP_WRITE, (char *)&dsp56struct)) < 0)
	{
		printf("APP error 13: %s\n", line);
		return 0;
	}

	dsp56struct.HostPort = 0xC0000;
	if((ret = ioctl(hdriver, IOCTL_D56_HP_WRITE, (char *)&dsp56struct)) < 0)
	{
		printf("APP error 14: %s\n", line);
		return 0;
	}

	dsp56struct.HostPort = 0x00;
	if((ret = ioctl(hdriver, IOCTL_D56_HP_WRITE, (char *)&dsp56struct)) < 0) 
	{
		printf("APP error 15: %s\n", line);
		return 0;
	}

	dsp56struct.Register = (char) 0x80;
	if((ret = ioctl(hdriver, IOCTL_D56_ICR_WRITE, (char *)&dsp56struct)) < 0)
	{
		printf("APP error 16: %s\n", line);
		return 0;
	}

	return 1;

error:
	fclose(applicationfile);
	return 0;
}
