/* wwdialog.cpp
 *
 * Andreas Wst
 *
 */

#include "wwdialog.moc"

WWDialog::WWDialog ( QWidget *parent, const char *name )
                : QDialog ( parent, name, TRUE )
{
  setCaption ("Work with charts");

  frame = new QFrame (this, "frame");
  frame->setGeometry (10, 10, 360, 170);
  frame->setFrameStyle (QFrame::Panel | QFrame::Sunken);
  frame->setLineWidth (2);

  lv = new QListView (frame, "lv");
  lv->setGeometry (2, 2, frame->width () - 4, frame->height () - 4);
  lv->addColumn ("Name", 185);
  lv->addColumn ("Start", 75);
  lv->addColumn ("End", 75);
  lv->setAllColumnsShowFocus (TRUE);

  open = new QPushButton ("Open", this, "open");
  open->setGeometry (390, 10, 70, 30);
  connect (open, SIGNAL (clicked ()), SLOT (openPressed ()));
  
 
  del = new QPushButton ("Delete", this, "delete");
  del->setGeometry (390, 50, 70, 30);
  connect (del, SIGNAL (clicked ()), SLOT (deleteItem ()));

  cancel = new QPushButton ("Cancel", this, "cancel");
  cancel->setGeometry (390, 90, 70, 30);
  connect (cancel, SIGNAL (clicked ()), SLOT (reject ()));


  char daten [100];
  strcpy (daten, getenv ("HOME"));
  strcat (daten, "/stocks/data/");
  pfad = daten;

  loadFiles (); 
 
  resize( 480, 190 );
}


WWDialog::~WWDialog()
{      
  delete lv;
  delete del;
  delete open;
  delete cancel;
}

void WWDialog::loadFiles ()
{
  // alle files mit .data endung anzeigen
  // ersten und letzten eintrag in file lesen
  ifstream in;
  
  QString s, filename;
  char st1 [11], st2 [11];

  QDir d (pfad.data (), "*.data");


  const QFileInfoList *list = d.entryInfoList();
  QFileInfoListIterator it (*list );       // create list iterator        
  QFileInfo *fi;                           // pointer for traversing   
  while ((fi=it.current())) 
  {

    s = fi->fileName ();
    filename = pfad + s;
   
    //    debug ("filename . %s", filename.data ());
    //    debug ("sizeof chart : %d", sizeof (chart_daten));

    s.replace (QRegExp ("_"), " ");
    s.replace (QRegExp (".data"), "");

    in.open (filename.data ());
    if (in.bad () == 0)
    {
      // ersten eintrag einlesen
      in.seekg (sizeof (int), ios::beg);
      in.read (&kurs, sizeof (chart_daten));
      sprintf (st1, "%02d.%02d.%4d", kurs.tag, kurs.monat, kurs.jahr);

      in.seekg (-sizeof (chart_daten), ios::end);
      in.read (&kurs, sizeof (chart_daten));
      sprintf (st2, "%02d.%02d.%4d", kurs.tag, kurs.monat, kurs.jahr);      
      QListViewItem *item = new QListViewItem (lv, s.data (), st1, st2); 
    }
    in.close ();
    ++it;     // goto next list element        
  }  
}

void WWDialog::deleteItem ()
{
  QListViewItem *item = lv->currentItem ();
  if (item != NULL)
  {
    // wirklichen dateinamen ermitteln und lschen
    QString s (item->text (0));
    s = s + ".data";
    s.replace (QRegExp (" "), "_");
    s = pfad + s;
    QFile f (s.data ());
    f.remove ();
    // listview lschen und files wieder laden
    lv->clear ();
    loadFiles ();
  }
}

void WWDialog::openPressed ()
{
  QListViewItem *item = lv->currentItem ();
  if (item != NULL)
  {
   // wirklichen dateinamen ermitteln und lschen
    QString s (item->text (0));
    // stock name zurckgeben
    emit (returnChartName (s));
    s = s + ".data";
    s.replace (QRegExp (" "), "_");
    s = pfad + s;
    // stock name data file name zurckgeben
    emit (returnChartFile (s));
    accept ();
  }
}

