/* kill.cpp
 *
 * Andreas Wst
 *
 */


#include "kill.moc"

Kill::Kill( QWidget *parent, const char *name, int anz, Stock *stock [] )
                : QDialog ( parent, name, TRUE)

{
  setCaption ("Delete stock");

  lbox = new QListBox (this, "lbox" );
  lbox->setGeometry( 10, 10, 270, 170 );
  lbox->setFrameStyle( 51 );
  lbox->setLineWidth( 2 );


  for (int i = 0; i < anz; i++)
  {
    s [i] = stock [i];
    lbox->insertItem (s [i]->getName ());
  }

  done = new QPushButton ("Done", this, "ok");
  done->setGeometry (300, 50, 70, 30);
  connect (done, SIGNAL (clicked ()), SLOT (reject ()));

  del = new QPushButton ("Delete", this, "cancel");
  del->setGeometry (300, 10, 70, 30);
  connect (del, SIGNAL (clicked ()), SLOT (deletePressed ()));

  setMinimumSize (390, 190);
  setMaximumSize (390, 190);
}

Kill::~Kill()
{
}


void Kill::deletePressed ()
{
  int index = lbox->currentItem ();
  STOCK_STATUS status = KILLED;

  if (index != -1)
  {
    QString str = lbox->text (index);
    int i = 0;
    while (strncmp (str.data (), s [i]->getName (), strlen (str.data ())) != 0)
      i++;
    s [i]->setStatus (status);
    debug ("removed %s", str.data ());
    lbox->removeItem (index);
  }
}
