/* dayaveragedialog.cpp
 *
 * Andreas Wst
 *
 */ 

#include "dayaveragedialog.moc"

DayAverage::DayAverage ( QWidget *parent, const char *name, QColor c1, 
                QColor c2, QColor c3)
                : QWidget (parent, name)
{
  fr = new QFrame (this, "frame");
  fr->setFrameStyle (QFrame::Box | QFrame::Sunken);
  fr->setGeometry (10, 10, 290, 200);
  
  QLabel *l = new QLabel ("50 Day average :", this, "label");
  l->setGeometry (35, 30, 110, 20);
  
  l = new QLabel ("100 Day average :", this, "label");
  l->setGeometry (30, 70, 110, 20);

  l = new QLabel ("200 Day average :", this, "label");
  l->setGeometry (30, 110, 110, 20);

  // Frames sind mit Farben vorbelegt, die aus Config_data an diesen
  // Dialog bergeben werden

  // Frame mit Farbe
  frame1 = new QFrame (this, "frame");
  frame1->setFrameStyle (QFrame::Panel | QFrame::Sunken);
  frame1->setLineWidth (2);
  frame1->setBackgroundColor (c1);
  frame1->setGeometry (155, 30, 25, 25);

  // Frame mit Farbe
  frame2 = new QFrame (this, "frame");
  frame2->setFrameStyle (QFrame::Panel | QFrame::Sunken);
  frame2->setLineWidth (2);
  frame2->setBackgroundColor (c2);
  frame2->setGeometry (155, 70, 25, 25);

  // Frame mit Farbe
  frame3 = new QFrame (this, "frame");
  frame3->setFrameStyle (QFrame::Panel | QFrame::Sunken);
  frame3->setLineWidth (2);
  frame3->setBackgroundColor (c3);
  frame3->setGeometry (155, 110, 25, 25);
   
  change1 = new QPushButton ("Change", this, "change1");
  change1->setGeometry (205, 30, 75, 25);
  connect (change1, SIGNAL (clicked ()), SLOT (change1Pressed ()));
 
  change2 = new QPushButton ("Change", this, "change1");
  change2->setGeometry (205, 70, 75, 25);
  connect (change2, SIGNAL (clicked ()), SLOT (change2Pressed ()));
 
  change3 = new QPushButton ("Change", this, "change1");
  change3->setGeometry (205, 110, 75, 25);
  connect (change3, SIGNAL (clicked ()), SLOT (change3Pressed ()));
}


DayAverage::~DayAverage()
{

        
}

void DayAverage::change1Pressed ()
{
  QColor mycolor (frame1->backgroundColor ());
  KColorDialog::getColor (mycolor);
  frame1->setBackgroundColor (mycolor);
}

void DayAverage::change2Pressed ()
{
  QColor mycolor (frame2->backgroundColor ());
  KColorDialog::getColor (mycolor);
  frame2->setBackgroundColor (mycolor);
}

void DayAverage::change3Pressed ()
{
  QColor mycolor (frame3->backgroundColor ());
  KColorDialog::getColor (mycolor);
  frame3->setBackgroundColor (mycolor);
}

void DayAverage::getColors (QColor &c1, QColor &c2, QColor &c3)
{
  c1 = frame1->backgroundColor ();
  c2 = frame2->backgroundColor ();
  c3 = frame3->backgroundColor ();
}
