
// Postscript stuff defined in user_interface.h

#include <qfont.h>
#include <qfontmetrics.h>
#include <stdio.h>
#include "../siod/siod.h"
#include "../siag/types.h"
#include "../siag/calc.h"
#include "../common/fonts.h"
#include "../siag/user_interface.h"
#include "psfontnames.h"

extern int fontsizes[];
extern char *fonts[];

char *ps_fontname (int index)
{
    int fontidx;
    fontidx = (index &FONT_MASK) >> FONT_SHIFT;
    fontidx = fontidx << 2;
    if (index & ITALIC)
        ++fontidx;
    if (index & BOLD)
        fontidx += 2;
    return(ps_fontnames[fontidx]);
}

// In the table widget we already have a font allocated, but that is private
// to the table and I don't want to change it.
int ps_text_width (int index, char *s)
{
    QFont fnt(fonts[(index & FONT_MASK) >> FONT_SHIFT],
              fontsizes[index &SIZE_MASK]);
    fnt.setItalic(index & ITALIC);
    fnt.setBold(index & BOLD);
    QFontMetrics metrics(fnt);
    return(metrics.width(s));
}

int ps_font_descent (int index)
{
    QFont fnt(fonts[(index & FONT_MASK) >> FONT_SHIFT],
              fontsizes[index & SIZE_MASK]);
    fnt.setItalic(index & ITALIC);
    fnt.setBold(index & BOLD);
    QFontMetrics metrics(fnt);
    return(metrics.descent());    
}

int ps_font_height (long font)
{
    QFont fnt(fonts[(font & FONT_MASK) >> FONT_SHIFT],
              fontsizes[font & SIZE_MASK]);
    fnt.setItalic(font & ITALIC);
    fnt.setBold(font & BOLD);
    QFontMetrics metrics(fnt);
    return(metrics.height());
}

int ps_embed_print (FILE *fp, char *tag, int x_base, int y_base)
{
    return(0);
}

int ps_font_size (int index)
{
    return(fontsizes[index]);
}
