
#include "ksiag_app.h"
#include "ksiag_lineedit.h"
#include "ksiag_toplevel.h"
#include <string.h>
#include <kapp.h>
#include <stdio.h>
#include "../siod/siod.h"
#include "../siag/calc.h"

extern int grid_lines;
extern window *w_list;
extern char *fonts[];
extern int fontsizes[];
bool use_lineedit = 0;

KSiagCellEdit::KSiagCellEdit(KSiagTable *table, QWidget *parent, const char *name)
    : KLined (parent, name)
{
    int fmt = ret_format(w_list->buf, w_list->point_pos.row,
                         w_list->point_pos.col);
    font.setFamily(fonts[(ret_font(w_list->buf, w_list->point_pos.row,
                                   w_list->point_pos.col)&FONT_MASK)
                         >>FONT_SHIFT]);
    font.setPointSize(fontsizes[fmt & SIZE_MASK]);
    font.setItalic(fmt & ITALIC);
    font.setBold(fmt & BOLD);
    setFont(font);
    setFrame(false);
    setPalette(QPalette(white));

    tbl = table;
    inexec = 0;
    result = 0;

}

void KSiagCellEdit::recalcSize(const char *str)
{
    QFontMetrics metrics(font);
    int w = metrics.width(str)+4;
    if (w > width())
        resize(w, height());
}

int KSiagCellEdit::exec(char *buffer)
{
    inexec = 1;
    connect (this, SIGNAL(returnPressed()), SLOT(done()));
    connect (this, SIGNAL(textChanged(const char *)),
             SLOT(recalcSize(const char*)));
    setFocus();
    setText(buffer);
    while (inexec)
        KApplication::getKApplication()->processEvents();
    if (result)
        strcpy(buffer, text());
    return (result);
}

void KSiagCellEdit::done()
{
    result = 1;
    inexec = 0;
}

void KSiagCellEdit::focusOutEvent(QFocusEvent *ev)
{
    // Funky stuff. We seem to get a focusOut on ourselves sometimes...
    if (KSiagApp::manager()->activeTopLevel()->focusWidget() != this){
        inexec = 0;
        result = 0;
    }
    else
        setFocus();
}

KSiagLineEdit::KSiagLineEdit(QWidget *parent, const char *name)
    : KLined(parent, name)
{
    inexec = 0;
    connect (this, SIGNAL(returnPressed()), SLOT(done()));
}

int KSiagLineEdit::exec(char *buffer)
{
    inexec = 1;
    setFocus();
    setText(buffer);
    while (inexec)
        KApplication::getKApplication()->processEvents();
    if (result){
        strcpy(buffer, text());
    }
    return (result);
}
    
void KSiagLineEdit::cancel()
{
    setText(ret_text(w_list->buf, w_list->point_pos.row,
                     w_list->point_pos.col));
    inexec = 0;
    result = 0;
}

void KSiagLineEdit::done()
{
    char *str = const_cast<char*>(text());
    if (!inexec){
        use_lineedit = 1;
        do_cmd(str[0]);
    }
    else{
        inexec = 0;
        result = 1;
    }
}

void KSiagLineEdit::focusOutEvent(QFocusEvent *ev)
{
    // We allow focusOut to accept and reject buttons only
    KSiagTopLevel *top = KSiagApp::manager()->activeTopLevel();
    if (top->focusWidget() != this &&
        top->focusWidget() != top->toolBar(2)->getWidget(ID_TB_DUMP) &&
       top->focusWidget() != top->toolBar(2)->getWidget(ID_TB_ENTER)){
        inexec = 0;
        result = 0;
    }
    else
        setFocus();
}
