/*  -*- C++ -*- */
#ifndef KAB2_FUNCTIONS_H_INCLUDED
#define KAB2_FUNCTIONS_H_INCLUDED

#include <fstream.h>
#include <qstring.h>
#include "debug.h"

class QTextStream;

/** Read a line, ignore comments. */
QString ReadLineFromStream(QTextStream&);

/** Find out wether a line is a comment or not (comments start with #). */
bool isComment(QString);

/** Get the users home directory by checking for ENV variable "HOME". */
bool getHomeDirectory(QString&);

/** Parse the string and replace all non-standard characters with its
  * HTML equivalents. */
bool htmlizeString(const QString& orig, QString& target);

/** #tokenize partens the given string \a text into its tokens at every 
 *  occurence of the designator \a c and delivers the result in the list
 *  reference. If \a strict is true, the last token is only added if there
 *  are characters after the last designator. */
void tokenize(list<QString>& res, const QString& text, char c, bool strict=false);

#endif // KAB2_FUNCTIONS_H_INCLUDED
