/*
 Copyright (C) 1998, Mark W J Redding <mark@grawlfang.demon.co.uk>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>

#include "pppsvr.h"

static void usage(char *);

int main(int argc, char *argv[])
{
int soc,hostPort=0;
struct sockaddr_in server;
struct hostent *hp,*gethostbyname();
char cmd[2],rec[128],hostAddr[128];
int c,opt_ind;
static struct option long_opts[] = {{"port",0,0,'p'},{"server",0,0,'s'},{"usage",0,0,'h'}};

	memset(hostAddr,0,sizeof(hostAddr));

	do
	{
		c=getopt_long(argc,argv,"p:s:h",long_opts,&opt_ind);
		switch(c)
		{
		case 's' : /* server IP address */
				strncpy(hostAddr,optarg,sizeof(hostAddr)-1);
				break;
		case 'p' : /* server port address */
				hostPort=atoi(optarg);
				break;
		case 'h' : /* display help */
				usage(argv[0]);
				break;
		}
	}
	while(c != -1);

	if(!hostAddr[0]) strcpy(hostAddr,PPPSVR_HOST);
	if(!hostPort) hostPort=PPPSVR_PORT;

	if(argc <= optind)
	{
		usage(argv[0]);
		exit(1);
	}

	memset(cmd,0,sizeof(cmd));
	cmd[0]=toupper(argv[optind][0]);

	if((soc=socket(AF_INET,SOCK_STREAM,0)) < 0)
	{
		perror("opening socket");
		exit(1);
	}

	memset(&server,0,sizeof(server));
	server.sin_family=AF_INET;
	if(!(hp=gethostbyname(hostAddr)))
	{
		perror("host not known");
		exit(2);
	}
	memcpy(&server.sin_addr,hp->h_addr,hp->h_length);
	server.sin_port=htons(hostPort);

	if(connect(soc,(struct sockaddr *)&server,sizeof(server)) < 0)
	{
		perror("connecting socket");
		exit(1);
	}

	memset(rec,0,sizeof(rec));

	if(write(soc,cmd,1)<0)
	{
		perror("sending command");
		exit(1);
	}

	if(read(soc,rec,sizeof(rec)-1) < 0)
	{
		perror("reading response");
		exit(1);
	}

	printf("%s\n",rec);

	close(soc);

}

static void usage(char *prog)
{
	printf("%s [-p port -s server] action\n",prog);
	printf("actions :- U = request server up\n");
	printf("           D = request server down\n");
	printf("           C = count of server requests\n");
	printf("           R = re-request server up\n");
	printf("           S = Report server status\n");
	printf("           T = terminate daemon\n");
	printf("           K = select keep alive mode\n");
	printf("           Z = deselect keep alive mode\n");
	printf("           O = proxy server on-line\n");
	printf("           L = proxy server off-line\n");
	printf("           F = proxy server fetch\n");
	printf("           G = proxy server purge\n");
	printf("           M = send queued mail\n");
}
