/*
   $Id: kxicq.h,v 2.25.4.4.2.5 1998/12/20 21:01:59 herwinjs Exp $
*/

#ifndef K_H
#define K_H

#define KXICQ_version VERSION

#define ID_MENU_CONNECT 0
#define ID_MENU_DISCONNECT 1
#define ID_MENU_STATUS 2
#define ID_MENU_INFO 3
#define ID_MENU_CONFIG 4
#define ID_MENU_QUIT 5

#define STATUS_NEWMSG 12
#define STATUS_NEWURL 13
#define TYPE_SERVER 0

#include <mediatool.h>
#include <kaudio.h>
#include <qlistbox.h>
#include "users.h"
#include <ktoolbar.h>
#include <ktopwidget.h>
#include <kstatusbar.h>
#include <kconfig.h>
#include <qframe.h>
#include <libXicq.h>

struct kxicqConfig
{
    char *browser;
    bool typeBrowser;
    bool autoConnect;
    bool sound;
    bool alwaysSound;
    bool playWav;
    bool showDock;
    bool hideWindow;
    bool first;
    bool kdestyle;
    bool showNewMesg;
    bool showLastUnread;
    int awayTime, naTime;
    bool autoAway;
    bool askAway;
    bool autoRaise;
    QString geom;
    bool saveGeom;
    bool wmaker;
    bool blink;

    bool autoUnAway;
    bool rightStatus;
    bool showUIN;
    bool showTextStatus;
    bool viewSmall;
    bool web;
    
    QColor messageSendText, messageSendBack;
    
    QFont onlineF, offlineF, uinF;
    QColor onlineT, onlineB, onlineST, onlineSB;
    QColor offlineT, offlineB, offlineST, offlineSB;



};

//extern int asprintf(...);

void unknownReply( int type );
void chatRequest( UIN uin, char *mesg );
void closeChat( UIN uin );
void doChat( UIN uin );
void putChar( UIN uin, char *data, int len );
void addnewUser( UIN uin );
void infoRequest( UIN uin );
void showAway( char *away, UIN uin );
void loadKxicqConfig();
void setupNewConfig();
void unix2dos( char *txt );
void dos2config( char *txt );
void config2dos( char *txt, unsigned int len );
void loggedon();
void searchResult( SEARCH_RESULT *result );
void infoResult( SEARCH_RESULT *result );
void extInfoResult( EXT_SEARCH_RESULT *result );
void loggedIn();
void updateContact( unsigned int uin );
void message( MESSAGE *message );
void url( URL *url );
void added( ADDED *added );
void disconnected();
int askRead( UIN uin );
int ifMsg( UIN );
void saveMsgs();
void newUin( UIN uin );

void nickChange( UIN uin, char *nick, int status );

class mainWin : public KTopLevelWidget
{
        Q_OBJECT
    public:
        mainWin( QWidget *, const char *name );
        ~mainWin();

        QDialog *td;
        int initICQ( int );
        //      void readMsgs();
        void WloggedIn();
        void Wdisconnected();
        void WupdateContact( unsigned int uin );
        void Wmessage( MESSAGE *message );
        void Wurl( URL *url );
        void Wadded( ADDED *added );
        void WsearchResult( SEARCH_RESULT *result );

        //void userConfigure(USER_CONFIGURATION &user_cfg);
        void callbackSetup( CALLBACK_FUNCTIONS &callback_functions );
        void timerEvent( QTimerEvent * );
        QTimer *animatedLogoTimer;
        QTimer *blinkIcons;

        int addUser( const char *nick, UIN uin );
        //        void sendMsg(UIN uin, QString nick);

        QList < QPixmap > *animatedLogo;
        int animatedLogoCounter;
        int timerRun;
        int currentStatus;

        KStatusBar *sb;
        Users *availList;
        void makeSound( int );
        QPopupMenu *fileMenu, *editMenu, *viewMenu, *menu, *helpMenu;
    private:
        QLineEdit *userEdit;
        KAudio *play;

        QAccel *accelKeys;
        KStatusBar *statusBar;
        KMenuBar *menuBar;

        //      KTreeList *listTree;
        QDate tijd;
        int type, cellRow, cellCol;

        QFrame *mainFrame, *viewFrame;

        KToolBar *toolBar;
        KConfig *config;
        void showInfoA( int p );
        void showInfoO( int p );

        public slots:
            void BlinkIcons();
        void setAway( int );
        void setBack( int );
        void setDND( int );

        void searchUsers();
        void reInitICQ();
        void setAwayMsg();
        void discon();
        void conn();

        void setNA( int );
        void setOccu( int );
        void setFFC( int );
        void setInvi( int );
        void doGroup(int);
        void paintEvent( QPaintEvent * );
        void quit();
        void shutDown();
        void help_about();
        void help_aboutXlib();
        void help_aboutQT();
        void configShow();

        void slotAnimatedLogoTimeout();


        /*      void setWeekView();
        */
        void resizeEvent( QResizeEvent * );

};

class DockView : public QWidget
{
        Q_OBJECT
    public:
        DockView();
        ~DockView() {
        }
        int showM, status;
        QPixmap showPixmap;

    public:
        void setStatus( int );
        void doDockPress();
        void showMenu(int,int);
        QPopupMenu *menu;

    public slots:
        void setAway();
        void setBack();
        void setDND();
        void setNA();
        void setOccu();
        void setFFC();
        void setInvi();
        void showWindow();


    protected:
        void paintEvent( QPaintEvent * );
        void mouseDoubleClickEvent( QMouseEvent * );
        void mousePressEvent( QMouseEvent * );
};


#endif
