/**************************************************************************
   * libXicq - Originally written by tnc (xtrophy@it.dk)                     *
   *'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
   * structs.h                                                               *
   * Structures used in libXicq                                              *
   **************************************************************************/


#ifndef _STRUCTS_H
#define _STRUCTS_H

#define UIN unsigned int

#include <sys/time.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>

/*
   **
   ** Holds all config stuff, like which server to use, uin, pwd etc
*/
struct USER_CONFIGURATION {
    unsigned int	uin;
    char	*password;
    char	*nick;
    char	*firstName;
    char	*lastName;
    char	*email;
    unsigned int	status;
    unsigned int	defaultStatus;
    int	showoffline;
    char	*contactList;
    char	*serverAddr;
    int	serverPort;
    int	clientPort;
    char	*logfile;
    char	*awaymsg;

};

/*
   struct USER_CONFIGURATION
   {
   unsigned long  int uin;
   char               password[NAMESIZE];
   char               nick[NAMESIZE];
   char               firstName[NAMESIZE];
   char               lastName[NAMESIZE];
   char               email[BUFSIZE];
   unsigned long  int status;
   unsigned long  int defaultStatus;
   int                showoffline;
   char               contactList[BUFSIZE];
   char               serverAddr[BUFSIZE];
   int                serverPort;
   int                clientPort;
   };
*/

/*
   **
   ** Holds all networking information, like addresses, ports etc
*/
struct TCP_CLIENT
{
};


struct NET_INFORMATION
{
    char *serverAddr; 	// The icq server we're using
    int serverPort; 	// Port to use on the server
    int sock;
    unsigned int clientAddr; 	// Our ip
    int clientPort; 	// Our listen port
    int tcpsock;

};

/*
   struct NET_INFORMATION
   {
   char serverAddr[BUFSIZE];   // The icq server we're using
   int  serverPort;            // Port to use on the server
   int  sock;
 
   char clientAddr[BUFSIZE];   // Our ip
   int  clientPort;            // Our listen port
   };
*/

/*
   **
   ** Packet structure, length, data, command, sequence etc.
*/
struct ICQ_PACKET
{
    int length;
    unsigned char data[ BUFSIZE ];
    unsigned int command;
    unsigned int sequence;
};


/*
   **
   ** Structure of the contact list
*/
struct CONTACT
{
    char nick[ 20 ];
    unsigned int uin;
    unsigned int status;
    unsigned int ip;
    unsigned int real_ip;
    unsigned short int port;
    char *awaymsg;
    int sock;
    int chatsock, listensock;
    unsigned short int chatport;
    void *clas;
    int active;
    int server;
    unsigned char fr,fg,fb,br,bg,bb;
    unsigned short int len;
    unsigned char *data, *rpacket;
    unsigned short int chatlen;
    unsigned char *chatdata, *chatrpacket;
    unsigned int chatseq;

    //    unsigned long ip;
    //    unsigned short port;
    struct timeval tvt;
    fd_set fd;
    struct sockaddr_in client;

};


/*
   **
   ** Time struct
*/
struct TIME
{
    unsigned short int year;
    unsigned char month;
    unsigned char day;
    unsigned char hour;
    unsigned char min;
};


/*
   **
   ** Struct for messages
*/
struct MESSAGE
{
    int online;  // 1=Online, 0=Offline
    TIME time;                  // Online=Localtime, Offline=Servertime
    unsigned int sender;
    int length;
    char *message;
};


/*
   **
   ** Struct for URLs
*/
struct URL
{
    int online;
    TIME time;
    unsigned int sender;
    char *url;
    char *desc;
};


/*
   **
   ** Struct for "You've been added" msgs
*/
struct ADDED
{
    int online;
    TIME time;
    unsigned int sender;
    char *nick;
    char *firstName;
    char *lastName;
    char *email;
    int auth;
    int auth_req;
    char *auth_text;
};


/*
   **
   ** Struct for Search results
*/
struct SEARCH_RESULT
{
    unsigned int uin;
    char *nick;
    char *firstName;
    char *lastName;
    char *email;
    int auth;
    unsigned short int seq;

};

struct EXT_SEARCH_RESULT
{
    unsigned int uin;
    char *city;
    char *state;
    unsigned short int country_code;
    unsigned short int age;
    unsigned char sex;
    char *phone;
    char *home_page;
    char *about;
    unsigned short int seq;
};


// unknown replys
#define PASSWD 1
#define UUIN 2

/*
   **
   ** Holds pointers to the callback functions the UI set up
*/

struct CALLBACK_FUNCTIONS
{
    void ( *loggedIn ) ( void );  // We're logged in
    void ( *disconnected ) ( void ); // We lost the connection
    void ( *updateContact ) ( unsigned int uin );  // Contact list was updated
    void ( *message ) ( MESSAGE * message ); // Got a message
    void ( *url ) ( URL * url ); // Got an URL
    void ( *added ) ( ADDED * added ); // Was added to contact list
    void ( *searchResult ) ( SEARCH_RESULT * result ); // Result of search query
    void ( *infoResult ) ( SEARCH_RESULT * result ); // Result of search query
    void ( *extInfoResult ) ( EXT_SEARCH_RESULT * result ); // Result of search query
    void ( *showAway ) ( char * msg, UIN uin );  // show awayMSG
    void ( *newUin ) ( UIN uin );  // got new UIN
    void ( *addnewUser ) ( UIN uin );  // new user add by TCP stuff
    void ( *nickChange ) ( UIN uin, char * nick, int status );
    void ( *doChat ) ( UIN uin );
    void ( *putChar ) ( UIN uin, char * data, int len );
    void ( *closeChat ) ( UIN uin );
    void ( *cancelChat ) ( UIN uin );
    void ( *chatRequest ) ( UIN uin, char * mesg );
    void ( *unknownReply ) ( int type );
    void ( *getChatInfo ) ( UIN uin );
    void ( *searching ) ( UIN uin );
};


#define SEARCH_CLASS  1
#define SEARCH_NICK   2
#define EMPTY 0
#define SEARC_MAX 10

struct SEARCH_SYSTEM
{
    void *classpointer;
    int type;
    UIN uin;
    int seq;
};

#endif
