/*
   $Id: libXicq.cc,v 2.25.4.3 1998/12/12 14:49:10 herwinjs Exp $
 
   ***************************************************************************
   * libXicq - Originally written by tnc (xtrophy@it.dk)                     *
   *'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
   * libXicq.cc                                                              *
   * Glues the library together                                              *
   **************************************************************************/



#include "libXicq.h"

#define MAXCLIENTS 25

NET_INFORMATION net_information;
USER_CONFIGURATION user_config;
CALLBACK_FUNCTIONS callback;

// Filedescripters for select()
struct timeval tv, tvtcp;
fd_set fd1, fd2, fd3tcp, fd4tcp, clientsfd;

// Used to time 'keep alive' packets
time_t keepAliveTime = time( NULL );

#define MAXWATCH 25
extern unsigned short int lastRecvd[ MAXWATCH ];  // Last received sequences

extern struct TCP_CLIENT TCP_CLIENTS[ MAXCLIENTS ];
extern CONTACT contactList[ MAXCONTACT ];
extern int contactNum;
struct UNKNOWNS unknownSocket[ MAXCLIENTS ];
extern int logincounter;
extern int contact2Uin[ 100 ];
/*
   **
   ** Sets up the callback functions, used to send info to the UI.
*/
void setupCallbacks( CALLBACK_FUNCTIONS cbf )
{
    callback = cbf;
}


/*
   **
   ** Initializes the library
   ** Returns -1 if something goes wrong
*/
int icq_init( USER_CONFIGURATION *user_cfg )
{
    if ( KXDEBUG )
        icq_printInfo();

    user_config = *user_cfg;
    user_config.status = STATUS_OFFLINE;         // Not connected yet
    logincounter = 0;
    if ( KXDEBUG )
    {
        printf( "UIN  : %d\n", user_config.uin );
        printf( "PWD  : %s\n", user_config.password );
        printf( "NICK : %s\n", user_config.nick );
        printf( "FIRST: %s\n", user_config.firstName );
        printf( "LAST : %s\n", user_config.lastName );
        printf( "EMAIL: %s\n", user_config.email );
        printf( "STAT : %d\n", user_config.defaultStatus );
        printf( "LIST : %s\n", user_config.contactList );
        printf( "ADDR : %s\n", user_config.serverAddr );
        printf( "PORT : %d\n", user_config.serverPort );
    }

    if ( net_init( &user_config ) == -1 )      // Initialize networking
        return - 1;
    for ( int y = 0; y < MAXCLIENTS; y++ )
    {
        unknownSocket[ y ].sock = 0;
        unknownSocket[ y ].len = 0;
        unknownSocket[ y ].data = NULL;
        unknownSocket[ y ].rpacket = NULL;
    }
    int i;
    for ( i = 0; i < MAXWATCH; i++ )
        lastRecvd[ i ] = 65500;

    for ( i = 0; i < 100; i++ )
        contact2Uin[ i ] = 0;

    // Set up FDs for select()
    FD_ZERO( &fd2 );
    FD_SET( net_information.sock, &fd2 );
    FD_SET( 0, &fd2 );

    FD_ZERO( &fd3tcp );
    FD_SET( net_information.tcpsock, &fd3tcp );
    FD_SET( 0, &fd3tcp );
    if ( KXDEBUG )
        misc_log( "Icq initialized." );

    return 0;
}
/*
   **
   ** Prints information about this library
*/
void icq_printInfo()
{
}

/*
   ** This is to be called whenever the client is idle.
   ** Get packets if any, parse 'em, do the callback etc
   ** Returns -1 if something is wrong
*/
int icq_main()
{
    int y;
    tvtcp.tv_sec = 0;
    tvtcp.tv_usec = 250;
    fd4tcp = fd3tcp;

    //new user ??
    if ( net_information.tcpsock > 0 )
    {
        select( net_information.tcpsock + 1, &fd4tcp, NULL, NULL, &tvtcp );
        if ( FD_ISSET( net_information.tcpsock, &fd4tcp ) )
        {
            if ( KXDEBUG ) printf( "Accept()\n" );
            struct sockaddr_in addr;
            unsigned int size = sizeof( sockaddr_in );
            int newsock = accept( net_information.tcpsock, ( struct sockaddr * ) & addr, &size );
            setnonblocking( newsock );
            for ( y = 0; y < MAXCLIENTS; y++ )
            {
                if ( unknownSocket[ y ].sock == 0 )
                {
                    if ( KXDEBUG ) printf( "new unknown sock: %d -> %d\n", newsock, y );
                    unknownSocket[ y ].sock = newsock;
                    unknownSocket[ y ].len = 0;
                    unknownSocket[ y ].data = NULL;
                    unknownSocket[ y ].rpacket = NULL;
                    y = MAXCLIENTS + 1;
                }
            }

            /*
            	    unsigned char data[3];
            	    packet=(unsigned char*)malloc(BUFSIZE);
            	    recvd = recv(newsock, data, 2, 0);
            	    unsigned short *len;
             
            	    len=(unsigned short*)(data);
            	    //   printf("len receive: %d\n",*len);
            	    if (recvd!=0 && recvd!=-1)
            	    {
            	    recvd = recv(newsock, packet,*len, 0);
            	    if (recvd!=0 && recvd!=-1)
            	    {
            	    //    printf("len receive: %d -> %d\n",*len, recvd);
            	    parseTCP(packet, newsock, *len);
            	    }
            	    }
            	    free(packet);
            */
        }
    }
    // check all the socks that are open... and read only one packet !!
    int high = 0;
    FD_ZERO( &clientsfd );
    for ( y = 0; y < MAXCLIENTS; y++ )
    {
        if ( unknownSocket[ y ].sock > 0 )
        {
            if ( KXDEBUG ) printf( "add unknown to list ( %d )\n", unknownSocket[ y ].sock );
            FD_SET( unknownSocket[ y ].sock, &clientsfd );
            if ( unknownSocket[ y ].sock > high )
                high = unknownSocket[ y ].sock;
        }
    }

    for ( y = 0; y <= contactNum; y++ )
    {
        if ( contactList[ y ].sock > 0 )
        {
            FD_SET( contactList[ y ].sock, &clientsfd );
            if ( contactList[ y ].sock > high )
                high = contactList[ y ].sock;
        }
        if ( contactList[ y ].chatsock > 0 )
        {
            //if (KXDEBUG) printf("add chat socket (%d)...\n", contactList[y].chatsock);
            FD_SET( contactList[ y ].chatsock, &clientsfd );
            if ( contactList[ y ].chatsock > high )
                high = contactList[ y ].chatsock;
        }
        if ( contactList[ y ].listensock > 0 )
        {
            FD_SET( contactList[ y ].listensock, &clientsfd );
            if ( contactList[ y ].listensock > high )
                high = contactList[ y ].listensock;
        }
    }
    //	 if (FD_ISSET(contactList[y].sock, &fd4tcp))
    if ( high )
    {
        tvtcp.tv_sec = 0;
        tvtcp.tv_usec = 250;

        int sel = select( high + 1, &clientsfd, NULL, NULL, &tvtcp );
        if ( sel < 0 )
        {
            printf( "ERROR SELECT\n" );
            exit( 0 );
        }
        if ( sel > 0 )
        {
            if ( KXDEBUG ) printf( "select (%d)...\n", sel );
            for ( y = 0; y <= contactNum; y++ )
            {
                if ( contactList[ y ].sock > 0 )
                {
                    if ( FD_ISSET( contactList[ y ].sock, &clientsfd ) )
                    {
                        net_tcpRecv( y );
                        y = contactNum + 1;
                        continue;
                    }
                }
                if ( contactList[ y ].chatsock > 0 )
                {
                    if ( KXDEBUG ) printf( "wait on chat connection...\n" );
                    if ( FD_ISSET( contactList[ y ].chatsock, &clientsfd ) )
                    {
                        if ( KXDEBUG ) printf( "got new chat connection...\n" );
                        // accept chat connection
                        if ( contactList[ y ].listensock <= 0 )
                        {
                            struct sockaddr_in addr;
                            unsigned int size = sizeof( sockaddr_in );
                            int newsock = accept( contactList[ y ].chatsock, ( struct sockaddr * ) & addr, &size );
                            setnonblocking( newsock );
                            close( contactList[ y ].chatsock );
                            contactList[ y ].chatsock = -1;
                            if ( newsock > 0 )
                            {
                                contactList[ y ].listensock = newsock;
                                contactList[ y ].server = 1;
                                contactList[ y ].active = 0;
                                if ( KXDEBUG ) printf( "chat sock init\n" );
                                y = contactNum + 1;
                                continue;
                            }
                        }
                    }
                }
                if ( contactList[ y ].listensock > 0 )
                {
                    if ( KXDEBUG ) printf( "listen to chatsock..\n" );
                    if ( FD_ISSET( contactList[ y ].listensock, &clientsfd ) )
                    {
                        // get chat text
                        if ( contactList[ y ].active == 1 )
                        {
                            net_ChatRead( y, sel );
                        }
                        else if ( contactList[ y ].server == 1 )
                        {
                            net_ChatServer( y );
                        }
                        else if ( contactList[ y ].server == 2 )
                        {

                            net_ChatServer( y );
                            if ( contactList[ y ].active == 2 )
                            {
                                contactList[ y ].active = 1;
                                if ( KXDEBUG ) printf( "go chat... \n" );
                                ( *callback.doChat ) ( contactList[ y ].uin );
                                if ( KXDEBUG ) printf( "chat started \n" );
                            }
                        }
                        else if ( KXDEBUG ) printf( "chat error....\n" );
                    }
                }
            }
            for ( y = 0; y < MAXCLIENTS; y++ )
            {
                if ( unknownSocket[ y ].sock > 0 )
                {
                    if ( FD_ISSET( unknownSocket[ y ].sock, &clientsfd ) )
                    {
                        // new connection....
                        if ( KXDEBUG ) printf( "new connection\n" );
                        net_newtcpRecv( y );
                    }
                }
            }
        }
    }
    fd1 = fd2;
    tv.tv_sec = 0;
    tv.tv_usec = 250;
    if ( net_information.sock > 0 )
    {
        // See if we got data waiting
        select( net_information.sock + 1, &fd1, NULL, NULL, &tv );

        // We got some data, fetch it
        if ( FD_ISSET( net_information.sock, &fd1 ) )
        {
            if ( KXDEBUG ) printf( "we have new packets waiting" );
            ICQ_PACKET packet;
            packet.length = net_udpRecv( packet.data, BUFSIZE );
            if ( packet.length > 0 )
            {
                packet.command = misc_packet2cmd( &packet );
                packet.sequence = misc_packet2seq( &packet );
                misc_printPacket( &packet );
                // Let's get the packet parsed.
                parse( &packet );
            }
        }
    }
    // Tell the server we're still here
    if ( keepAliveTime + 90 < time( NULL ) && net_information.sock > 0 )
    {
        send_keepAlive();
        keepAliveTime = time( NULL );
    }

    return 0;
}





