/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
// dockwidget.h

#ifndef _DOCKWIDGET_H_
#define _DOCKWIDGET_H_

#include <kwm.h>
#include <kapp.h> 
#include "mainwidget.h"
#include "urlitem.h"

class DockWidget : public QWidget
{
    Q_OBJECT
	
	public:
    DockWidget( class MainWidget* pMW, const char* name );
    ~DockWidget();
    void Dock();
    void UnDock();

 protected:
    void paintEvent(QPaintEvent *e);

    private slots:
	void PaintIcon();
    void mousePressEvent(QMouseEvent *e);
    void ToggleView();
    void Bye();
    void SaveSelectedMenu(int);

 signals:
    void CloseApp();
	
 public slots:
    void UpdateMenu( UrlItem* pUrl, bool add_to_menu );
    void Launch();

 private:
    bool  	m_docked;
    int 	m_selected_menu;
    MainWidget* m_pMWidget;
    QPixmap     m_pixmap;
    QPixmap     m_pixmap_new; 
    bool        m_menu_item_added;
    QPopupMenu* m_pRightMenu;
    QPopupMenu* m_pLeftMenu;
	
};		

#endif //_DOCKWIDGET_H_
