/*
    kirc -- KDE Infrared Remote Control

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)
    Copyright (C) 1997 Nicolas Hadacek <hadacek@via.ecp.fr>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this library; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/
#ifndef KIRCDATA_H
#define KIRCDATA_H

#include <qdict.h>

#include <qobject.h>
#include <qsignal.h>

typedef unsigned long long ullong;

struct KCodeConnectEntry {
  QObject* pReceiver;
  QString sMember;
  QSignal* sig;
};

struct KCodeEntry {
  enum codeType { normal, number, up10, up20, up30, twoDigits };
  enum buttonType { once, often };
  // configKeyCode is used when configuring via configureCodes()
  ullong aCurrentKeyCode, aDefaultKeyCode, aConfigKeyCode;
  QString aCurrentKey, aDefaultKey, aConfigKey;
  codeType typeOfCode;
  buttonType typeOfButton;
  bool bConfigurable;
  int aAccelId;
  bool isEnabled;
  QDict<KCodeConnectEntry> *pConnectDict;
};

/**
*  A function/accelerator pair, used internally by KIRCWidget.
*/
struct KIRCWidgetEntry {
	QString sWidgetName;
	QWidget *pWidget;
};

#endif
