/* 
    kirc -- KDE Infrared Remote Control

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef kirc_h
#define kirc_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_IRC

#include <qdict.h>
#include <qlistview.h>
#include <kconfig.h>
#include <kircdata.h>
#include <qsocketnotifier.h> 
#include <qlineedit.h> 

#define CODE_LENGTH 128

// =================================================================================================
// =================================================================================================

class KIRCClient : public QObject
{

  Q_OBJECT

public:
  KIRCClient( const char * _device = NULL );
  ~KIRCClient();

  bool reConnect( const char * _device );

  bool clientStatus() { return status; }

signals:
  void sendReceivedDataSIGNAL( ullong code, unsigned int count, char * key, char * config );

private slots:
  void receiveDataFromSocketSLOT( int socket );

private:
  bool connect_client();

private:
  const char * device;

  char buf[CODE_LENGTH];
  bool status;

  QSocketNotifier *sn;
  int sockfd;   

  ullong code;
  unsigned int count;
  char *key;
  char *config;
};

// =================================================================================================
// =================================================================================================

class KIRCConfig : public QWidget
{

  Q_OBJECT

public:
  KIRCConfig(QDict<KCodeEntry> *_aCodeDict, QWidget * parent = 0, const char * name = 0 );
  ~KIRCConfig();


public slots:
  void receiveCodeSLOT( ullong code, char * key, char * config );
  void newDictSLOT( QDict<KCodeEntry> *_aCodeDict );

private slots:
  void applySLOT();
  void defaultsSLOT();
  void cancelSLOT();

  void selectionChangedSLOT( QListViewItem * item );
  void textChangedSLOT( const char *);

signals:
  void apply();
  void defaults();
  void cancel();

private:
  QListView *lv;
  QDict<KCodeEntry> *aCodeDict;

  QLineEdit *le;

  QListViewItem *currentItem;
  KCodeEntry *currentCode;

  bool newDictInsert;
  bool selChanged;
};

// =================================================================================================
// =================================================================================================

class KIRCWidget : public QObject
{

  Q_OBJECT

public:
  KIRCWidget( KConfig* pconf );
  ~KIRCWidget();

  bool addCode( const QString& functionName, uint defaultCode, 
		KCodeEntry::codeType type = KCodeEntry::normal,
		KCodeEntry::buttonType button = KCodeEntry::once,
		bool configurable = TRUE );

  void removeCode( const QString& functionName );
  
  unsigned int readCurrentKey( const QString& functionName );
  unsigned int readDefaultKey( const QString& functionName );

  void registerWidget( const QString& widgetName, QWidget* currentWidget );
  
  void connectFunction( const QString& widgetName,const QString& functionName,
			const QObject* receiver, const char* member,
			bool activate = TRUE );

  void disconnectFunction( const QString& widgetName,const QString& functionName );
  void toggleFunction( const QString& widgetName,const QString& functionName, bool activate );

  void disconnectAllFunctions( const QString& widgetName );

  void destroyWidgetEntry( const QString& widgetName );

  void sync();

  bool configureCodes( QWidget *parent );

signals:
  void numKeyReceivedSIGNAL( int dec );
  void specialKeyReceivedSIGNAL( KCodeEntry::codeType );

  // internal use only
  void configDataReceivedSIGNAL( ullong data, char *, char *  );

public slots:
  void applySLOT();
  void defaultsSLOT();
  void cancelSLOT();

private slots:
  void receiveDataSLOT( ullong code, unsigned int count, char * key, char * config );
	
private:
  
  /*
  void internalDisconnectFunction( const QString& widgetName, 
				   KIRCWidgetEntry *pWEntry, KCodeEntry *pEntry, KCodeConnectEntry *pCEntry );
				   */
  void internalDisconnectAll( const QString& widgetName);

  KConfig *pConfig;
  KIRCConfig *kc;
  KIRCClient *ircclient;

  int aAvailableId;
  QDict<KCodeEntry> aCodeDict;
  QDict<KIRCWidgetEntry> aWidgetDict;

  KCodeEntry::codeType keyUP;
  int num,num10;
  
  bool configMode;
};

// =================================================================================================
// =================================================================================================




#endif //HAVE_IRC
#endif
