/**********************************************************************

	--- Qt Architect generated file ---

	File: cfreq.cpp
	Last generated: Mon Mar 22 19:50:02 1999

 *********************************************************************/

#include "cfreq.h"

#define Inherited cfreqData

#ifdef myDEBUG
#define fDEBUG
#endif

cfreq::cfreq
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
  fine = 0;
  freq=freq1=freq10=freq100=freq1000=0;
}


cfreq::~cfreq()
{
}

void cfreq::newIFreq1000SLOT(int f)
{
  freq1000= f;
  freq= freq1000 * 1000 + freq100 * 100 + freq10 * 10 + freq1;
  lcd->display( (double)(freq)/(double)16.0 );
  lcds->display( freq );

  emit frequencyChangedSIGNAL( freq );
}

void cfreq::newIFreq100SLOT(int f)
{
  freq100= f;
  freq= freq1000 * 1000 + freq100 * 100 + freq10 * 10 + freq1;
  lcd->display( (double)(freq)/(double)16.0 );
  lcds->display( freq );

  emit frequencyChangedSIGNAL( freq );
}

void cfreq::newIFreq10SLOT(int f)
{
  freq10= f;
  freq= freq1000 * 1000 + freq100 * 100 + freq10 * 10 + freq1;
  lcd->display( (double)(freq)/(double)16.0 );
  lcds->display( freq );

  emit frequencyChangedSIGNAL( freq );
}

void cfreq::newIFreq1SLOT(int f)
{
  freq1= f;
  freq= freq1000 * 1000 + freq100 * 100 + freq10 * 10 + freq1;
  lcd->display( (double)(freq)/(double)16.0 );
  lcds->display( freq );

  emit frequencyChangedSIGNAL( freq );
}

void cfreq::newFreqSLOT(int f)
{
  freq= f;

  freq1000= f/1000;
  f-=freq1000*1000;
  freq100= f/100;
  f-=freq100*100;
  freq10= f/10;
  f-=freq10*10;
  freq1= f;

  s_freq1000->setValue(freq1000);
  s_freq100->setValue(freq100);
  s_freq10->setValue(freq10);
  s_freq1->setValue(freq1);

  emit frequencyChangedSIGNAL( freq );

#ifdef fDEBUG
  debug("cfreq: new freq %d, fine %d",freq,fine);
#endif
}

void cfreq::newRangeSLOT(int _min, int _max, int _fine)
{
#ifdef fDEBUG
  debug("cfreq: %d -> %d, fine %d",_min,_max,_fine);
#endif
  //s_freq->setRange( _min, _max );
}

#include "cfreq.moc"













