/*
    This file is part of ktvision, a front end to frame grabber cards 
	for the KDE-Project
    
    Copyright (C) 1998 Oliver Burtchen <oliver.burtchen@rz.hu-berlin.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#ifndef TVWIDGET_H
#define TVWIDGET_H

#include "../config.h"

#include <qtabdlg.h>
#include <qpicture.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qlabel.h>
#include <qprogbar.h>
#include <qpopmenu.h>
#include <kwm.h>
#include <klocale.h>
#include "qv4lwin.h"
#include "action.h"
#include "chanlist.h"
#include "Settings.h"
#include "DeviceDlg.h"
#include "PictureDlg.h"
#include "OptionsDlg.h"


class Indicator : public QWidget
{
	Q_OBJECT
public:
	Indicator( QWidget * parent=0);
	void show();
	void specialResize(QResizeEvent *);	

	QLCDNumber * lcd;
	QLabel * label;
	QProgressBar * bar;
	Flag actionFlag;

private:
	int indicatorTimer;	
	void timerEvent (QTimerEvent *);

public slots:
	void setText(const char *);
	void setBar(int);
	void setLcd(int);	
};


	
class TvWidget : public Qv4lWin 
{
    Q_OBJECT

public:
	TvWidget(KApplication *);
	
protected:
	void mouseReleaseEvent ( QMouseEvent *);
	void mousePressEvent ( QMouseEvent *);
	void mouseDoubleClickEvent ( QMouseEvent *);
	void paintEvent ( QPaintEvent *);
	void resizeEvent(QResizeEvent *);
	void timerEvent (QTimerEvent *);
		
	
		
private:
	KConfig * cfg;
	QStrList * actionText;
	QStrList * regions;
	QPixmap * pic;
	QPopupMenu * popup;
	QPopupMenu * poppic;
	Settings * settings;
	ChanList * chanlist;
	Indicator * indicator;
	QTabDialog * preferences;
	DeviceDlg * deviceDlg;
	PictureDlg * pictureDlg;
	OptionsDlg * optionsDlg;
	int mouseTimer;
	int mouseState;
	int aotTimer;
	int v4linit;
	int val[ACTIONNUM];

	void setVal();
		
public slots:
	void readCfg();
	void writeCfg();	
	void changeAction(int);
	void setValByValue(int,int);
	void toggleCap();

			
private slots:	
	void settingsShow();
	void setFormatList(int);	
	void aot();
	void chanlistShow();

signals:
	void clicked( int );

};

		
#endif // TVWIDGET_H
