/***************************************************************************
                          dbhandling.cpp  -  description
                             -------------------
    begin                : Sat Jan 27 2001
    copyright            : (C) 2001 by Edwin Schepers
    email                : zeus@castel.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <unistd.h>
#include <errno.h>

#include <kmessagebox.h>
#include <qstring.h>

#include "mp3entry.h"
#include "dbhandling.h"

//DBHandling::DBHandling(QString dbfilename){
DBHandling::DBHandling(const char *dbfilename){
  DBfilename = new QString(dbfilename);
	listAvailable = false;
	MP3List = new QList<MP3Entry>();
  CDList =  new QList<CDEntry>();

}

DBHandling::DBHandling(QString dbfilename){
	DBfilename = new QString(dbfilename);
	listAvailable = false;
	MP3List = new QList<MP3Entry>();
  CDList =  new QList<CDEntry>();
}
DBHandling::~DBHandling(){
	delete DBfilename;
	delete MP3List;
	delete CDList;
}

QList<MP3Entry> *DBHandling::getFromDB(QString str, bool cs, searchType type) {

 MP3Entry *mp3entry;
 FILE *fileptr;
 QString tmpmsg;
 char line[MAXLINELEN+1];
	bool remove = false;

 if (listAvailable == false) {
    if ((fileptr=fopen(DBfilename->latin1(),"r"))==NULL) {
       printf("unable to open %s\n", (const char*)DBfilename->latin1());
        tmpmsg += "unable to open ";
				tmpmsg += DBfilename->latin1();
				tmpmsg += " : ";
				tmpmsg += strerror(errno);
				KMessageBox::error(0, tmpmsg);
       return NULL;
		}

	 while (fgets(line, MAXLINELEN, fileptr) != NULL) {
 	   mp3entry = getEntry(line);

     switch (type) {
       case Filename:
         //printf("filename='%s'\n", (char*)dbentry->filename);
         if (mp3entry->Filename.find(str, 0, cs) != -1 )  // if found
           MP3List->append(mp3entry);
         break;
        case Artist:
         if (mp3entry->Artist.find(str, 0, cs) != -1)
           MP3List->append(mp3entry);
         break;
       case Title:
          if (mp3entry->Title.find(str, 0, cs) != -1)
           MP3List->append(mp3entry);
         break;
       case Album:
         if (mp3entry->Album.find(str, 0, cs) != -1)
           MP3List->append(mp3entry);
         break;
       case Year:
         if (mp3entry->Year.find(str,0, false) != -1)
           MP3List->append(mp3entry);
         break;
       case cdname:
         if (mp3entry->HD_CDTitle.find(str, 0, false) != -1) {
           MP3List->append(mp3entry);
				 }
         break;
     }
   }
   fclose(fileptr);
 }
 else { // there is already a list
   mp3entry=MP3List->first();
   while( mp3entry != 0) {
     switch (type) {
       case Filename:
         if (mp3entry->Filename.find(str, 0, cs) == -1 )
						remove = true;
         break;
        case Artist:
         if (mp3entry->Artist.find(str, 0, cs) == -1)  // searchstring not found
						remove = true;
         break;
       case Title:
          if (mp3entry->Title.find(str, 0, cs) == -1)  // searchstring not found
						remove = true;
         break;
       case Album:
         if (mp3entry->Album.find(str, 0, cs) == -1)  // searchstring not found
						remove = true;
         break;
       case Year:
         if (mp3entry->Year.find(str, 0, false) == -1)  // searchstring not found
						remove = true;
         break;
       case cdname:
         if (mp3entry->HD_CDTitle.find(str, 0, false) == -1)  // searchstring not found
						remove = true;
         break;
     }
			if ( remove == true )
				MP3List->remove(mp3entry);
			else
				mp3entry=MP3List->next();
			mp3entry=MP3List->current();
			remove = false;
    }
  }

 listAvailable = true;
 return MP3List;
}

MP3Entry *DBHandling::getEntry(char *line) {
 int i=0, j=0;
 MP3Entry *mp3entry;
 char tmpvalue[255+1];

  mp3entry = new MP3Entry();

  while ( line[i] != SEPARATOR)
    tmpvalue[j++] = line[i++];
  tmpvalue[j]=0;
  //printf("where=%s\n", tmpvalue);
  mp3entry->HD_CDTitle = tmpvalue;

  j=0;i++;
  while ( line[i] != SEPARATOR)
    tmpvalue[j++] = line[i++];
  tmpvalue[j]=0;
  mp3entry->Filename = tmpvalue;
  //printf("getEntry() : filename='%s'\n", (char*)dbentry->filename);

  j=0;i++;
  while ( line[i] != SEPARATOR)
    tmpvalue[j++] = line[i++];
  tmpvalue[j]=0;
  //printf("artist=%s\n", tmpvalue);
  if (strlen(tmpvalue) >0) mp3entry->Artist = tmpvalue;

  j=0;i++;
  while ( line[i] != SEPARATOR)
    tmpvalue[j++] = line[i++];
  tmpvalue[j]=0;
  //printf("title=%s\n", tmpvalue);
  if (strlen(tmpvalue) >0) mp3entry->Title = tmpvalue;

  j=0;i++;
  while ( line[i] != SEPARATOR)
    tmpvalue[j++] = line[i++];
  tmpvalue[j]=0;
  //printf("album=%s\n", tmpvalue);
  if (strlen(tmpvalue) >0) mp3entry->Album = tmpvalue;

  j=0;i++;
  while ( line[i] != SEPARATOR && line[i] != '\n')
    tmpvalue[j++] = line[i++];
  tmpvalue[j]=0;
  //printf("DBhandling::getEntry : year='%s'\n", tmpvalue);
  if (strlen(tmpvalue) >0) mp3entry->Year = tmpvalue;

 return mp3entry;
}


/***************************************
	*
	* Build a list with unique CD labels
	*
****************************************/
QList<CDEntry> *DBHandling::buildCDList(void) {
 FILE *fileptr;
 //char filename[MAXFILELEN+1];
 char line[MAXLINELEN+1];
 char cdname[100+1];
 int i;
 CDEntry *cdentry;

 memset(cdname, 0, 101);
// sprintf(filename, "%s", (const char*)DBfilename);
	if ((fileptr=fopen(DBfilename->latin1(), "r")) ==NULL) {
		printf("unable to open %s\n", (char*)DBfilename->latin1());
		QString tmpmsg = "unable to open file : ";
		tmpmsg += "unable to open ";
		tmpmsg += DBfilename->latin1();
		tmpmsg += " : ";
		tmpmsg += strerror(errno);
		printf("before KMessage\n");
//		KMessageBox::error(0, tmpmsg);
		printf("after KMessage\n");
		return CDList;
	}

 while (fgets(line, MAXLINELEN, fileptr) != NULL) {
   if (line[0] == '<' ) { // cd name is found
   //printf("buildCDList : line=%s\n", line);
     i=1;
     while (line[i] != SEPARATOR) {
       cdname[i-1] = line[i];
       i++;
     }
     cdname[i-2]=0; // deleting the ending '>'
     if (strlen(cdname)==0) strcpy(cdname, "- No description -");

     cdentry = new CDEntry(cdname);
     CDEntry  *tmpcd;
     int cdfound=0;
     for (tmpcd = CDList->first(); tmpcd !=0; tmpcd = CDList->next())
       if (strcmp(tmpcd->CDName, cdname) == 0) {
         //printf("buildCDList() : appending cd to list, cd=%s\n", cdname);
         cdfound=1;
       }
     if (!cdfound) CDList->append(cdentry);
   }
 }
 fclose(fileptr);
	return CDList;
}

void DBHandling::deleteFromDB(MP3Entry *entry) {
 FILE *fileptr;
 FILE *tmpfileptr;
 char line[MAXLINELEN+1];
 char lineToSearch[MAXLINELEN+1];
 char tmpfile[255+1];
 QString tmpmsg;

 if ((fileptr=fopen(DBfilename->latin1(),"r"))==NULL) {
        tmpmsg += "unable to open ";
				tmpmsg += DBfilename->latin1();
				tmpmsg += " : ";
				tmpmsg += strerror(errno);
				 KMessageBox::error(0, tmpmsg);
  		return;
 }

 sprintf(tmpfile, "%s.%d", (const char*)DBfilename->latin1(), getpid());
 if ((tmpfileptr=fopen(tmpfile,"w"))==NULL) {
        tmpmsg += "unable to open ";
				tmpmsg += DBfilename->latin1();
				tmpmsg += " : ";
				tmpmsg += strerror(errno);
				 KMessageBox::error(0, tmpmsg);
  		return;
 }
 sprintf(lineToSearch,"%s%c%s%c%s%c%s%c%s%c%s\n",
         entry->HD_CDTitle.latin1(), SEPARATOR,
         entry->Filename.latin1(), SEPARATOR,
         strcmp(entry->Artist.latin1(),"-unknown-")==0 ? "" : entry->Artist.latin1(), SEPARATOR,
         strcmp(entry->Title.latin1(),"-unknown-")==0 ? "" : entry->Title.latin1(), SEPARATOR,
         strcmp(entry->Album.latin1(),"-unknown-")==0 ? "" : entry->Album.latin1(), SEPARATOR,
				 strcmp(entry->Year.latin1(),"-unknown-")==0 ? "" : entry->Year.latin1());
 printf("about to delete line '%s'\n", lineToSearch);
 while (fgets(line, MAXLINELEN, fileptr) != NULL) {
   if (strcmp(line, lineToSearch) == 0) {
     // delete this line
     //printf("deleting line '%s'\n", line);
   }
   else {
     fprintf(tmpfileptr, line);
   }
 }

 fclose(fileptr);
 fclose (tmpfileptr);
 unlink((const char*)DBfilename->latin1());					// delete old databasse
 rename(tmpfile,(const char*)DBfilename->latin1());  // rename new database
}

//
// description : delete all entries with filename beginning with startpath
//
void DBHandling::deleteFromDB(QString *startpath) {
 FILE *fileptr;
 FILE *tmpfileptr;
 char line[MAXLINELEN+1];
 char tmpline[MAXLINELEN+1];
 char tmpfile[255+1];
 QString tmpmsg;
 char delim[10];
 char *filenameentry;

 sprintf(delim, "%c", SEPARATOR);

 if ((fileptr=fopen(DBfilename->latin1(),"r"))==NULL) {
        tmpmsg += "unable to open ";
				tmpmsg += DBfilename->latin1();
				tmpmsg += " : ";
				tmpmsg += strerror(errno);
				 KMessageBox::error(0, tmpmsg);
  		return;
 }

 sprintf(tmpfile, "%s.%d", (const char*)DBfilename->latin1(), getpid());
 if ((tmpfileptr=fopen(tmpfile,"w"))==NULL) {
        tmpmsg += "unable to open ";
				tmpmsg += DBfilename->latin1();
				tmpmsg += " : ";
				tmpmsg += strerror(errno);
				 KMessageBox::error(0, tmpmsg);
  		return;
 }
 //printf("about to delete line '%s'\n", line);
 while (fgets(line, MAXLINELEN, fileptr) != NULL) {
		strcpy(tmpline, line);
		strtok(tmpline, delim);
		filenameentry = strtok(NULL, delim);

   if (strncmp(filenameentry, startpath->latin1(), strlen(startpath->latin1())) == 0) {
#warning "bug : also when not recursive, all files with the chosen dir will be deleted"
     // delete this line cq. don't do anything, don't write in the tmp file
     //printf("deleting line '%s'\n", line);
   }
   else {
     fprintf(tmpfileptr, line);
   }
 }

 fclose(fileptr);
 fclose (tmpfileptr);
 unlink((const char*)DBfilename->latin1());					// delete old databasse
 rename(tmpfile,(const char*)DBfilename->latin1());  // rename new database
}


void DBHandling::changeEntry(QString filename, QString artist, QString title, QString album, QString year) {
 FILE *oldfileptr;
 FILE *newfileptr;
 char line[MAXLINELEN+1];
 char tmpline[256+1];
 char tmpfile[256+1];
 char cdhdentry[100];
 char *tmpcdhdentry;
 char *filenameentry;
 char delim[10];
 QString tmpmsg;

 sprintf(delim, "%c", SEPARATOR);
 if ((oldfileptr=fopen(DBfilename->latin1(),"r"))==NULL) {
//      tmpmsg = "unable to open file : ";
 //     tmpmsg += mp3dbpath;
      //QMessageBox::warning(this, "Error", (char*)tmpmsg);
                return;
 }

 sprintf(tmpfile, "%s.%d", DBfilename->latin1(), getpid());
 if ((newfileptr=fopen(tmpfile,"w"))==NULL) {
 //     tmpmsg = "unable to open file : ";
 //     tmpmsg += tmpfile;
      //QMessageBox::warning(this, "Error", (char*)tmpmsg);
                return;
 }

  // btw : this doesn't work if there are 2 the same entries in the same directory structure on 2 different cd's
	while (fgets(line, MAXLINELEN, oldfileptr) != NULL) {
		printf("changeEntry() : line=%s\n", line);
		strcpy(tmpline, line);
		tmpcdhdentry = strtok(tmpline, delim);
		filenameentry = strtok(NULL, delim);

		if ( strcmp(filenameentry, filename.latin1())==0) {
			// same, so keep 1st entry(=column in file)
			strcpy(cdhdentry, tmpcdhdentry);
		}
		else {
			// write the line to the new file
			fprintf(newfileptr, line);
		}
	}

 // old entry is deleted. now add new entry
 sprintf(tmpline, "%s%c%s%c%s%c%s%c%s%c%s\n", cdhdentry, SEPARATOR, filename.latin1(),
           SEPARATOR, artist.latin1(), SEPARATOR, title.latin1(), SEPARATOR, album.latin1(), SEPARATOR, year.latin1());
 fprintf(newfileptr, tmpline);

 fclose(oldfileptr);
 fclose(newfileptr);
 unlink(DBfilename->latin1());                                        // delete old databasse
 rename(tmpfile,DBfilename->latin1());  // rename new database

}


int DBHandling::saveToDatabase(QList<MP3Entry> *MP3List, tMedium medium) {

 FILE *fileptr;
 QString tmpmsg;
 char line[255+1];
 bool isAlready=false;
 char lineToWrite[255+1];
 MP3Entry *mp3entry;

	for (mp3entry=MP3List->first(); mp3entry != 0; mp3entry=MP3List->next() ) {

	isAlready=false;
 if ((fileptr=fopen(DBfilename->latin1(),"a+"))==NULL) {
    tmpmsg = "unable to open databse : ";
    tmpmsg += DBfilename->latin1();
    tmpmsg += "\n\n";
    tmpmsg += strerror(errno);
    //QMessageBox::warning(this, "Error", tmpmsg);
    return -1;
 }

 switch (medium) {
  case HD:
   sprintf(lineToWrite, "HD%c%s%c%s%c%s%c%s%c%s", SEPARATOR, mp3entry->Filename.latin1(),
           SEPARATOR, mp3entry->Artist.latin1(), SEPARATOR, mp3entry->Title.latin1(), SEPARATOR,
						mp3entry->Album.latin1(), SEPARATOR, mp3entry->Year.latin1());
   break;
  case CD:
   //printf("cdrompath=%s\n", (const char*)cdrompath);
   sprintf(lineToWrite, "<%s>%c%s%c%s%c%s%c%s%c%s", mp3entry->HD_CDTitle.latin1(), SEPARATOR,
           mp3entry->Filename.latin1(), SEPARATOR, mp3entry->Artist.latin1(),
           SEPARATOR, mp3entry->Title.latin1(), SEPARATOR, mp3entry->Album.latin1(),
						SEPARATOR, mp3entry->Year.latin1());
 }
 //printf("saveToDatabase : line to write '%s'\n", lineToWrite);

 // set the pointer to the beginning of the file and find out if it's already there
 rewind(fileptr);
 while ( fgets(line, 255,fileptr) != NULL ) {
  if (strstr(line,mp3entry->Filename.latin1())) {
     isAlready=true;
     //printf("%s already in the database\n",mp3entry->Filename.latin1());
     break;
  }
 }

 fclose(fileptr);
 if ((fileptr=fopen(DBfilename->latin1(), "a+"))==NULL) {
    tmpmsg = "unable to open databse : ";
    tmpmsg += DBfilename->latin1();
    tmpmsg += "\n\n";
    tmpmsg += strerror(errno);
		printf("%s", tmpmsg.latin1());
    //QMessageBox::warning(this, "Error", tmpmsg);
    return -1;
 }
 if (!isAlready) {
   //printf(" new mp3 : %s\n", lineToWrite);
   fprintf(fileptr, "%s\n", lineToWrite);
 }

 fclose(fileptr);
}
 return 0;
}




