/***************************************************************************
                          quantaview.cpp  -  description
                             -------------------
    begin                :   18 23:09:05 EET 1999
    copyright            : (C) 1999 by Yacovlev Alexander & Dmitry Poplavsky
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <time.h>

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qlayout.h>
#include <qsize.h>
#include <qframe.h>
#include <qwidgetstack.h>

// include files for KDE
#include <kapp.h>
#include <kiconloader.h>
#include <ktoolbar.h>
#include <html.h>
#include <ktabctl.h>
#include <kcolordlg.h>

// application specific includes
#include "quantaview.h"
#include "quantadoc.h"
#include "quanta.h"
#include "kwview.h"
#include "kwdoc.h"
#include "filetabbar.h"

// dialogs headers
#include "tagmaildlg.h"
#include "tagquickstart.h"
#include "tagimgdlg.h"
#include "tagadlg.h"
#include "tagfontdlg.h"
#include "tagquicklistdlg.h"
#include "tagquicktable.h"
#include "tagtabledlg.h"
#include "tagtablerow.h"
#include "tagtablehead.h"
#include "tagform.h"
#include "tagformbutton.h"
#include "tagformtext.h"

// resource headers
#include "resource.h"

#include "pics/quick_start.xpm"
#include "pics/tag_bold.xpm"
#include "pics/tag_h1.xpm"
#include "pics/tag_h2.xpm"
#include "pics/tag_h3.xpm"
#include "pics/tag_h4.xpm"
#include "pics/tag_h5.xpm"
#include "pics/tag_i.xpm"
#include "pics/tag_u.xpm"
#include "pics/tag_p.xpm"
#include "pics/tag_br.xpm"
#include "pics/tag_nbsp.xpm"
#include "pics/div_left.xpm"
#include "pics/div_right.xpm"
#include "pics/div_center.xpm"
#include "pics/div_justify.xpm"
#include "pics/font_inc.xpm"
#include "pics/font_dec.xpm"
#include "pics/tag_hr.xpm"
#include "pics/tag_comm.xpm"
#include "pics/tag_pre.xpm"
#include "pics/tag_sub.xpm"
#include "pics/tag_sup.xpm"
#include "pics/tag_table.xpm"
#include "pics/tag_th.xpm"
#include "pics/tag_tr.xpm"
#include "pics/tag_td.xpm"
#include "pics/tag_caption.xpm"
#include "pics/tag_ul.xpm"
#include "pics/tag_ol.xpm"
#include "pics/tag_li.xpm"
#include "pics/tag_dl.xpm"
#include "pics/tag_dt.xpm"
#include "pics/tag_dd.xpm"
#include "pics/tag_menu.xpm"
#include "pics/tag_mail.xpm"
#include "pics/tag_image.xpm"
#include "pics/tag_a.xpm"
#include "pics/tag_font.xpm"
#include "pics/tag_font_base.xpm"
#include "pics/quick_list.xpm"
#include "pics/quick_table.xpm"
#include "pics/tag_table_row.xpm"
#include "pics/table_head.xpm"
#include "pics/table_data.xpm"
#include "pics/color.xpm"
#include "pics/textarea.xpm"
#include "pics/radio.xpm"
#include "pics/check.xpm"
#include "pics/select.xpm"
#include "pics/date.xpm"
#include "pics/form.xpm"
#include "pics/lineedit.xpm"
#include "pics/linepas.xpm"
#include "pics/submit.xpm"
#include "pics/reset.xpm"


QuantaView::QuantaView(QWidget *parent,QuantaApp *_app, const char *name) : QWidget(parent, name)
{
	app = _app;
	doc = app->doc;
	
	topLayout = new QVBoxLayout( this );
	
	bStandard = new KToolBar( this );
	bFonts    = new KToolBar( this );
	bTables   = new KToolBar( this );
	bForms    = new KToolBar( this );
	bLists    = new KToolBar( this );
	bOther    = new KToolBar( this );
	

	QSize s = bStandard->size();
	barHeight = s.height();
		
	bStandard ->setMinimumHeight( barHeight);bStandard ->setMaximumHeight( barHeight);
	bStandard ->setMinimumWidth( 30*barHeight);
	
	bFonts    ->setMinimumHeight( barHeight);bFonts ->setMaximumHeight( barHeight);
	bFonts    ->setMinimumWidth( 30*barHeight);
	
	bTables   ->setMinimumHeight( barHeight);bTables ->setMaximumHeight( barHeight);
	bTables   ->setMinimumWidth( 30*barHeight);
	
	bForms    ->setMinimumHeight( barHeight);bForms ->setMaximumHeight( barHeight);
	bForms    ->setMinimumWidth( 30*barHeight);
	
	bLists    ->setMinimumHeight( barHeight);bLists ->setMaximumHeight( barHeight);
	bLists    ->setMinimumWidth( 30*barHeight);
	
	bOther    ->setMinimumHeight( barHeight);bOther ->setMaximumHeight( barHeight);
	bOther    ->setMinimumWidth( 30*barHeight);
	
	
	// Insert button in tool bars Standard
	bStandard->insertButton( QPixmap((const char**)quick_start_xpm), ID_TAG_QUICKSTART, true, i18n("Quick Start"));
	
	QFrame *separatorLine11= new QFrame( bStandard);
  separatorLine11->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  bStandard->insertWidget( 0,20,separatorLine11);

  bStandard->insertButton( QPixmap((const char**)tag_bold_xpm), ID_TAG_BOLD, true, i18n("Bold"));
	bStandard->insertButton( QPixmap((const char**)tag_i_xpm),ID_TAG_I,    true, i18n("Italic"));
	bStandard->insertButton( QPixmap((const char**)tag_u_xpm),ID_TAG_U,    true, i18n("Underline"));
	
  QFrame *separatorLine12= new QFrame( bStandard);
  separatorLine12->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  bStandard->insertWidget( 0,20,separatorLine12);

	bStandard->insertButton( QPixmap((const char**)tag_br_xpm),  ID_TAG_BR,   true, i18n("New line"));
  bStandard->insertButton( QPixmap((const char**)tag_p_xpm),   ID_TAG_P,    true, i18n("Paragraph"));
  bStandard->insertButton( QPixmap((const char**)tag_nbsp_xpm),ID_TAG_NBSP, true, i18n("Non breaking space"));
	
	QFrame *separatorLine13= new QFrame( bStandard);
  separatorLine13->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  bStandard->insertWidget( 0,20,separatorLine13);

  bStandard->insertButton( QPixmap((const char**)tag_a_xpm),    ID_TAG_A,     true, i18n("Insert anchor"));
  bStandard->insertButton( QPixmap((const char**)tag_image_xpm),ID_TAG_IMAGE, true, i18n("Insert image"));
  bStandard->insertButton( QPixmap((const char**)tag_hr_xpm),   ID_TAG_HR,    true, i18n("Horizontal rule"));
  bStandard->insertButton( QPixmap((const char**)tag_comm_xpm), ID_TAG_COMM,  true, i18n("Comment"));

  QFrame *separatorLine14= new QFrame( bStandard);
  separatorLine14->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  bStandard->insertWidget( 0,20,separatorLine14);

  bStandard->insertButton( QPixmap((const char**)div_left_xpm),   ID_TAG_DIV_LEFT,   true, i18n("Align left"));
  bStandard->insertButton( QPixmap((const char**)div_center_xpm), ID_TAG_DIV_CENTER, true, i18n("Align center"));
  bStandard->insertButton( QPixmap((const char**)div_right_xpm),  ID_TAG_DIV_RIGHT,  true, i18n("Align right"));
  bStandard->insertButton( QPixmap((const char**)div_justify_xpm),ID_TAG_DIV_JUSTIFY,true, i18n("Align justify"));

  	
	// Insert button in tool bars Fonts
	bFonts->insertButton( QPixmap((const char**)tag_font_xpm),      ID_TAG_FONT,      true, i18n("Font"));
	bFonts->insertButton( QPixmap((const char**)tag_font_base_xpm), ID_TAG_FONT_BASE, true, i18n("Base font"));
	
	QFrame *separatorLine21= new QFrame( bFonts);
  separatorLine21->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  bFonts->insertWidget( 0,20,separatorLine21);

	bFonts->insertButton( QPixmap((const char**)font_inc_xpm), ID_TAG_FONT_INC, true, i18n("Font size +1"));
	bFonts->insertButton( QPixmap((const char**)font_dec_xpm), ID_TAG_FONT_DEC, true, i18n("Font size -1"));
	
	QFrame *separatorLine22= new QFrame( bFonts);
  separatorLine22->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  bFonts->insertWidget( 0,20,separatorLine22);

  bFonts->insertButton( QPixmap((const char**)tag_pre_xpm), ID_TAG_PRE, true, i18n("Pre formated"));
  bFonts->insertButton( QPixmap((const char**)tag_sub_xpm), ID_TAG_SUB, true, i18n("Subscript"));
  bFonts->insertButton( QPixmap((const char**)tag_sup_xpm), ID_TAG_SUP, true, i18n("Superscript"));

  QFrame *separatorLine23= new QFrame( bFonts);
  separatorLine23->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  bFonts->insertWidget( 0,20,separatorLine23);

  bFonts->insertButton( QPixmap((const char**)tag_h1_xpm), ID_TAG_H1, true, i18n("Head 1"));
	bFonts->insertButton( QPixmap((const char**)tag_h2_xpm), ID_TAG_H2, true, i18n("Head 2"));
	bFonts->insertButton( QPixmap((const char**)tag_h3_xpm), ID_TAG_H3, true, i18n("Head 3"));
	bFonts->insertButton( QPixmap((const char**)tag_h4_xpm), ID_TAG_H4, true, i18n("Head 4"));
	bFonts->insertButton( QPixmap((const char**)tag_h5_xpm), ID_TAG_H5, true, i18n("Head 5"));
	
	
	// Insert button in tool bars Tables
	bTables->insertButton( QPixmap((const char**)quick_table_xpm),   ID_TAG_QUICK_TABLE,  true, i18n("Quick table"));
	bTables->insertButton( QPixmap((const char**)tag_table_xpm),     ID_TAG_TABLE,        true, i18n("Table"));
	bTables->insertButton( QPixmap((const char**)tag_table_row_xpm), ID_TAG_TABLE_ROW,    true, i18n("Table row"));
	bTables->insertButton( QPixmap((const char**)table_head_xpm),ID_TAG_TABLE_HEAD,   true, i18n("Table head"));
	bTables->insertButton( QPixmap((const char**)table_data_xpm),ID_TAG_TABLE_DATA,   true, i18n("Table data"));
	
	QFrame *separatorLine31= new QFrame( bTables);
  separatorLine31->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  bTables->insertWidget( 0,20,separatorLine31);
	
	bTables->insertButton( QPixmap((const char**)tag_th_xpm),     ID_TAG_TH,     true, i18n("Table head"));
	bTables->insertButton( QPixmap((const char**)tag_tr_xpm),     ID_TAG_TR,     true, i18n("Table row"));
	bTables->insertButton( QPixmap((const char**)tag_td_xpm),     ID_TAG_TD,     true, i18n("Table data"));
	bTables->insertButton( QPixmap((const char**)tag_caption_xpm),ID_TAG_CAPTION,true, i18n("Caption"));
	
	// Insert button in tool bars Forms
	bForms->insertButton( QPixmap((const char**)form_xpm),  ID_TAG_FORM, true, i18n("Form"));
	bForms->insertButton( QPixmap((const char**)radio_xpm),     ID_TAG_RADIO,     true, i18n("Radio button"));
	bForms->insertButton( QPixmap((const char**)check_xpm),     ID_TAG_CHECK,     true, i18n("Check box"));
	bForms->insertButton( QPixmap((const char**)select_xpm),    ID_TAG_SELECT,    true, i18n("Select"));
	bForms->insertButton( QPixmap((const char**)lineedit_xpm),  ID_TAG_LINEEDIT, true, i18n("Text"));
	bForms->insertButton( QPixmap((const char**)linepas_xpm),   ID_TAG_LINEPAS, true, i18n("Password"));
	bForms->insertButton( QPixmap((const char**)textarea_xpm),  ID_TAG_TEXTAREA, true, i18n("Text area"));
	bForms->insertButton( QPixmap((const char**)submit_xpm),    ID_TAG_SUBMIT,    true, i18n("Submit"));
	bForms->insertButton( QPixmap((const char**)reset_xpm),     ID_TAG_RESET,     true, i18n("Reset"));
	
	
	// Insert button in tool bars Lists
	bLists->insertButton( QPixmap((const char**)quick_list_xpm), ID_TAG_QUICK_LIST, true, i18n("Quick list"));
	
	QFrame *separatorLine51= new QFrame( bLists);
  separatorLine51->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  bLists->insertWidget( 0,20,separatorLine51);
	
	bLists->insertButton( QPixmap((const char**)tag_ul_xpm), ID_TAG_UL, true, i18n("Unordered list"));
	bLists->insertButton( QPixmap((const char**)tag_ol_xpm), ID_TAG_OL, true, i18n("Ordered list"));
	bLists->insertButton( QPixmap((const char**)tag_li_xpm), ID_TAG_LI, true, i18n("List item"));
	
	QFrame *separatorLine52= new QFrame( bLists);
  separatorLine52->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  bLists->insertWidget( 0,20,separatorLine52);

  bLists->insertButton( QPixmap((const char**)tag_dl_xpm), ID_TAG_DL, true, i18n("Definition list"));
  bLists->insertButton( QPixmap((const char**)tag_dt_xpm), ID_TAG_DT, true, i18n("Definition term"));
  bLists->insertButton( QPixmap((const char**)tag_dd_xpm), ID_TAG_DD, true, i18n("Definition"));

  QFrame *separatorLine53= new QFrame( bLists);
  separatorLine53->setFrameStyle( QFrame::VLine|QFrame::Sunken);
  bLists->insertWidget( 0,20,separatorLine53);

  bLists->insertButton( QPixmap((const char**)tag_menu_xpm), ID_TAG_MENU, true, i18n("Menu"));

	
	// Insert button in tool bars Other
	bOther->insertButton( QPixmap((const char**)color_xpm),   ID_TAG_COLOR,true, i18n("Color"));
	bOther->insertButton( QPixmap((const char**)tag_mail_xpm),ID_TAG_MAIL, true, i18n("E-Mail"));
	bOther->insertButton( QPixmap((const char**)date_xpm),    ID_TAG_DATE, true, i18n("Date"));

		
	// place tool bars
	bStandard ->setBarPos( KToolBar::Floating);	bStandard ->setBarPos( KToolBar::Top);
	bFonts    ->setBarPos( KToolBar::Floating);	bFonts    ->setBarPos( KToolBar::Top);
	bTables   ->setBarPos( KToolBar::Floating);	bTables   ->setBarPos( KToolBar::Top);
	bForms    ->setBarPos( KToolBar::Floating);	bForms    ->setBarPos( KToolBar::Top);
	bLists    ->setBarPos( KToolBar::Floating);	bLists    ->setBarPos( KToolBar::Top);
	bOther    ->setBarPos( KToolBar::Floating);	bOther    ->setBarPos( KToolBar::Top);
	
	
	bStandard ->enableMoving(false);bStandard ->enableFloating(false);
	bFonts    ->enableMoving(false);bFonts    ->enableFloating(false);
	bTables   ->enableMoving(false);bTables   ->enableFloating(false);
	bForms    ->enableMoving(false);bForms    ->enableFloating(false);
	bLists    ->enableMoving(false);bLists    ->enableFloating(false);
	bOther    ->enableMoving(false);bOther    ->enableFloating(false);
	
	tabBar = new CTabCtl( this );
	
	bStandard -> setFocusPolicy(QWidget::NoFocus);
	bFonts    -> setFocusPolicy(QWidget::NoFocus);
	bTables   -> setFocusPolicy(QWidget::NoFocus);
	bForms    -> setFocusPolicy(QWidget::NoFocus);
	bLists    -> setFocusPolicy(QWidget::NoFocus);
	bOther    -> setFocusPolicy(QWidget::NoFocus);
	
	tabBar->addTab( bStandard, i18n( "&Standard") );
	tabBar->addTab( bFonts   , i18n( "Fo&nts") );
	tabBar->addTab( bTables,   i18n( "&Tables") );
	tabBar->addTab( bForms,    i18n( "Fo&rms") );
	tabBar->addTab( bLists,    i18n( "&Lists") );
	tabBar->addTab( bOther,    i18n( "Oth&er") );
	
	tabBar    -> setFocusPolicy(QWidget::ClickFocus);
	
	topLayout->addWidget( tabBar);
	
	// create document with HL
	static HlManager *hl = new HlManager();
		
  writeStack = new QWidgetStack(this);
  topLayout->addWidget( writeStack,10);

  fileTabBar = new FileTabBar( this);
  fileTabBar->setFocusPolicy(QWidget::NoFocus);
  topLayout->addWidget( fileTabBar);

  KWrite *write = doc->newWrite( this);

  addWrite(write,"Untitled.html");
	
	topLayout->activate();
	
	connect( bStandard, SIGNAL(clicked(int)), SLOT(slotToolbarCallback(int)));
	connect( bFonts,    SIGNAL(clicked(int)), SLOT(slotToolbarCallback(int)));
	connect( bTables,   SIGNAL(clicked(int)), SLOT(slotToolbarCallback(int)));
	connect( bForms,    SIGNAL(clicked(int)), SLOT(slotToolbarCallback(int)));
	connect( bLists,    SIGNAL(clicked(int)), SLOT(slotToolbarCallback(int)));
	connect( bOther,    SIGNAL(clicked(int)), SLOT(slotToolbarCallback(int)));
	connect( fileTabBar,SIGNAL(selected(int)), this, SLOT( selectWrite(int)));
	
	scrollX = scrollY = 0;
}

QuantaView::~QuantaView()
{
}

QuantaDoc *QuantaView::getDocument() const
{
  return doc ;
}

void QuantaView::print(QPrinter *pPrinter)
{
  QPainter printpainter;
  printpainter.begin(pPrinter);
	
  // TODO: add your printing code here


  printpainter.end();
}

/** repaint preview */
void QuantaView::repaintPreview( bool scroll = true ){

  QString text = write()->text();
  const char *tmp = text.data();

  if  ( scroll ) saveScroll();

  if ( !write()->hasFileName() ) {
  	html->begin( ( getDocument()->basePath+QString("/")));
  } else {
    html->begin( getDocument()->getAbsFilePath() );
  }

  html->parse();
  html->write(tmp);

  html->end();
  html->show();

  setScroll();

  repaint();
}

/** Callback for toolbar with tags. */
void QuantaView::slotToolbarCallback( int id ){
	
	column = write()->currentColumn();
	space.fill(' ',column);
	
	switch (id)
  {
    case ID_TAG_BOLD:
    		 write()->insertTag("<b>","</b>");
    	 	 break;
    case ID_TAG_H1:
    		 write()->insertTag("<h1>","</h1>");
    	 	 break;
    case ID_TAG_H2:
    		 write()->insertTag("<h2>","</h2>");
    	 	 break;
    case ID_TAG_H3:
    		 write()->insertTag("<h3>","</h3>");
    	 	 break;
    case ID_TAG_H4:
    		 write()->insertTag("<h4>","</h4>");
    	 	 break;
    case ID_TAG_H5:
    		 write()->insertTag("<h5>","</h5>");
    	 	 break;
    case ID_TAG_I:
    		 write()->insertTag("<i>","</i>");
    	 	 break;
    case ID_TAG_U:
    		 write()->insertTag("<u>","</u>");
    	 	 break;
    case ID_TAG_BR:
    		 slotTagBr();
    	 	 break;
    case ID_TAG_P:
    		 write()->insertTag("<p>");
    	 	 break;
    case ID_TAG_NBSP:
         slotTagNbsp();
    	 	 break;
    case ID_TAG_DIV_LEFT:
    		 write()->insertTag("<div align=\"left\">","</div>");
    	 	 break;
    case ID_TAG_DIV_RIGHT:
    		 write()->insertTag("<div align=\"right\">","</div>");
    	 	 break;
    case ID_TAG_DIV_CENTER:
    		 write()->insertTag("<center>","</center>");
    	 	 break;
    case ID_TAG_DIV_JUSTIFY:
    		 write()->insertTag("<div align=\"justify\">","</div>");
    	 	 break;
    case ID_TAG_FONT_INC:
    		 write()->insertTag("<font size=\"+1\">","</font>");
    	 	 break;
    case ID_TAG_FONT_DEC:
    		 write()->insertTag("<font size=\"-1\">","</font>");
    	 	 break;
    case ID_TAG_TH:
    		 write()->insertTag("<th>","</th>");
    	 	 break;
    case ID_TAG_TR:
    		 write()->insertTag("<tr>","</tr>");
    	 	 break;
    case ID_TAG_TD:
    		 write()->insertTag("<td>","</td>");
    	 	 break;
    case ID_TAG_CAPTION:
    		 write()->insertTag("<caption>","</caption>");
    	 	 break;
    case ID_TAG_COMM:
    		 write()->insertTag("<!-- "," -->");
    	 	 break;
    case ID_TAG_PRE:
    		 write()->insertTag("<pre>","</pre>");
    	 	 break;
    case ID_TAG_SUB:
    		 write()->insertTag("<sub>","</sub>");
    	 	 break;
    case ID_TAG_SUP:
    		 write()->insertTag("<sup>","</sup>");
    	 	 break;
    case ID_TAG_UL:
    		 write()->insertTag("<ul>","</ul>");
    	 	 break;
    case ID_TAG_OL:
    		 write()->insertTag("<ol>","</ol>");
    	 	 break;
    case ID_TAG_LI:
    		 write()->insertTag("<li>");
    	 	 break;
    case ID_TAG_DL:
    		 write()->insertTag("<dl>","</dl>");
    	 	 break;
    case ID_TAG_DT:
    		 write()->insertTag("<dt>","</dt>");
    	 	 break;
    case ID_TAG_DD:
    		 write()->insertTag("<dd>","</dd>");
    	 	 break;
    case ID_TAG_MENU:
    		 write()->insertTag("<menu>","</menu>");
    	 	 break;
    case ID_TAG_HR:
    		 write()->insertTag("<hr>");
    	 	 break;
    case ID_TAG_SUBMIT:
    		 write()->insertTag("<INPUT TYPE=\"SUBMIT\" NAME=\"name\" VALUE=\"submit\">");
    	 	 break;
    case ID_TAG_RESET:
    		 write()->insertTag("<INPUT TYPE=\"RESET\" NAME=\"name\" VALUE=\"reset\">");
    	 	 break;
    case ID_TAG_LINEEDIT:
    		 slotTagFormLineEdit();
    		 break;
    case ID_TAG_LINEPAS:
    		 slotTagFormPas();
    		 break;
    case ID_TAG_RADIO:
    		 slotTagFormRadio();
    		 break;
    case ID_TAG_CHECK:
    		 slotTagFormCheck();
    		 break;
    case ID_TAG_FORM:
    		 slotTagForm();
    		 break;
    case ID_TAG_MAIL:
    		 slotTagMail();
    		 break;
    case ID_TAG_IMAGE:
    		 slotTagImg();
    		 break;
    case ID_TAG_A:
    		 slotTagA();
    		 break;
    case ID_TAG_FONT:
    		 slotTagFont();
    		 break;
    case ID_TAG_FONT_BASE:
    		 slotTagBaseFont();
    		 break;
    case ID_TAG_QUICK_LIST:
    		 slotTagQuickList();
    		 break;
    case ID_TAG_TABLE:
    		 slotTagTable();
    		 break;
    case ID_TAG_QUICK_TABLE:
    		 slotTagQuickTable();
    		 break;
    case ID_TAG_TABLE_ROW:
    		 slotTagTableRow();
    		 break;
    case ID_TAG_TABLE_HEAD:
    		 slotTagTableHead();
    		 break;
    case ID_TAG_TABLE_DATA:
    		 slotTagTableData();
    		 break;
    case ID_TAG_QUICKSTART:
     		 slotTagQuickStart();
    	 	 break;
    case ID_TAG_COLOR:
     		 slotTagColor();
     	 	 break;
    case ID_TAG_DATE:
     		 slotTagDate();
    	 	 break;
    case ID_TAG_SELECT:
     		 slotTagSelect();
    	 	 break;
    case ID_TAG_TEXTAREA:
     		 slotTagTextArea();
    	 	 break;

    default:
         break;
  }
  repaintPreview();
}

/** insert <img > tag */
void QuantaView::slotTagImg()
{
  TagImgDlg *imgDlg = new TagImgDlg(this,i18n("Insert image..."));

  if ( imgDlg->exec() ) {
  	QString tag1 = QString("<img src=\"")+imgDlg->lineImgSource->text()+QString("\"");
  	if ( !QString(imgDlg->lineWidth->text()).isEmpty() )
  		tag1+=QString(" width=\"")+imgDlg->lineWidth->text()+"\"";
  	if ( !QString(imgDlg->lineHeight->text()).isEmpty() )
  		tag1+=QString(" height=\"")+imgDlg->lineHeight->text()+"\"";
  	if ( !QString(imgDlg->lineAltText->text()).isEmpty() )
  		tag1+=QString(" alt=\"")+imgDlg->lineAltText->text()+QString("\"");
  	if ( !QString(imgDlg->lineHSpace->text()).isEmpty() )
  		tag1+=QString(" hspace=\"")+imgDlg->lineHSpace->text()+"\"";
  	if ( !QString(imgDlg->lineVSpace->text()).isEmpty() )
  		tag1+=QString(" vspace=\"")+imgDlg->lineVSpace->text()+"\"";
  	if ( !QString(imgDlg->comboAlign->currentText()).isEmpty() )
  		tag1+=QString(" align=\"")+imgDlg->comboAlign->currentText()+"\"";
  	if ( imgDlg->spinBorder->value()!=1 )
  		tag1+=QString(" border=\"")+imgDlg->spinBorder->text()+"\"";
  	tag1+=QString(">");
  	
    write()->insertTag(tag1);
  }
  delete(imgDlg);
}

/** for <a href=mailto> tag  */
void QuantaView::slotTagMail(){
	TagMailDlg *mailDlg = new TagMailDlg(this,i18n("Enter E-Mail adress..."));
	
  if ( mailDlg->exec() ) {
     write()->insertTag(QString("<a href=\"mailto:")+mailDlg->comboBoxMail->currentText()+QString("\">"),QString("</a>"));
  }
  delete(mailDlg);
}

/** for <a href> tag */
void QuantaView::slotTagA(){
  TagADlg *aDlg = new TagADlg(this,i18n("Insert link..."));

  if ( aDlg->exec() ) {
	   QString tag = QString("<a");
	   if ( !QString(aDlg->comboHREF->currentText()).isEmpty())
	   		tag += QString(" href=\"")+aDlg->comboHREF->currentText()+QString("\"");
	   if ( !QString(aDlg->comboTarget->currentText()).isEmpty())
	   		tag += QString(" target=\"")+aDlg->comboTarget->currentText()+QString("\"");
	   if ( !QString(aDlg->lineName->text()).isEmpty())
	   		tag += QString(" name=\"")+aDlg->lineName->text()+QString("\"");
	   tag += QString(">");
	   if ( !QString(aDlg->lineDescription->text()).isEmpty())
	   		tag += aDlg->lineDescription->text();
	   write()->insertTag(tag,QString("</a>"));
   }
   delete(aDlg);
}
/** quick html text generate */
void QuantaView::slotTagQuickStart(){
	TagQuickStart *quickDlg = new TagQuickStart(this,i18n("Generate HTML text..."));

  if ( quickDlg->exec() ) {
  	QString tag = QString("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">\n<html>\n")
  	                  +space+QString("<head>\n")+space+QString("\t<title>");
  	if ( !QString(quickDlg->lineTitle->text()).isEmpty())
	   		tag += quickDlg->lineTitle->text();
    tag += QString("</title>\n")+space+QString("</head>\n")+space+QString("<body");
    if ( !QString(quickDlg->lineBGImage->text()).isEmpty())
	   		tag += QString(" background=\"")+quickDlg->lineBGImage->text()+"\"";
	  if ( !QString(quickDlg->comboBGColor->currentText()).isEmpty())
	   		tag += QString(" bgcolor=\"")+quickDlg->comboBGColor->currentText()+"\"";
	  if ( !QString(quickDlg->comboTextColor->currentText()).isEmpty())
	   		tag += QString(" text=\"")+quickDlg->comboTextColor->currentText()+"\"";
	  if ( !QString(quickDlg->comboLinkColor->currentText()).isEmpty())
	   		tag += QString(" link=\"")+quickDlg->comboLinkColor->currentText()+"\"";
	  if ( !QString(quickDlg->comboALinkColor->currentText()).isEmpty())
	   		tag += QString(" alink=\"")+quickDlg->comboALinkColor->currentText()+"\"";
	  if ( !QString(quickDlg->comboVLinkColor->currentText()).isEmpty())
	   		tag += QString(" vlink=\"")+quickDlg->comboVLinkColor->currentText()+"\"";
    tag += QString(">\n")+space+QString("\t");
    write()->insertTag(tag,QString("\n")+space+QString("</body>\n")+space+QString("</html>"));
  }
  delete(quickDlg);
}


/** insert  <font> tag in document */
void QuantaView::slotTagFont(){
	TagFontDlg *fontDlg = new TagFontDlg(this,i18n("Font properties..."));

  if ( fontDlg->exec() ) {
  	QString tag = QString("<font");
  	if ( !QString(fontDlg->comboSize->currentText()).isEmpty())
  		tag += QString(" size=\"") + fontDlg->comboIncDec->currentText()
  				+ fontDlg->comboSize->currentText()+QString("\"");
  				
  	if ( !QString(fontDlg->comboColor->currentText()).isEmpty())
  		tag += QString(" color=\"") + fontDlg->comboColor->currentText()+"\"";
  		
  	if ( !QString(fontDlg->comboFont->currentText()).isEmpty())
  		tag += QString(" face=\"") + fontDlg->comboFont->currentText()+ QString("\"");
  	tag+=">";
    write()->insertTag(tag,QString("</font>"));
  }
  delete(fontDlg);
}

/** insert tag <basefont> */
void QuantaView::slotTagBaseFont(){
	TagFontDlg *fontDlg = new TagFontDlg(this,i18n("Base font properties..."));

  if ( fontDlg->exec() ) {
  	QString tag = QString("<basefont");
  	if ( !QString(fontDlg->comboSize->currentText()).isEmpty())
  		tag += QString(" size=\"") + fontDlg->comboIncDec->currentText()
  				+ fontDlg->comboSize->currentText()+QString("\"");
  				
  	if ( !QString(fontDlg->comboColor->currentText()).isEmpty())
  		tag += QString(" color=\"") + fontDlg->comboColor->currentText()+"\"";
  		
  	if ( !QString(fontDlg->comboFont->currentText()).isEmpty())
  		tag += QString(" face=\"") + fontDlg->comboFont->currentText()+ QString("\"");
  	tag+=">";
    write()->insertTag(tag);
  }
  delete(fontDlg);

}
/** for tag <table> */
void QuantaView::slotTagTable(){
	TagTableDlg *tableDlg = new TagTableDlg(this,i18n("Table properties..."));
  if ( tableDlg->exec() ) {
  	QString tag = QString("<table");
  	if ( tableDlg->spinBorder->value() != 0)
  		tag += QString(" border=\"")+QString(tableDlg->spinBorder->text())+"\"";
  	if ( !QString(tableDlg->comboBGColor->currentText()).isEmpty())
  		tag += QString(" bgcolor=\"")+QString(tableDlg->comboBGColor->currentText())+"\"";
  	if ( !QString(tableDlg->comboAlign->currentText()).isEmpty())
  		tag += QString(" align=\"")+QString(tableDlg->comboAlign->currentText())+"\"";
  	if ( !QString(tableDlg->comboVAlign->currentText()).isEmpty())
  		tag += QString(" valign=\"")+QString(tableDlg->comboVAlign->currentText())+"\"";
  	if ( tableDlg->spinCellPadding->value() != 0)
  		tag += QString(" cellpadding=\"")+QString(tableDlg->spinCellPadding->text())+"\"";
  	if ( tableDlg->spinSpacing->value() != 0 )
  		tag += QString(" cellspacing=\"")+QString(tableDlg->spinSpacing->text())+"\"";
  	tag += QString(">");
  	write()->insertTag(tag,QString("</table>"));
  }
  delete(tableDlg);
}
/** do quick list */
void QuantaView::slotTagQuickList(){
	TagQuickListDlg *listDlg = new TagQuickListDlg(this,i18n("Generate list..."));
  if ( listDlg->exec() ) {
  	int i;
    int n = listDlg->spinBoxRows->value();
    		    	
    QString tag;
    if ( listDlg->radioOrdered->isChecked())
    	tag = QString("<ol>\n")+space;
    else tag = QString("<ul>\n")+space;
    for ( i=0;i<n;i++) tag += QString("\t<li>  </li>\n")+space;
    if ( listDlg->radioOrdered->isChecked())
    	tag += QString("</ol>");
    else tag += QString("</ul>");
    write()->insertTag( tag);
  }
  delete(listDlg);
}
/** for quick create table */
void QuantaView::slotTagQuickTable(){
	int y,x;

	TagQuickTable *quickDlg = new TagQuickTable(this,i18n("Generate table..."));
  if ( quickDlg->exec() ) {
  	y = quickDlg->spinBoxRows->value();
  	x = quickDlg->spinBoxCollums->value();

 	TagTableDlg *tableDlg = new TagTableDlg(this,i18n("Table properties..."));
  if ( tableDlg->exec() ) {
  	QString tag = QString("<table");
  	if ( tableDlg->spinBorder->value() != 0)
  		tag += QString(" border=\"")+QString(tableDlg->spinBorder->text())+"\"";
  		
  	if ( !QString(tableDlg->comboBGColor->currentText()).isEmpty())
  		tag += QString(" bgcolor=\"")+QString(tableDlg->comboBGColor->currentText())+"\"";
  		
  	if ( !QString(tableDlg->comboAlign->currentText()).isEmpty())
  		tag += QString(" align=\"")+QString(tableDlg->comboAlign->currentText())+"\"";
  		
  	if ( !QString(tableDlg->comboVAlign->currentText()).isEmpty())
  		tag += QString(" valign=\"")+QString(tableDlg->comboVAlign->currentText())+"\"";
  		
  	if ( tableDlg->spinCellPadding->value() != 0)
  		tag += QString(" cellpadding=\"")+QString(tableDlg->spinCellPadding->text())+"\"";
  		
  	if ( tableDlg->spinSpacing->value() != 0 )
  		tag += QString(" cellspacing=\"")+QString(tableDlg->spinSpacing->text())+"\"";
  		
  	tag += QString(">\n")+space;
  	
  	for ( int i=0;i<y;i++) {
  		tag += QString("\t<tr>\n")+space;
  		for ( int j=0;j<x;j++)
  			tag += QString("\t\t<td>  </td>\n")+space;
  		tag += QString("\t</tr>\n")+space;
  	}
  	tag += QString("</table>");
  	
  	write()->insertTag(tag);
  }
  delete(tableDlg);
  }
  delete( quickDlg);
}
/** for row properties */
void QuantaView::slotTagTableRow(){
	TagTableRow *rowDlg = new TagTableRow(this,i18n("Table row properties..."));
    		
  if ( rowDlg->exec() ) {
  	QString tag = QString("<tr");
  	if ( !QString(rowDlg->comboAlign->currentText()).isEmpty())
  		tag += QString(" align=\"")+rowDlg->comboAlign->currentText()+"\"";
  				
  	if ( !QString(rowDlg->comboVAlign->currentText()).isEmpty())
  		tag += QString(" valign=\"")+rowDlg->comboVAlign->currentText()+"\"";
  		
  	if ( !QString(rowDlg->comboColor->currentText()).isEmpty())
  		tag += QString(" color=\"")+rowDlg->comboColor->currentText()+"\"";
  		
  	tag +=">";

  	write()->insertTag( tag,QString("</tr>"));
  }
  delete(rowDlg);
}
/** head properties */
void QuantaView::slotTagTableHead(){
	TagTableHead *headDlg = new TagTableHead(this, i18n("Table head properties..."));
  if ( headDlg->exec() ) {
  	QString tag = QString("<th");
  	
  	if ( !QString(headDlg->comboAlign->currentText()).isEmpty())
  		tag += QString(" align=\"")+headDlg->comboAlign->currentText()+"\"";
  				
  	if ( !QString(headDlg->comboVAlign->currentText()).isEmpty())
  		tag += QString(" valign=\"")+headDlg->comboVAlign->currentText()+"\"";
  		
  	if ( !QString(headDlg->comboBGColor->currentText()).isEmpty())
  		tag += QString(" bgcolor=\"")+headDlg->comboBGColor->currentText()+"\"";
  		
  	if ( headDlg->spinWidth->value() != 0 )
  		tag += QString(" width=\"")+QString(headDlg->spinWidth->text())+"\"";
  	
  	if ( headDlg->spinHeight->value() != 0 )
  		tag += QString(" height=\"")+QString(headDlg->spinHeight->text())+"\"";
  		
  	if ( headDlg->spinRowSpan->value() != 0 )
  		tag += QString(" rowspan=\"")+QString(headDlg->spinRowSpan->text())+"\"";
  		
  	if ( headDlg->spinColSpan->value() != 0 )
  		tag += QString(" colspan=\"")+QString(headDlg->spinColSpan->text())+"\"";
  		
  	tag +=">";

  	write()->insertTag( tag,QString("</th>")); 		
  }
  delete(headDlg);
}
/** table data properties */
void QuantaView::slotTagTableData(){
	TagTableHead *headDlg = new TagTableHead(this, i18n("Table data properties..."));
  if ( headDlg->exec() ) {
  	QString tag = QString("<td");
  	
  	if ( !QString(headDlg->comboAlign->currentText()).isEmpty())
  		tag += QString(" align=\"")+headDlg->comboAlign->currentText()+"\"";
  				
  	if ( !QString(headDlg->comboVAlign->currentText()).isEmpty())
  		tag += QString(" valign=\"")+headDlg->comboVAlign->currentText()+"\"";
  		
  	if ( !QString(headDlg->comboBGColor->currentText()).isEmpty())
  		tag += QString(" bgcolor=\"")+headDlg->comboBGColor->currentText()+"\"";
  		
  	if ( headDlg->spinWidth->value() != 0 )
  		tag += QString(" width=\"")+QString(headDlg->spinWidth->text())+"\"";
  	
  	if ( headDlg->spinHeight->value() != 0 )
  		tag += QString(" height=\"")+QString(headDlg->spinHeight->text())+"\"";
  		
  	if ( headDlg->spinRowSpan->value() != 0 )
  		tag += QString(" rowspan=\"")+QString(headDlg->spinRowSpan->text())+"\"";
  		
  	if ( headDlg->spinColSpan->value() != 0 )
  		tag += QString(" colspan=\"")+QString(headDlg->spinColSpan->text())+"\"";
  		
  	tag +=">";

  	write()->insertTag( tag,QString("</td>")); 		
  }
  delete(headDlg);
}
/** Open color Dialog and
insert color in the text */
void QuantaView::slotTagColor(){
  QColor color;

	if (KColorDialog::getColor( color )) {
		char c[8];
		sprintf(c,"#%2X%2X%2X",color.red(),color.green(),color.blue());
		for (int i=0;i<7;i++) if (c[i] == ' ') c[i] = '0';
		QString scolor = QString("\"")+(char *)c;
		        scolor +=QString("\"");
  	write()->insertTag(scolor);
		}
}


CTabCtl::CTabCtl(QWidget* parent,char* name,QString type) : KTabCtl(parent,name){
  setFocusPolicy(QWidget::NoFocus);
  tabs->setFocusPolicy(QWidget::NoFocus);
  if(type == "normal"){
    setShape(QTabBar::RoundedAbove);
  }
  if(type == "output_widget"){
    setShape(QTabBar::RoundedAbove);
    //    tabs->setFont(QFont("helvetica",10));
  }

}
void CTabCtl::setCurrentTab(int id){

  tabs->setCurrentTab(id);
  tabSelected(id);
  showTab(id);
}

int CTabCtl::getCurrentTab(){
  int currentTab=tabs->currentTab();
  return currentTab;
}

/** insert TextArea tag */
void QuantaView::slotTagFormTextArea(){

}
/** insert Radio Button tag */
void QuantaView::slotTagFormRadio(){

	TagFormButton form(this,i18n("Radio button tag"));
  if ( form.exec() ) {
  	QString tag = QString("<input type=\"radio\" name=\"")
  								+form.lineName->text()+"\" value=\""+form.lineValue->text()+"\"";
  	if (form.checkChecked->isChecked())
  			tag+=QString(" checked");
  	tag+=">";
  	
  	write()->insertTag( tag );
 }
}
/** insert Form tag */
void QuantaView::slotTagForm(){
	TagForm form(this,i18n("Form tag"));
  if ( form.exec() ) {
  	QString tag = QString("<form actiom=\"")+form.lineAction->text()
  	             +"\" method=\""+form.comboMethod->currentText()+"\"";
  	if ( !QString( form.comboTarget->currentText()).isEmpty())
  		tag += QString(" target=")+form.comboTarget->currentText();
  		
  	if ( !QString( form.comboEnctype->currentText()).isEmpty())
  		tag += QString(" enctype=")+form.comboEnctype->currentText();
  	tag+= ">\n"+space+"\t";
  	
  	write()->insertTag( tag, QString("\n")+space+"</form>" );
  		
  }
}
/**  */
void QuantaView::slotTagFormCheck(){
	TagFormButton form(this,i18n("Check button tag"));
  if ( form.exec() ) {
  	QString tag = QString("<input type=\"check\" name=\"")
  								+form.lineName->text()+"\" value=\""+form.lineValue->text()+"\"";
  	if (form.checkChecked->isChecked())
  			tag+=QString(" checked");
  	tag+=">";
  	
  	write()->insertTag( tag );
 }

}
/**  */
void QuantaView::slotTagFormLineEdit(){
	TagFormText form(this,i18n("Input text tag"));
  if ( form.exec() ) {
  	QString tag = QString("<input type=\"text\" name=\"")
  								+form.lineName->text()+"\" value=\""+form.lineValue->text()+"\"";
  	if ( form.spinSize->value() )
  			tag+=QString(" size=\"")+form.spinSize->text()+"\"";
  			
  	if ( form.spinMaxLen->value() )
  			tag+=QString(" maxlength=\"")+form.spinMaxLen->text()+"\"";
  			
  	tag+=">";
  	
  	write()->insertTag( tag );
 }


}
/**  */
void QuantaView::slotTagFormPas(){
	TagFormText form(this,i18n("Input password tag"));
  if ( form.exec() ) {
  	QString tag = QString("<input type=\"password\" name=\"")
  								+form.lineName->text()+"\" value=\""+form.lineValue->text()+"\"";
  	if ( form.spinSize->value() )
  			tag+=QString(" size=\"")+form.spinSize->text()+"\"";
  			
  	if ( form.spinMaxLen->value() )
  			tag+=QString(" maxlength=\"")+form.spinMaxLen->text()+"\"";
  			
  	tag+=">";
  	
  	write()->insertTag( tag );

  }
}/** insert <br> tag */
void QuantaView::slotTagBr(){
  write()->insertTag("<br>");
}
/** insert  &nbsp; */
void QuantaView::slotTagNbsp(){
  write()->insertTag("&nbsp; ");
}
/** Add new kwrite class to
writeStack and return id in stack */
int QuantaView::addWrite( KWrite *w , char *label ){
	
	int id = fileTabBar->addTab( label );
	writeStack->addWidget( w, id );
	writeStack->raiseWidget( id );
		
	fileTabBar->repaint();
	writeStack->show();
		
	return id;
}
/** return current KWrite class */
KWrite * QuantaView::write()
{
  return ( KWrite* )writeStack->visibleWidget();
}
/**  */
void QuantaView::selectWrite(int id)
{
  writeStack->raiseWidget(id);
  emit writeSelected(id);

  app->slotNewUndo();
  app->slotNewStatus();
  doc->write->deselectAll();
  app->slotMarkStatus(0, false);

  if ( app->viewMenu->isItemChecked(ID_VIEW_PREVIEW) ) repaintPreview();
}

/** remove KWrite class from stack, return id of new KWrite */
KWrite* QuantaView::removeWrite()
{
  KWrite *w = write();
  int id = writeStack->id(w);
  fileTabBar->removeTab(id);
  writeStack->removeWidget( w );
  writeStack->raiseWidget( fileTabBar->currentTab() );
  //  fileTabBar->;
  //  delete( w );

  return write();
}
/**  */
KWrite * QuantaView::write(int id){
  return (KWrite*)writeStack->widget(id);
}

/** insert date */
void QuantaView::slotTagDate(){
  time_t tektime;
  time( &tektime);
  QString stime = ctime( &tektime);

  write()->insertTag( stime);
}
/** for select form */
void QuantaView::slotTagSelect(){
  write()->insertTag("<select name=\"\"><option>","</select>");
}
/** insert text area form */
void QuantaView::slotTagTextArea(){
  write()->insertTag("<textarea name=\"\" size=\"\" maxlen=\"\">","</textarea>");
}
/** save scroll position */
void QuantaView::saveScroll(){
  scrollX = html->xOffset();
  scrollY = html->yOffset();
}
/** set scroll */
void QuantaView::setScroll(){
  html->slotScrollVert( scrollY ); // set scroll position
  html->slotScrollHorz( scrollX );
}
