/***************************************************************************
                          quantadoc.cpp  -  description
                             -------------------
    begin                :   18 23:09:05 EET 1999
    copyright            : (C) 1999 by Yacovlev Alexander & Dmitry Poplavsky
    email                : pdima@mail.univ.kiev.ua
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>
#include <qwidgetstack.h>
#include <qdict.h>
#include <qpopupmenu.h>

// include files for KDE
#include <kapp.h>
#include <kmsgbox.h>
#include <htmlview.h>

// application specific includes
#include "resource.h"
#include "quantadoc.h"
#include "quanta.h"
#include "quantaview.h"
#include "kwview.h"
#include "kwdoc.h"
#include "filetabbar.h"

// pics includes
#include "pics/cut.xpm"
#include "pics/copy.xpm"
#include "pics/paste.xpm"
#include "pics/undo.xpm"
#include "pics/redo.xpm"


QList<QuantaView> *QuantaDoc::pViewList = 0L;

QuantaDoc::QuantaDoc(QWidget *parent, const char *name) : QObject(parent, name)
{
  app = (QuantaApp *)parent;

  if(!pViewList)
  {
    pViewList = new QList<QuantaView>();
  }

  pViewList->setAutoDelete(true);
  basePath = QDir::currentDirPath();

  fileList = new QDict<int>();
}

QuantaDoc::~QuantaDoc(){
}

void QuantaDoc::addView(QuantaView *view)
{
  pViewList->append(view);
  write = view->write();
  this->view = view;
}

void QuantaDoc::removeView(QuantaView *view)
{
  pViewList->remove(view);
}

void QuantaDoc::setAbsFilePath(const QString &filename)
{
  write->setFileName(filename);
}

QString QuantaDoc::getAbsFilePath()
{
   QString fname = write->fileName();
   if ( fname.left(5) == "file:" ) fname.remove(0,5);
   return fname;
}

void QuantaDoc::setTitle(const QString &_t)
{
  title=_t;
}

const QString &QuantaDoc::getTitle() const
{
  QString fname = write->fileName();
  QFileInfo fileInfo(fname);
  title=(fileInfo.fileName()).data();
  return title;
}

void QuantaDoc::slotUpdateAllViews(QuantaView *sender)
{
  QuantaView *w;
  if(pViewList)
  {
    for(w=pViewList->first(); w!=0; w=pViewList->next())
    {
      if(w!=sender)
        w->repaint();
    }
  }

}

bool QuantaDoc::saveModified()
{
  return saveAll( false );
}


void QuantaDoc::closeDocument()
{
  QString fname = write->fileName();
  if ( !fname.data() ) fname = "Untitled.html";
  if ( fname.left(5) == "file:" ) fname.remove(0,5);

  fileList->remove( fname );

  if ( !( write = view->removeWrite() ))
    newDocument();

  fname = write->fileName();
  QFileInfo fileInfo(fname);
  title=fileInfo.fileName();
}

bool QuantaDoc::newDocument(const char *filename = 0)
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////
  QString fname;
  bool fnew = false;
  if ( !filename ) {
    fname = "Untitled.html";
    fnew = true;
  } else fname = filename;

 	if ( !fileList->find( fname.data()) || fnew ) {
 	
 	  if ( write )
 	    if ( !write->hasFileName() && !write->isModified() && !fnew ) {
 	      view->removeWrite();
 	  }
 	
 	  newWrite( view);

    int *id = new int;
    *id = view->addWrite( write,fname.data());
    fileList->insert( fname.data(), id);


    setModified(false);
    title = fname.data();


  } else {
    int id = *fileList->find( fname.data());
    view->fileTabBar->setCurrentTab( id );
    view->repaint();
    title = fname.data();
  }
  app->slotNewUndo();
  app->slotNewStatus();
  app->slotMarkStatus(0, false);

  return true;
}

bool QuantaDoc::openDocument(const QString &filename, const char *format /*=0*/)
{
  QString fname = filename;
  if ( fname.left(5) == "file:" ) fname.remove(0,5);

  newDocument( fname.data() );
  QFileInfo fileInfo(fname);
  title=fileInfo.fileName();
  basePath = fileInfo.dirPath(true);

  write->loadURL(fname);
  write->setHl(write->getHl());

  view->repaintPreview();

  return true;
}

bool QuantaDoc::saveDocument(const QString &filename, const char *format /*=0*/)
{
  /////////////////////////////////////////////////
  // TODO: Add your document saving code here
  /////////////////////////////////////////////////
  QFileInfo fileInfo(filename);
  title=fileInfo.fileName();
  basePath = fileInfo.dirPath(true);

  changeFileName( filename );

  write->save();
  setModified(false);

  return true;
}

void QuantaDoc::deleteContents()
{
  /////////////////////////////////////////////////
  // TODO: Add implementation to delete the document contents
  /////////////////////////////////////////////////
}

/**  */
void QuantaDoc::selectWrite( int id){
  write = view->write(id);
  QString caption=kapp->getCaption();	
  app->setCaption(caption+": "+getTitle());
}

/** change file name in tab bar etc */
void QuantaDoc::changeFileName(QString newname){
  QString oldname = write ->fileName();
  if ( newname.left(5) == "file:") newname.remove(0,5);
  if ( oldname.left(5) == "file:") oldname.remove(0,5);
  int *id = new int;
  *id = view->fileTabBar->currentTab();

  int pos;
  QString shortname( newname );
  while ( ( pos = shortname.find('/')) != -1)
    shortname.remove( 0,pos+1 );

  view->fileTabBar->setTabLabel( *id, shortname.data() );

  fileList->remove( oldname.data() );
  fileList->insert( newname.data(), id );
}

/** set modified flag */
void QuantaDoc::setModified(bool _m=true) {
  write->setModified(_m);
}
/** get modified flag */
bool QuantaDoc::isModified(){
  return write->isModified();
}
/** save all files */
bool QuantaDoc::saveAll(bool type=true){
  int tek_id = view->fileTabBar->currentTab();

  QList<QTab> *list = view->fileTabBar->tabsList;

  for ( list->first(); list->current(); list->next() ) {
    int id = list->current()->id;
    view->fileTabBar->setCurrentTab( id);
    view->fileTabBar->repaint();
    KWrite *twrite = (KWrite *)(view->writeStack->widget( id));
    if ( twrite->isModified() )
      if ( type )twrite->save();
        else if ( !twrite->canDiscard() ) return false;
  }

  view->fileTabBar->setCurrentTab( tek_id);
  view->fileTabBar->repaint();
  return true;
}
/** create new write classa */
KWrite* QuantaDoc::newWrite(QWidget *parent)
{
  static HlManager *hl = new HlManager();
  KWriteDoc *writeDoc = new KWriteDoc( hl);

 	write = new KWrite( writeDoc, parent);
 	write -> readConfig( kapp->getConfig() );
 	
 	connect( write, SIGNAL( newUndo()), app, SLOT( slotNewUndo()));
 	connect( write, SIGNAL( newStatus()), app, SLOT( slotNewStatus()));
 	connect( write, SIGNAL( markStatus(KWriteView *, bool)), app, SLOT( slotMarkStatus(KWriteView *, bool)));
 	connect( write, SIGNAL( clipboardStatus(KWriteView *, bool)), app, SLOT( slotClipboardStatus(KWriteView *, bool)));
 	
 	writeRBMenu = new QPopupMenu();
  writeRBMenu->insertItem(QPixmap((const char**)cut_xpm),  i18n("Cu&t"),   app, SLOT(slotEditCut()),   ID_EDIT_CUT);
  writeRBMenu->insertItem(QPixmap((const char**)copy_xpm), i18n("&Copy"),  app, SLOT(slotEditCopy()),  ID_EDIT_COPY);
  writeRBMenu->insertItem(QPixmap((const char**)paste_xpm),i18n("&Paste"), app, SLOT(slotEditPaste()), ID_EDIT_PASTE);
  writeRBMenu->insertSeparator();
  writeRBMenu->insertItem(QPixmap((const char**)undo_xpm),i18n("&Undo"), app, SLOT(slotEditUndo()), ID_EDIT_UNDO);
  writeRBMenu->insertItem(QPixmap((const char**)redo_xpm),i18n("&Redo"), app, SLOT(slotEditRedo()), ID_EDIT_REDO);
  writeRBMenu->insertSeparator();
  writeRBMenu->insertItem(i18n("&Weblint"), app, SLOT(slotLint()), ID_FILE_LINT);

 	write->installRBPopup(writeRBMenu);
 	
 	return write;
}
