
#include "main.h"
#include "ball.h"

#include "maze.h"
#include "playground.h"

#include <qpainter.h>

#include <stdlib.h>

#define DIRUPLEFT 0 // upper bit-left/right
#define DIRUPRIGHT 2 // lower bit-up/down
#define DIRDOWNLEFT 1
#define DIRDOWNRIGHT 3

CBall::CBall(CMaze* parent)
{
	_maze = parent;
	CWormPlayground* pg = _maze->playground();
	_moveType = 0;
	_active = true;
	getPixmap();
	QObject::connect(pg,SIGNAL(sigStart()),this,SLOT(slotStart()));
	QObject::connect(pg,SIGNAL(sigDie(char)),this,SLOT(slotFinish()));
	QObject::connect(pg,SIGNAL(sigTimer(long)),this,SLOT(slotTimer(long)));
	QObject::connect(this,SIGNAL(sigUpdate(const QRect&)),pg,SLOT(update(const QRect&)));
	redraw(_pos);
}

CBall::~CBall()
{

}

/*inline*/ QPoint CBall::LPtoDP(QPoint pt)
{ 
	return _maze->LPtoDP(pt); 
}

/*inline*/ QRect CBall::LPtoDP(QRect rct)
{ 
	return _maze->LPtoDP(rct); 
}

void CBall::init(QPoint* pos)
{
	_pos = *pos;
	slotStart();
}

void CBall::redraw(QPoint last)
{
	QRect rct(LPtoDP(pos()),QSize(FDWIDTH,FDHEIGHT));
	QRect rct2(LPtoDP(last),QSize(FDWIDTH,FDHEIGHT));
	rct = rct.unite(rct2);
	rct.normalize();
	emit sigUpdate(rct);
}

void CBall::draw(QPainter* pt)
{
	QPoint devPos = LPtoDP(pos());

	bitBlt(_maze->playground(),devPos,_activePixmap);
}

void CBall::slotStart()
{
	_active = true;
	redraw(_pos);
}

void CBall::slotFinish()
{
	_active = false;
}

void CBall::slotTimer(long c)
{
	if (!_active) return;
	if (!(c % TIMER_COUNT_BALL_REDRAW)) {
		if (changeAppearance()) redraw(pos());
	}
	if (c % TIMER_COUNT_BALL) return;
	QPoint origPos = pos();
	if (moveFunc(c)) redraw(origPos);
}

QPoint CBall::getFreePos()
{
	QPoint x;
	do {
		x = QPoint(rand() % PGWIDTH + 1,rand() % PGHEIGHT + 1);
	} while (maze()->playground()->fieldState(x) != FieldEmpty);
	return x;
}

void CBall::getPixmap()
{
	_pixmapIndex = (rand() % NUM_PIXMAPS) * 3;
	_activePixmap = _BallPixmapArray[_pixmapIndex];

}

// class CQuietBall

CQuietBall::CQuietBall(CMaze* parent) : CBall(parent)
{
	_qbType = rand() % 2;
	_moveType = _qbType ? BLQUIET2 : BLQUIET; // Changing color or size
}

bool CQuietBall::moveFunc(long)
{
	return false;
}

bool CQuietBall::changeAppearance()
{
	if (_qbType == 0) {
		getPixmap();
		return true;
	}
	if (_qbType == 1) {
		int newPI = _pixmapIndex;
		if (_pixmapIndex % 3 == 1) // Mittlere Gre
			newPI += (_lastSize == 2 ? -1 : 1);
		else newPI = 1;
		_lastSize = _pixmapIndex;
		_pixmapIndex = newPI;
		_activePixmap = _BallPixmapArray[_pixmapIndex];
		return true;
	}
	//	assert(false);
	fatal("CQuietBall::changeAppearance: Strange error");
	return false;	
}

// class CMovingBall

CMovingBall::CMovingBall(CMaze* parent,char speed) : CBall(parent)
{
	_moveType = BLMOVING;
	_speed = speed;
	_dir = rand() % 4;
}

/*
 * f1-f5 Fields which are needed to determine the new direction of the ball
 * f1 | f2 | f3		example for 		 /  | /  | f5
 * ---|----|---		current direction 	----|----|----
 * f4 | bl | /      <-- UPLEFT 			 /  | bl | f4
 * ---|----|---			DOWNRIGHT -->	----|----|----
 * f5 | /  | /  				 f3 | f2 | f1
 *
 * Tests the following way:
 * !f1
 *	f2 && f3 ? (v,h)
 * f1
 *	f2 || f3 ? v
 *	f4 || f5 ? h
 */

#define ISUP(x) (!((x) % 2))
#define ISLEFT(x) (!(((x) >> 1) % 2))
#define SWITCHVERT(x) ((x) ^= 1)
#define SWITCHHORIZ(x) ((x) ^= 2)

bool CMovingBall::moveFunc(long c)
{
	if (c % (TIMER_COUNT_BALL * _speed)) return false;
	bool f1,f2,f3,f4,f5,f6,f7,f8; // Is this field occupied?
	QPoint thePos;
	//	while (true) {
		thePos = _pos;
		thePos.setY(thePos.y() + (ISUP(_dir) ? -1 : 1)); 
		thePos.setX(thePos.x() + (ISLEFT(_dir) ? -1 : 1)); // This is f1's position
		f1 = (_maze->playground()->fieldState(thePos) != FieldEmpty);
		thePos.setX(thePos.x() + (ISLEFT(_dir) ? 1 : -1)); // This is f2's position
		f2 = (_maze->playground()->fieldState(thePos) != FieldEmpty);
		thePos.setX(thePos.x() + (ISLEFT(_dir) ? 1 : -1)); // This is f3's position
		f3 = (_maze->playground()->fieldState(thePos) != FieldEmpty);
		thePos.setX(_pos.x() + (ISLEFT(_dir) ? -1 : 1)); // This is f1's position
		thePos.setY(thePos.y() + (ISUP(_dir) ? 1 : -1)); // This is f4's position
		f4 = (_maze->playground()->fieldState(thePos) != FieldEmpty);
		thePos.setY(thePos.y() + (ISUP(_dir) ? 1 : -1)); // This is f5's position
		f5 = (_maze->playground()->fieldState(thePos) != FieldEmpty);

//  		thePos.setX(thePos.x() + (ISLEFT(_dir) ? 1 : -1)); // This is f6's position
// 		f6 = (_maze->playground()->fieldState(thePos) != FieldEmpty);
//  		thePos.setX(thePos.x() + (ISLEFT(_dir) ? 1 : -1)); // This is f7's position
// 		f7 = (_maze->playground()->fieldState(thePos) != FieldEmpty);
// 		thePos.setY(thePos.y() + (ISUP(_dir) ? -1 : 1)); // This is f8's position
// 		f8 = (_maze->playground()->fieldState(thePos) != FieldEmpty);

		//		debug("Values of f1-f8: %i %i %i %i %i %i %i %i",f1,f2,f3,f4,f5,f6,f7,f8);

		/*		if (!f1) {
		 *		(f2 && f3 ? (SWITCHVERT(_dir),SWITCHHORIZ(_dir)) : 0);
		 *		debug ("!f1");
		 *		} else {
		 *			(f2 || f3 ? SWITCHVERT(_dir) : 0);
		 *			(f4 || f5 ? SWITCHHORIZ(_dir) : 0);
		 *			}*/
// 		if (f2 && f4) {
// 			SWITCHVERT(_dir);
// 			SWITCHHORIZ(_dir);
// 		}
// 		else if (!f1) 
// 			(f2 && f3 ? (SWITCHVERT(_dir),SWITCHHORIZ(_dir)) : 0);
// 		else {
// 			(!f2 && !f4 ? (SWITCHVERT(_dir),SWITCHHORIZ(_dir)) : 0);
// 			(f2 ? SWITCHVERT(_dir) : 0);
// 			(f4 ? SWITCHHORIZ(_dir) : 0);
// 		}

		//		if (f2 && f4) {
		//			SWITCHVERT(_dir);
		//			SWITCHHORIZ(_dir);
		//		}
		//		else 
		if (f1 && !f2 && !f4) {
			SWITCHVERT(_dir);
			SWITCHHORIZ(_dir);
		} else {
			//			(!f2 && !f4 ? (SWITCHVERT(_dir),SWITCHHORIZ(_dir)) : 0);
			(f2 ? SWITCHVERT(_dir) : 0);
			(f4 ? SWITCHHORIZ(_dir) : 0);
		}

// 		if (!f1) (f2 && f3 ? (SWITCHVERT(_dir),SWITCHHORIZ(_dir)) : 0);
// 		else {
// 			(!f2 && !f4 ? (SWITCHVERT(_dir),SWITCHHORIZ(_dir)) : 0);
// 			(f2 ? SWITCHVERT(_dir) : 0);
// 			(f4 ? SWITCHHORIZ(_dir) : 0);
// 		}
			
		
	// Second part: hte move itself, after changing the direction
	// If any of f6-f8 are occupied, the ball moves differently, but its direction
	// doesn't change
	QPoint mvPt((ISLEFT(_dir) ? -1 : 1),(ISUP(_dir) ? -1 : 1));

	thePos = QPoint(_pos.x(),_pos.y() + mvPt.y()); // f6
	f6 = (_maze->playground()->fieldState(thePos) != FieldEmpty);
	thePos = QPoint(_pos.x() + mvPt.x(),_pos.y() + mvPt.y()); // f7
	f7 = (_maze->playground()->fieldState(thePos) != FieldEmpty);
	thePos = QPoint(_pos.x() + mvPt.x(),_pos.y()); // f8
	f8 = (_maze->playground()->fieldState(thePos) != FieldEmpty);

	if (f7 && !f6 && !f8) {
		if (rand() % 2) mvPt.setX(0);
		else mvPt.setY(0);
	} else {
		if (f6) { mvPt.setY(0); }
		if (f8) { mvPt.setX(0); }
	}


	_pos = QPoint(_pos.x() + mvPt.x(),_pos.y() + mvPt.y());

	return true;
}

// class CJumpingBall

CJumpingBall::CJumpingBall(CMaze* parent,char p,char speed) : CBall(parent)
{
	_p = p;
	_speed = speed;
}

bool CJumpingBall::moveFunc(long c)
{
	if (c % (TIMER_COUNT_BALL * _speed)) return false;
	if (rand() % 100 + 1 > _p) return false;
        QPoint nPos = getFreePos();
        _pos = nPos;
	return true;
}

