/***************************************************************************
                          krossword.cpp  -  description
                             -------------------
    begin                : Fri Jan  7 11:43:16 CET 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "krossword.h"
#include <qfiledialog.h>

int revealword_id;

Krossword::Krossword() : KTMainWindow(){
	this -> setFixedSize (350,300);
	puzzleframe = new QFrame (this);
	puzzleframe -> setGeometry(0,90,350,300 - 90 - 35);
	puzzleframe -> setFrameStyle(QFrame::Panel | QFrame::Sunken);

	pw = new PuzzleWidget(this);
	pw -> hide();

	connect(pw,SIGNAL(solutionmenu_enable(int,bool)),SLOT(solutionMenuEnable(int,bool)));

	filemenu = new QPopupMenu();
	filemenu -> insertItem(i18n("New file"),this,SLOT(newPuzzle() ));
	filemenu -> insertItem("Open file...",this,SLOT(openPuzzle() ));
	savepuz_id = filemenu -> insertItem("Save as...",this,SLOT(savePuzzleAs()));
	filemenu -> setItemEnabled(savepuz_id,FALSE);
	filemenu -> insertSeparator();
	filemenu -> insertItem("Exit",this,SLOT(exit()));

	optionsmenu = new QPopupMenu();
	show_word_corr_id =  optionsmenu -> insertItem("Show word correctness",this,SLOT(showWordCorr()));
	show_letter_corr_id = optionsmenu -> insertItem("Show letter correctness",this,SLOT(showLetterCorr()));
	dont_show_corr_id =  optionsmenu -> insertItem("Don't show correctness",this,SLOT(dontShowCorr()));
	optionsmenu -> setItemEnabled(show_word_corr_id,FALSE);
	optionsmenu -> setItemEnabled(show_letter_corr_id,FALSE);
	optionsmenu -> setItemEnabled(dont_show_corr_id,FALSE);
	
	solutionmenu  = new QPopupMenu();
	int revealword_id =	solutionmenu -> insertItem("Reveal word", pw, SLOT(revealWord()));
	solutionmenu -> setItemEnabled(revealword_id,FALSE);
	helpmenu = new QPopupMenu();
	helpmenu -> insertItem("Contents",this,SLOT(showHelpContents()));

	menu = new KMenuBar(this);
	menu -> insertItem("File",filemenu);
	menu -> insertItem("Options",optionsmenu);
	menu -> insertItem("Solution",solutionmenu);
	menu -> insertItem("Help",helpmenu);

	new_pixmap = QPixmap(KApplication::kde_toolbardir() + "/filenew.xpm");
	open_pixmap = QPixmap(KApplication::kde_toolbardir() + "/fileopen.xpm");
	save_pixmap = QPixmap(KApplication::kde_toolbardir() + "/filefloppy.xpm");
	exit_pixmap = QPixmap(KApplication::kde_toolbardir() + "/exit.xpm");

	toolbar = new KToolBar(this);
	toolbar -> insertButton(new_pixmap,1,SIGNAL(clicked()),this,SLOT(newPuzzle()),TRUE,"New file");
	toolbar -> insertButton(open_pixmap,1,SIGNAL(clicked()),this,SLOT(openPuzzle()),TRUE,"Open file");
	toolbar -> insertButton(save_pixmap,1,SIGNAL(clicked()),this,SLOT(savePuzzle()),TRUE,"Save file");
	toolbar -> insertButton(exit_pixmap,1,SIGNAL(clicked()),this,SLOT(exit()),TRUE,"Exit");

	this -> setMenu (menu);
	this ->addToolBar(toolbar);

	title = new QLineEdit(this);
	title -> setText("No title");
	title -> setFocusPolicy(QWidget::NoFocus);
	title -> setGeometry(5,menu -> height() + 35,200,25);

	author = new QLineEdit(this);
	author -> setText("No author");
	author -> setFocusPolicy(QWidget::NoFocus);
	author -> setGeometry(5,this -> height() - 30,150,25);

	copyright = new QLineEdit(this);
	copyright -> setText("No copyright");
	copyright -> setFocusPolicy(QWidget::NoFocus);
	copyright -> setGeometry(this -> width() - 5 - 150,this -> height() - 30, 150,25);

	npw = new NewPuzzleWidget();
	connect( (QObject *)npw -> ok,SIGNAL(clicked()),SLOT(npwOkClicked()));
	connect( (QObject *)npw -> cancel,SIGNAL(clicked()),SLOT(npwCancelClicked()));

	questions_widget = new QuestionsWidget();
	connect(pw,SIGNAL(questions_widget_select(int,bool,bool)),SLOT(questionsWidgetSelect(int,bool,bool)));

	editor_widget = new EditorWidget();

	puzzle_open = FALSE;
}

Krossword::~Krossword(){
}

void Krossword::editorToQuestions()
{
    pw -> puzzle.title = editor_widget -> line_title -> text();
    pw -> puzzle.author = editor_widget -> line_author -> text();
    pw -> puzzle.copyright = editor_widget -> line_copyright -> text();
    pw -> puzzle.acrnumber = editor_widget -> editor_across -> numLines();
    pw -> puzzle.downumber = editor_widget -> editor_down -> numLines();
    pw -> puzzle.across = new QString [pw ->puzzle.acrnumber];
    pw -> puzzle.down = new QString [pw ->puzzle.downumber];
    pw -> puzzle.across_question_number = new int [pw ->puzzle.acrnumber];
    pw -> puzzle.down_question_number = new int [pw ->puzzle.downumber];
    pw -> computeNumbers();
    QString n;
    questions_widget -> across_listbox -> clear();
    questions_widget -> down_listbox -> clear();
    for (int i = 0; i <= pw -> puzzle.acrnumber - 1; i++)
    {
        pw -> puzzle.across[i] = editor_widget -> editor_across -> textLine (i);
        n.setNum(pw -> puzzle.across_question_number[i]);
        questions_widget -> across_listbox -> insertItem(n + ". " + pw -> puzzle.across[i],i);
    }
    for (int i = 0; i <= pw -> puzzle.downumber - 1; i++)
    {
        pw -> puzzle.down[i] = editor_widget -> editor_down -> textLine (i);
        n.setNum(pw -> puzzle.down_question_number[i]);
        questions_widget -> down_listbox -> insertItem(n + ". " + pw -> puzzle.down[i],i);
    }
    title -> setText(pw -> puzzle.title);
    author -> setText(pw -> puzzle.author);
    copyright -> setText(pw -> puzzle.copyright);

}

void Krossword::exit()
{
    int i = 2;
    if (puzzle_open)
        if (pw -> puzzle.changed)
            i = KMsgBox::yesNoCancel(0,0,"File changed. Save File?");
    if (i == 1)
    {
        savePuzzle();
        KApplication::exit(0);
    }
    if (i == 2)
    {
        closeDatabase();
        KApplication::exit(0);
    }
    if (i == 3)
    {
    }
}

void Krossword::newPuzzle()
{
    int i = 2;
    if (puzzle_open)
        if (pw -> puzzle.changed)
            i = KMsgBox::yesNoCancel(0,0,"File changed. Save File?");
    if (i == 1)
    {
        savePuzzle();
        closeDatabase();
        npw -> show();
    }
    if (i == 2)
    {
        closeDatabase();
        npw -> show();
    }
    if (i == 3)
    {
    }
}

void Krossword::npwOkClicked()
{
    npw -> hide();
    pw -> puzzle.file = "";
    pw -> puzzle.changed = FALSE;
    pw -> puzzle.height = npw -> height();
    pw -> puzzle.width = npw -> width();
    pw -> puzzle.solution = new QString [pw -> puzzle.height];
    pw -> puzzle.solve = new QString [pw -> puzzle.height];
    pw -> puzzle.reveal = new QString [pw -> puzzle.height];
    // dummy declarations, if not declared, kcrosword will
    // segfault (in closeDatabase()) if a new puzzle
    // is opened without adding questions
    pw -> puzzle.across = new QString [1];
    pw -> puzzle.down = new QString [1];
    pw -> puzzle.across_question_number  = new int [1];
    pw -> puzzle.down_question_number  = new int [1];
   for (int i = 0; i <= npw -> height() - 1 ; i++)
    {
        pw -> puzzle.solution [i].fill(' ',pw -> puzzle.width);
        pw -> puzzle.solve[i].fill(' ',pw -> puzzle.width);
        pw -> puzzle.reveal[i].fill(' ',pw -> puzzle.width);
    }
    puzzle_open = TRUE;
    pw -> edit_mode = TRUE;
    filemenu -> setItemEnabled(savepuz_id,TRUE);
    resizeWidget();
    pw -> show();
    editor_widget -> show();
}

void Krossword::npwCancelClicked()
{
    npw -> hide();
}

void Krossword::openPuzzle()
{
    int i = 2;
    if  (puzzle_open)
        if (pw -> puzzle.changed)
            i = KMsgBox::yesNoCancel(0,0,"File changed. Save File?");
    if (i == 1)
    {
        savePuzzle();
        closeDatabase();
        loadPuzzle();
    }
    if (i == 2)
    {
        closeDatabase();
        loadPuzzle();
    }
    if (i == 3)
    {
    }
}

void Krossword::loadPuzzle()
{
    QString file = QFileDialog::getOpenFileName();
    if (!file.isNull())
    {
        puzzle_open = TRUE;
        optionsmenu -> setItemEnabled(show_word_corr_id,TRUE);
        optionsmenu -> setItemEnabled(show_letter_corr_id,TRUE);
        optionsmenu -> setItemEnabled(dont_show_corr_id,TRUE);
        QFile f( ( const char * ) file);
        f.open(IO_ReadOnly);
        QTextStream t (&f);
        QString line;
        while (!t.eof() )
        {
            if (line == "[title]")
            {
                line = t.readLine();
                editor_widget -> line_title -> setText(line);
            }
            if (line == "[author]")
            {
                line = t.readLine();
                editor_widget -> line_author -> setText(line);
            }
            if (line == "[copyright]")
            {
                line = t.readLine();
                editor_widget -> line_copyright -> setText(line);
            }
            if (line == "[puzzle]")
            {
                int counter = 0;
                QString temp_line[200];
                while ( line != "")
                {
                    line = t.readLine();
                    temp_line[counter] = line;
                    counter++;
                }
                pw -> puzzle.height = counter - 1;
                pw -> puzzle.width = temp_line[0].length();
                pw -> puzzle.solution = new QString [pw -> puzzle.height];
                pw -> puzzle.solve = new QString [pw -> puzzle.height];
                pw -> puzzle.reveal = new QString [pw -> puzzle.height];
                for (int i = 0; i <= pw -> puzzle.height - 1; i++)
                {
                    pw -> puzzle.solution [i] = temp_line[i];
                    pw -> puzzle.solve [i].fill(' ',pw -> puzzle.width);
                    pw -> puzzle.reveal[i].fill('F',pw -> puzzle.width);
                }
            }
            if (line == "[across]")
            {
                while ( line != "")
                {
                    line = t.readLine();
                    if ( line != "" )
                        editor_widget -> editor_across -> insertLine(line);
                }
            }
            if (line == "[down]")
            {
                while ( line != "")
                {
                    line = t.readLine();
                    if (line != "")
                        editor_widget -> editor_down -> insertLine(line);
                }
            }
            if (line == "[solved]")
            {
                for (int i = 0; i <= pw -> puzzle.height - 1; i++)
                {
                    line = t.readLine();
                    pw -> puzzle.solve [i] = line;
                }
            }
            if (line == "[reveal]")
            {
                for (int i = 0; i <= pw -> puzzle.height - 1; i++)
                {
                    line = t.readLine();
                    pw -> puzzle.reveal [i] = line;
                }
            }
            line = t.readLine();
        }
        f.close();
        pw -> puzzle.file = file;
        pw -> puzzle.changed = FALSE;
        filemenu -> setItemEnabled(savepuz_id,TRUE);
        resizeWidget();
        editorToQuestions();
        if (pw -> puzzle.title == "" || pw ->puzzle.title == "Template" || pw -> puzzle.title == "template")
        {
            pw -> edit_mode = TRUE;
            editor_widget -> show();
        }
        else
        {
            pw -> edit_mode = FALSE;
            questions_widget -> show();
        }
        pw -> show();
    }
}

void Krossword::closeDatabase()
{
    if (puzzle_open)
    {
        title -> setText ("");
        author -> setText("");
        copyright -> setText("");
        pw -> puzzle.changed = FALSE;
        pw -> puzzle.file ="";
        delete [] pw -> puzzle.solution;
        delete [] pw -> puzzle.solve;
        delete [] pw -> puzzle.reveal;
        delete [] pw -> puzzle.across;
        delete [] pw -> puzzle.down;
        delete [] pw -> puzzle.across_question_number;
        delete [] pw -> puzzle.down_question_number;
        editor_widget -> editor_across -> clear();
        editor_widget -> editor_down -> clear();
        pw -> hide();
        questions_widget -> hide();
        puzzle_open = FALSE;
        optionsmenu -> setItemEnabled(show_word_corr_id,FALSE);
        optionsmenu -> setItemEnabled(show_letter_corr_id,FALSE);
        optionsmenu -> setItemEnabled(dont_show_corr_id,FALSE);


        editor_widget -> line_title -> setText("");
        editor_widget -> line_author -> setText("");
        editor_widget -> line_copyright -> setText("");
        editor_widget -> hide();
    }
}

void Krossword::resizeWidget()
{
    int x = pw -> puzzle.width * pw -> square_size + 1;
    int y = pw -> puzzle.height * pw -> square_size + 1;
    pw -> setGeometry (5,95, x,y);
    puzzleframe -> setGeometry(0,90,x + 10, y + 10);
    this -> setFixedSize(x + 10,y + 135);
    author -> setGeometry(5,this -> height() - 30,150,25);
    copyright -> setGeometry(this -> width() - 5 - 150,this -> height() - 30, 150,25);
}

void Krossword::savePuzzleAs(){
	QString file = QFileDialog::getSaveFileName(0,"*.pff",this);
	pw -> puzzle.file = file;
	save(file);
}

void Krossword::savePuzzle(){
	if (puzzle_open){
		QString file = pw -> puzzle.file;
		if (file == "" || file.isNull())
			savePuzzleAs();
		else
			save(file);
		}
}

void Krossword::save(QString file)
{
    if (!file.isNull())
    {

        pw -> puzzle.changed = FALSE;
        editorToQuestions();
        QFile f( ( const char * ) file);
        f.open(IO_WriteOnly | IO_Truncate);
        QString string = editor_widget -> line_title -> text();
        f.writeBlock("[title]\n",8);
        f.writeBlock(string + "\n", string.length() + 1);
        f.writeBlock("\n",1);
        string = editor_widget -> line_author -> text();
        f.writeBlock("[author]\n",9);
        f.writeBlock(string + "\n", string.length() + 1);
        f.writeBlock("\n",1);
        string = editor_widget -> line_copyright -> text();
        f.writeBlock("[copyright]\n",12);
        f.writeBlock(string + "\n", string.length() + 1);
        f.writeBlock("\n",1);
        f.writeBlock("[puzzle]\n",9);
        for (int i = 0; i <= pw -> puzzle.height - 1; i++)
            f.writeBlock( pw -> puzzle.solution[i]+"\n",pw -> puzzle.solution[i].length() + 1);
        f.writeBlock("\n",1);
        f.writeBlock("[across]\n",9);
        for (int i = 0; i <= pw -> puzzle.acrnumber - 1; i++)
            f.writeBlock( pw -> puzzle.across[i]+"\n",pw -> puzzle.across[i].length() + 1);
        f.writeBlock("\n",1);
        f.writeBlock("[down]\n",7);
        for (int i = 0; i <= pw -> puzzle.downumber - 1; i++)
            f.writeBlock( pw -> puzzle.down[i]+"\n",pw -> puzzle.down[i].length() + 1);
        if (!pw -> edit_mode)
        {
            f.writeBlock("\n",1);
            f.writeBlock("[solved]\n",9);
            for (int i = 0; i <= pw -> puzzle.height - 1; i++)
                f.writeBlock( pw -> puzzle.solve[i]+"\n",pw -> puzzle.solve[i].length() + 1);
            f.writeBlock("\n",1);
            f.writeBlock("[reveal]\n",9);
            for (int i = 0; i <= pw -> puzzle.height - 1; i++)
                f.writeBlock( pw -> puzzle.reveal[i]+"\n",pw -> puzzle.reveal[i].length() + 1);
        }
        f.close();
    }
}

void Krossword::showWordCorr()
{
    optionsmenu -> setItemChecked(dont_show_corr_id,FALSE);
    optionsmenu -> setItemChecked(show_word_corr_id,TRUE);
    optionsmenu -> setItemChecked(show_letter_corr_id,FALSE);
    pw -> ShowWordCorr_bl = TRUE;
    pw -> ShowLetterCorr_bl = FALSE;
}

void Krossword::showLetterCorr()
{
    optionsmenu -> setItemChecked(dont_show_corr_id,FALSE);
    optionsmenu -> setItemChecked(show_word_corr_id,FALSE);
    optionsmenu -> setItemChecked(show_letter_corr_id,TRUE);
    pw -> ShowWordCorr_bl = FALSE;
    pw -> ShowLetterCorr_bl = TRUE;
}

void Krossword::dontShowCorr()
{
    optionsmenu -> setItemChecked(dont_show_corr_id,TRUE);
    optionsmenu -> setItemChecked(show_word_corr_id,FALSE);
    optionsmenu -> setItemChecked(show_letter_corr_id,FALSE);
    pw -> ShowWordCorr_bl = FALSE;
    pw -> ShowLetterCorr_bl = FALSE;
}

void Krossword::questionsWidgetSelect(int i, bool b,bool a)
{
    if (a && i > -1)
    {
        questions_widget -> across_listbox -> setSelected(i,b);
        questions_widget -> across_listbox -> centerCurrentItem();
    }
    if (!a && i > -1)
    {
        questions_widget -> down_listbox -> setSelected(i,b);
        questions_widget -> down_listbox -> centerCurrentItem();
    }
    if (a && i == -1)
        questions_widget -> across_listbox -> clearSelection();
    if (!a && i == -1)
        questions_widget -> down_listbox -> clearSelection();
}

void Krossword::solutionMenuEnable(int i,bool b)
{
    solutionmenu ->  setItemEnabled(i,b);
}

void Krossword::showHelpContents()
{
    kapp -> invokeHTMLHelp("krossword/index.html","");
}
