#ifndef KGAME_H
#define KGAME_H
#include <qobject.h>

void kfmRefresh(const QString &fn);

class KConfig;

class KGame:public QObject
{
  Q_OBJECT
public:
  KGame(QObject *p=NULL, const char *name=NULL);
  int level();
  int maxLevel();
  long rogueGold();
  int rogueHpCur();
  int rogueHpMax();
  int rogueStrCur();
  int rogueStrMax();
  int rogueArmorClass();
  int rogueExp();
  long rogueExpPoints();
  const char *rogueName();
  const char *rogueNick();
  void setRogueNick(const char *);
  const char *hungerStr();
  bool warnOnSearch();
  void setWarnOnSearch(bool b);
  bool warnOnRest();
  void setWarnOnRest(bool b);
public slots:
  void save();
  int save(const char *fn);
  void quit();
signals:
  void newNick();
protected:
  void checkStr();
};

extern KGame *gam;
extern KConfig *cfg;

#endif
