#include <sys/utsname.h>
#include <qtextstream.h>
#include <kmsgbox.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <qfile.h>
#include <kapp.h>
#include <qdir.h>
#include "rogue/rogue.h"
#include "rogue/dun.h"
#include "kcharfile.h"
#include "kmsgbar.h"
#include "kinvwnd.h"
#include "roguec.h"
#include "kgame.h"
#include "kdun.h"

void createTarball(const char *fn, const char *dir)
{
  int ret;
  char cmd[300], cdir[300];
  getcwd(cdir, 300);
  if (chdir(dir)==-1)
  {
    KMsgBox::message(kapp->mainWidget(), i18n("Rogue"),
        i18n("Cannot change directory\n"));
    return;
  }
  snprintf(cmd, 300, "tar -czf %s *", fn, dir);
  ret=system(cmd);
  if (ret)
  {
    snprintf(cmd, 300, i18n("tar command failed (returned code %d)"), ret);
    KMsgBox::message(kapp->mainWidget(), i18n("Rogue"), cmd, KMsgBox::EXCLAMATION);
  }
  chdir(cdir);
}

void removeDir(const char *dir)
{
  char cmd[300];
  int ret;
  snprintf(cmd, 300, "rm -fR %s", dir);
  ret=system(cmd);
  if (ret)
  {
    snprintf(cmd, 300, i18n("couldn't remove temporary dir (returned code %d)"), ret);
    KMsgBox::message(kapp->mainWidget(), i18n("Rogue"), cmd, KMsgBox::EXCLAMATION);
  }
}

KCharFile::KCharFile()
{
}

KCharFile::~KCharFile()
{
}

void KCharFile::store(const QString &, short other)
{
  char str[200], str2[MSGLEN];
  object *o;
  long exp;
  int i;
  title(gam->rogueName());
  exp=gam->level();
  if (other==0)
    if (gam->level()==gam->maxLevel())
      format_str(str2, "went to level ${0}", "cfwentlvl", 1, LNUMBER, 0, &exp);
      else format_str(str2, "returned to level ${0}", "cfretlvl", 1, LNUMBER,
                      0, &exp);
    else if (other==WIN) strncpy(str2,
      i18n("found the Amulet of Yendor and returned from the Dungeons"), MSGLEN-1);
    else if (other==QUIT) format_str(str2, "quit on level ${0}", "diedof", 1,
                                     LNUMBER, 0, &exp);
    else format_str(str2, "died on level ${0}", "cfdied", 1, LNUMBER, 0, &exp);
  title(str2);
  endTitle();
  if (gam->maxLevel()!=gam->level())
  {
    exp=gam->maxLevel();
    format_str(str2, "(was seen on level ${0})", "cfwentto", 1, LNUMBER, 0, &exp);
    writeCenter(str2);
  }
  if (score_only)
    writeCenter(i18n("(used the Wizard cheat)"));

  section(i18n("Dungeon map"));
  drawMap();

  section(i18n("Rogue characteristics"));
  exp=gam->rogueExpPoints();
  format_str(str2, "Experience level: %d (${0} experience points)", "cfexplvl",
      1, LNUMBER, 0, &exp);
  snprintf(str, 200, str2, gam->rogueExp());
  write(str);
  if (!other)
  {
    snprintf(str, 200, i18n("Hitpoints: %d of %d"), gam->rogueHpCur(),
        gam->rogueHpMax());
    write(str);
  }
  snprintf(str, 200, i18n("Strength: %d of %d"), gam->rogueStrCur(),
      gam->rogueStrMax());
  write(str);
  exp=gam->rogueGold();
  format_str(str2, "${0} pieces of gold", "gold", 1,
	LNUMBER, 0, &exp);
  snprintf(str, 200, i18n("Gold: %s"), str2);
  write(str);
  i=rogue.armor->in_use_flags&BEING_WORN;
  rogue.armor->in_use_flags&=~BEING_WORN;
  get_desc(rogue.armor, str2);
  str2[strlen(str2)-1]='\0';   //remove ' '
  snprintf(str, 200, i18n("Armor class: %d (%s)"),
      gam->rogueArmorClass(), str2);
  write(str);
  rogue.armor->in_use_flags|=i;
  write("");

  section(i18n("Inventory"));
  o=&rogue.pack;
  while ((o=o->next_object)!=NULL)
  {
    get_desc(o, str2);
    writeObj(o, str2);
  }
  write("");

  section(i18n("Last messages"));
  for (i=0; i<msg->msgCount(); i++)
    write(msg->getMessage(i));
  write(NULL);
}

void KTextCharFile::store(const QString &fn, short other)
{
  file=new QFile(fn);
  CHECK_PTR(file);
  t=new QTextStream(file);
  CHECK_PTR(t);
  if (!file->open(IO_WriteOnly))
  {
    KMsgBox::message(kapp->mainWidget(), i18n("Rogue"),
        i18n("Couln't open file."), KMsgBox::EXCLAMATION);
    delete t;
    delete file;
    return;
  }
  KCharFile::store(fn, other);
  delete t;
  delete file;
}

void KTextCharFile::write(const QString &str)
{
  *t<<str<<"\n";
}

void KTextCharFile::writeCenter(const QString &str)
{
  QString s;
  s.fill(' ', (80-str.length())/2);
  *t<<s<<str<<"\n";
}

void KTextCharFile::title(const QString &str)
{
  QString s;
  int l;
  if ((l=str.length())<79) s.fill(' ', (80-l)/2);
    else s="";
  printf("%s", kapp->getLocale()->getLocale("LC_CTYPE"));
  printf("%s", kapp->getLocale()->getLocale("LC_CTYPE"));
  *t<<s<<str.upper()<<"\n\n";
}


void KTextCharFile::section(const QString &str)
{
  QString s;
  int l;
  if ((l=str.length())<77) s.fill('-', (80-l)/2-2);
    else s="";
  *t<<s<<' '<<str<<' '<<s;
  if (!(l%2)) *t<<'-';
  *t<<"\n";
}

char KTextCharFile::getMapChar(int i)
{
  int obj, fl;
  obj=i&OBJMASK;
  switch (obj)
  {
    case V_ARMOR:  return ']';
    case V_WEAPON: return ')';
    case V_SCROLL: return '?';
    case V_GOLD:   return '*';
    case V_FOOD:   return ':';
    case V_WAND:   return '/';
    case V_RING:   return '=';
    case V_AMULET: return ',';
    case V_ROGUE:  return '@';
    case V_FLAME:  return '~';
    case V_POTION: return '!';
    case V_NOTHING:
      fl=i>>FLSH;
      switch (fl)
      {
        case V_STAIRS:
        case V_STAIRS+V_DARK:
        case V_TUNSTAIRS: return '%';
        case V_HORWALL:   return '-';
        case V_VERTWALL:  return '|';
        case V_DOOR:      return '+';
        case V_FLOOR:     return '.';
        case V_FLOOR+V_DARK:
        case V_NOTHING:   return ' ';
        case V_TUNNEL:    return '#';
        case V_TRAP+V_DARK:
        case V_TRAP:      return '^';
        default:
          return ' ';
      }
    default:
      obj-=V_MONSTER;
      if (obj>=0 && obj<=25) return obj+'A';
      return '~';
  }
}

void KTextCharFile::drawMap()
{
  int i, j;
  for (i=0; i<DROWS; i++)
  {
    for (j=0; j<DCOLS; j++)
    {
      *t<<getMapChar(vdungeon[i][j]);
    }
    *t<<"\n";
  }
}

void KTextCharFile::writeObj(object *o, char *str)
{
  write(QString()+o->ichar+") "+str);
}

void KHTMLCharFile::store(const QString &fn, short other)
{
  file=new QFile();
  CHECK_PTR(file);
  t=new QTextStream(file);
  CHECK_PTR(t);
  char *tn=tempnam(NULL, "krcf");
  QString str;
  QDir dir;
  if (!tn || !dir.mkdir(tn, true))
  {
    KMsgBox::message(kapp->mainWidget(), i18n("Rogue"),
      QString(i18n("Cannot create temporary dir:\n"))+(tn?tn:"(null)"),
      KMsgBox::EXCLAMATION);
    if (tn) free(tn);
    return;
  }
  dir.setPath(tn);
  free(tn);
  file->setName(QString(dir.path())+"/index.html");
  if (!file->open(IO_WriteOnly))
  {
    KMsgBox::message(kapp->mainWidget(), i18n("Rogue"),
        i18n("Couln't open file."), KMsgBox::EXCLAMATION);
    delete t;
    delete file;
    return;
  }
  *t<<"<HTML>\n<HEAD>\n";
  *t<<"  <TITLE>"<<i18n("KRogue character file")<<"</TITLE>\n";
  if ((str=kapp->getLocale()->charset())!="us-ascii")
    *t<<"  <META http-equiv=\"Content-Type\" content=\"text/html; charset="
      <<str<<"\">\n";
  *t<<"  <META name=\"generator\" content=\"krogue-" KR_VERSION " (";
  utsname sysname;
  uname(&sysname);
  *t<<sysname.sysname<<" "<<sysname.release<<", KDE " KDE_VERSION_STRING ")\">\n";
  *t<<"</HEAD>\n\n";
  *t<<"<BODY bgcolor=#ffffff>\n";
  KCharFile::store(fn, other);
  *t<<"\n</BODY>\n</HTML>\n";
  str=dir.path();
  dun->storeMap(str+"/map.png");
  int i;
  str+="/item";
  for (i=0; i<10; i++)
    if (usePixmaps[i])
    {
      QString str2;
      str2.setNum(i);
      dun->storeItemPix(i, str+str2+".png");
    }
  delete t;
  delete file;
  createTarball(fn, dir.path());
  removeDir(dir.path());
}

void KHTMLCharFile::title(const QString &str)
{
  if (inTitle) *t<<"<br>\n  ";
    else *t<<"<H1 align=center>\n  ";
  inTitle=true;
  *t<<str;
}

void KHTMLCharFile::endTitle()
{
  *t<<"\n</H1>\n";
  parend=true;
}

void KHTMLCharFile::setPar(bool newPar, bool cent)
{
  if (parend && cent==parcent) return;
  if (cent!=parcent || newPar)
  {
    if (cent)
    {
      if (!parend) *t<<"\n";
      *t<<"<p align=center>";
    } else *t<<"<p>\n";
    parcent=cent;
    return;
  }
  *t<<"<br>\n";
}

void KHTMLCharFile::section(const QString &str)
{
  setPar(true, false);
  *t<<"\n<HR>\n<H3 align=center>"<<str<<"</H3>\n";
  parend=true;
}

void KHTMLCharFile::write(const QString &str)
{
  if (str.isNull() || str.isEmpty()) return;
  setPar(false, false);
  *t<<str;
  parend=false;
}

void KHTMLCharFile::writeCenter(const QString &str)
{
  setPar(false, true);
  *t<<str;
  parend=false;
}

void KHTMLCharFile::writeObj(obj *o, char *desc)
{
  if (!parend) *t<<"<br>\n";
  int itemid=KInvWnd::getObjIconId(o);
  usePixmaps[itemid]=true;
  *t<<"<img align=middle src=item"<<itemid<<".png> "
    <<"<code>"<<(char)o->ichar<<") "<<"</code>"<<desc;
  parend=false;
}

void KHTMLCharFile::drawMap()
{
  setPar(true, true);
  *t<<"<img src=\"map.png\" alt=\""<<i18n("[Map image]")<<"\" height="<<
     PIXMAP_Y*DROWS<<" width="<<PIXMAP_X*DCOLS<<">";
  parend=false;
}
