#include "fruit.h"

Fruit::Fruit(Board *b)
{
    board = b;
    setLevel(0, 0, 0);
}

void Fruit::setEaten(int duration)
{
    actualState = eaten;
    timeLeft = duration;
}
  
void Fruit::setLevel(int level, int wDuration, int fDuration)
{
    actualLevel = level;
    waitDuration = wDuration;
    fruitDuration = fDuration;
    actualState = inactive;
    timeLeft = waitDuration;
    lastPosition = OUT;
    setPosition(OUT);
}

void Fruit::setPosition(int pos)
{
    board->reset(lastPosition, fruit);
    actualPosition = lastPosition = pos;
    board->set(actualPosition, fruit);
}

fruitState Fruit::state()
{
    return actualState;
}

int Fruit::position()
{
    return actualPosition;
}

bool Fruit::move()
{
    if (timeLeft > 0) {
	timeLeft--;
	if (timeLeft == 0) {
	    if (actualState == inactive) {
		setPosition(board->position(fruithome));
		timeLeft = fruitDuration;
		actualState = active;
	    } else {
		setPosition(OUT);
		timeLeft = waitDuration;
		actualState = inactive;
	    }
	    return TRUE;
	}
    }
    return FALSE;
}

int Fruit::pix()
{
    if (actualPosition == OUT || actualState == inactive)
	return -1;

    return actualLevel-1;
}

