#include <status.h>
#include <status.moc>

#include <qpixmap.h>
#include <qbitmap.h>
#include <qstring.h>
#include <qmsgbox.h>

Status::Status( QWidget *parent, const char *name, QString pixDir ) : QWidget( parent, name )
{
    actualLifes = 0;
    actualLevel = 0;

    lifesPix = NULL;
    levelPix = NULL;

    setPixmaps(pixDir);
}

QList<QPixmap> *Status::loadPixmap(QWidget *parent, QString pixmapName, QList<QPixmap> *pixmaps)
{
    if (pixmaps == NULL) {
	pixmaps = new QList<QPixmap>;
	pixmaps->setAutoDelete(TRUE);
    }

    if (!pixmaps->isEmpty())
	pixmaps->clear();

    QPixmap PIXMAP(pixmapName);
    if (PIXMAP.isNull()) {
 	QString msg = i18n("The pixmap could not be contructed.\n\n"
			   "The file '@PIXMAPNAME@' does not exist,\n"
			   "or is of an unknown format.");
	msg.replace(QRegExp("@PIXMAPNAME@"), pixmapName);
	QMessageBox::information(parent, i18n("Initialization Error"),
			 	 (const char *) msg);
	return 0;
    }

    int height = PIXMAP.height();
    int	width = (height == 0) ? 0 : PIXMAP.width()/(PIXMAP.width()/height);
    
    QBitmap BITMAP;
    QBitmap MASK;

    BITMAP = *PIXMAP.mask();
    MASK.resize(width, height);

    int x;
    for (x = 0; x < PIXMAP.width()/width; x++) {
	QPixmap *pixmap = new QPixmap(width, height);
	pixmaps->append(pixmap);
	bitBlt(pixmap, 0, 0, &PIXMAP, x*width, 0, width, height, CopyROP, TRUE);
	bitBlt(&MASK, 0, 0, &BITMAP, x*width, 0, width, height, CopyROP, TRUE);
	pixmap->setMask(MASK);
    }

    return pixmaps;
}

void Status::paintEvent( QPaintEvent *)
{
    for (int x = 0; x < actualLifes && !lifesPix->isEmpty(); x++)
	bitBlt(this, lifesPix->at(0)->width()+(lifesPix->at(0)->width()*x), 
	       (height()-lifesPix->at(0)->height())/2,
	       lifesPix->at(0), 0, 0,
	       lifesPix->at(0)->width(), lifesPix->at(0)->height());

    for (int x = 0; x < actualLevel && !levelPix->isEmpty(); x++) {
        erase((width()-levelPix->at(x)->width()*2)-(levelPix->at(x)->width()*levelPos[x]),
	      (height()-levelPix->at(x)->height())/2,
	      levelPix->at(x)->width(), levelPix->at(x)->height());
	bitBlt(this, (width()-levelPix->at(x)->width()*2)-(levelPix->at(x)->width()*levelPos[x]),
	       (height()-levelPix->at(x)->height())/2,
	       levelPix->at(x), 0, 0,
	       levelPix->at(x)->width(), levelPix->at(x)->height());
    }
}

void Status::fillArray(QArray<int> &array, QString values, int max)
{
    array.resize(max);
    int last = 0;
    bool ok;
    QString value;

    for (uint i = 0; i < array.size(); i++) {
	if (values.find(',') < 0 &&  values.length() > 0) {
	    value = values;
	    values = "";
        }
	if (values.find(',') >= 0) {
	    value = values.left(values.find(','));
	    values.remove(0,values.find(',')+1);
	}
	array[i] = value.toInt(&ok);
	if (ok)
	    last = array[i];
	else
            array[i] = last;
    }
}

void Status::setPixmaps(QString pixDir)
{
    lifesPix = loadPixmap(this, pixDir+"lifes.xpm", lifesPix);
    levelPix = loadPixmap(this, pixDir+"level.xpm", levelPix);

    KConfig *conf = kapp->getConfig();

    maxLevel = conf->readNumEntry("Levels", 13);

    fillArray(levelPos, conf->readEntry("LevelPosition", "0,1,2,3,,4,,5,,6,,7"), maxLevel);

    setFixedHeight(minHeight());
    repaint();
}

int Status::minHeight()
{
    if (lifesPix->isEmpty() && levelPix->isEmpty())
	return 0;
    if (levelPix->isEmpty())
	return lifesPix->at(0)->height();
    if (lifesPix->isEmpty())
	return levelPix->at(0)->height();
    return (lifesPix->at(0)->height() > levelPix->at(0)->height()) ?
	    lifesPix->at(0)->height() : levelPix->at(0)->height();
}

int Status::minWidth()
{
    if (lifesPix->isEmpty() && levelPix->isEmpty())
	return 0;
    if (levelPix->isEmpty())
	return lifesPix->at(0)->width();
    if (lifesPix->isEmpty())
	return levelPix->at(0)->width();
    return (lifesPix->at(0)->width() > levelPix->at(0)->width()) ?
	    lifesPix->at(0)->width() : levelPix->at(0)->width();
}

void Status::setLifes(int lifes)
{
    actualLifes = lifes;
    repaint();
}

void Status::setLevel(int level)
{
    actualLevel = (level > (int) levelPix->count()) ? (int) levelPix->count() : level;
    repaint();
}
