#include "kmaster.h"

HintField::HintField(QWidget* parent) : QWidget(parent)
{
  moveCounter = 0;
  setMinimumSize(4*FIELD_WIDTH, 10*FIELD_WIDTH);
  setMaximumSize(4*FIELD_WIDTH, 10*FIELD_WIDTH);

  setBackgroundColor(*(new QColor(67, 183, 183)));
}

void HintField::drawHint(int p, int c)
{
  posOK = p;
  colorOK = c;
  moveCounter++;
  repaint(false);
}

void HintField::paintEvent(QPaintEvent* event)
{
  QPainter p;
  p.begin(this);
  
  p.setBrush(white);

  if(moveCounter > 0)
    {
      p.setBrush(gray);

      for(int i = 0; i < posOK; i++)
	{
	  p.drawEllipse(i*FIELD_WIDTH, (moveCounter-1)*FIELD_WIDTH, FIELD_WIDTH, FIELD_WIDTH);
	}

      p.setBrush(white);

      for(int i = posOK; i < colorOK; i++)
	{
	  p.drawEllipse(i*FIELD_WIDTH, (moveCounter-1)*FIELD_WIDTH, FIELD_WIDTH, FIELD_WIDTH);
	}
    }
  p.end();
}

void HintField::setStartPosition()
{
  moveCounter = 0;
}

  


