#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <jewel.h>
// #include <qpainter.h>
#include <qcolor.h>
#include <stream.h>

QColor Jewel::colorList[8]={
  QColor(255,255,255),
  QColor(255,0,10),
  QColor(0,255,10),
  QColor(0,0,255),
  QColor(255,255,0),
  QColor(0,255,255),
  QColor(255,0,255),
  QColor(200,100,0)
};

Jewel::Jewel(const short p,const short maxcol,const QString *b){
  int i;
  
  baseDir=b;
  loadPics();
  parts=new(short[p+1]);
  numParts=p;
  maxColors=maxcol;
  xp=3;yp=14;  
  srand((unsigned int)time(0));
  newJewel();
}

void Jewel::loadPics(){

  jewelPixmaps[0]= new(QPixmap)(*baseDir+ QString("/kjewel/pics/any_j.gif"));
  jewelPixmaps[1]= new(QPixmap)(*baseDir+ QString("/kjewel/pics/red_j.gif"));
  jewelPixmaps[2]= new(QPixmap)(*baseDir+ QString("/kjewel/pics/blue_j.gif"));
  jewelPixmaps[3]= new(QPixmap)(*baseDir+ QString("/kjewel/pics/green_j.gif"));
  jewelPixmaps[4]= new(QPixmap)(*baseDir+ QString("/kjewel/pics/yellow_j.gif"));
  jewelPixmaps[5]= new(QPixmap)(*baseDir+ QString("/kjewel/pics/malve_j.gif"));
  jewelPixmaps[6]= new(QPixmap)(*baseDir+ QString("/kjewel/pics/sea_j.gif"));
  jewelPixmaps[7]= new(QPixmap)(*baseDir+ QString("/kjewel/pics/grey_j.gif"));
  jewelPixmaps[8]= new(QPixmap)(*baseDir+ QString("/kjewel/pics/muncher.gif"));
}

const Jewel &Jewel::operator=(const Jewel &nj)
{
  int i;

  if(parts)delete[](parts);
  parts=new(short[nj.numParts+1]);
  xp=nj.xp;
  yp=nj.yp;
  maxColors=nj.maxColors;
  numParts=nj.numParts;
  for(i=0;i<numParts;i++)parts[i]=nj.parts[i];
  return((const Jewel&)(*this));
}

short Jewel::x(){
  return(xp);
}

short Jewel::y(){
  return(yp);
}

void Jewel::newJewel(){
  int i;

  if(!(rand()%100)){
    for(i=0;i<numParts;i++)parts[i]=10;
    return;
  };
  for(i=0;i<numParts;i++)parts[i]=(rand()%maxColors)+1;
  for(i=0;i<numParts;i++)
    if(!(rand()%100))parts[i]=100;
}

void Jewel::show(QPainter &p){
  int i;
  QBrush br;
  
  p.setPen(NoPen);
  br.setStyle(SolidPattern);
  /*  if(parts[0]==10){
    br.setStyle(CrossPattern);
    br.setColor(QColor("white"));
    for(i=0;i<numParts;i++)
      p.fillRect(xp*32+2,32*16-(yp*32+2+i*32),31,31,br);
    return;
  };*/
  for(i=0;i<numParts;i++){
    if(parts[i]<100)
        p.drawPixmap(xp*32+2,32*16-(yp*32+2+i*32)
		     ,*jewelPixmaps[parts[i]==10?8:parts[i]]);
      else{
	p.drawPixmap(xp*32+2,32*16-(yp*32+2+i*32),*jewelPixmaps[0]);
      };
    if(parts[i]==10)
      p.drawPixmap(xp*32+2,32*16-(yp*32+2+i*32),*jewelPixmaps[8]);
    //    p.fillRect(xp*32+2,32*16-(yp*32+2+i*32),31,31,br);
  };
}


void Jewel::step()
{
  yp--;
}
void Jewel::up()
{ 
  int i,h;
  h=parts[numParts-1];
  for(i=numParts-2;i>=0;i--)parts[i+1]=parts[i];
  parts[0]=h;
}
void Jewel::down()
{ 
  int h,i;
  h=parts[0];
  for(i=0;i<=numParts-2;i++)parts[i]=parts[i+1];
  parts[numParts-1]=h;
}

QRect Jewel::topRect()const{
  QRect rect;

  rect.setY(32*13-((yp-1)*32+2));
  rect.setX(xp*32+2);
  rect.setWidth(32);
  rect.setHeight(32);
  return(rect);
}

QRect Jewel::thisRect()const{
  QRect rect;

  rect.setY(32*13-((yp-1)*32+2));
  rect.setX(xp*32+2);
  rect.setWidth(32);
  rect.setHeight(32*numParts);
  return(rect);
}
