#include <qmessagebox.h>
#include <qkeycode.h>
#include <kgredit.h>
#include <kgredit.moc>

const int ID_NEW=111;
const int ID_OPEN=112;
const int ID_SAVE=113;
const int ID_SAVEAS=114;
const int ID_EXIT=115;

const int ID_HERO=211;
const int ID_ENEMY=212;
const int ID_LADDER=213;
const int ID_HLADDER=214;
const int ID_BRICK=215;
const int ID_BETON=216;
const int ID_FBRICK=217;
const int ID_POLE=218;
const int ID_NUGGET=219;
const int ID_ERASE=220;

const int ID_HELP=511;
const int ID_ABOUT=512;
const int ID_KDE=513;
const int ID_STATUSTEXT = 611;

// kgredit -- Konstruktor
kgredit::kgredit(QWidget *parent, const char *name)
	: KTopLevelWidget(name)
{
  KIconLoader *loader = kapp->getIconLoader();
  
  QDir tmpdir = QDir(KApplication::localkdedir()+"/share/apps/kgoldrunner");
  QDir grdir = QDir(KApplication::localkdedir()+"/share/apps/kgoldrunner/levels");

  if (!grdir.exists())
    {
      KMsgBox::message(this,klocale->translate("erzeuge Verzeichnis"),
	      klocale->translate("Ich vermisse das private Levelverzeichnis. Erzeuge jetzt \n")+tmpdir.absPath()
	      );
      if (!tmpdir.exists())
	{
	  if (!tmpdir.mkdir(tmpdir.absPath()))
	    {
	      KMsgBox::message(this,klocale->translate("Fehler"),
			       klocale->translate("Konnte folgendes Verzeichnis nicht erzeugen.\n")+tmpdir.absPath());
	      exit(0);
	    }; 
	}
      if (!grdir.mkdir(grdir.absPath()))
	{
	  KMsgBox::message(this,klocale->translate("Fehler"),
			   klocale->translate("Konnte folgendes Verzeichnis nicht erzeugen.\n")+grdir.absPath());
	  exit(0);
	}; 
    }

  initMenubar();
  initToolbar();
  initStatusbar();
  setCaption(klocale->translate("kgredit Version 0.1 (neuer Level)"));

  view = new kgreditWidget(this);
  setView(view);
  view->setBackgroundPixmap(loader->loadIcon("wallbg.xpm"));
  connect(view,SIGNAL(changed()),SLOT(enableSave()));

  activeObject = ID_HERO;

  noname = true;
  changed = false;

  lLevel=new LoadLevel();
  sLevel=new SaveLevel();
}

// kgredit -- Destructor
kgredit::~kgredit()
{
  delete filetoolBar;
  delete objtoolBar;
  delete statusBar;
  delete menuBar;
}


void kgredit::commandCallback(int id)
{ 
  switch (id)
    {
    case ID_NEW:  
      if(myexit())
	{
	  noname = true;
	  view->setchanged(false); 
	  changed =false;
	  view->setActiveObject('R'); // Held aktivieren
	  objtoolBar->setButton(activeObject,false); 
	  activeObject=ID_HERO;
	  objtoolBar->setButton(activeObject,true);
	  setCaption(klocale->translate("kgredit Version 0.1 (neuer Level)")); // Title ndern
	  statusBar->changeItem(klocale->translate("keine nderungen"),ID_STATUSTEXT); //Statusbar ndern
	  changed = false; // nix gendert
	  disableCommand(ID_SAVE); // also nicht Saven
	  view->clearBoard();
	}
      break;
    case ID_OPEN: 
      if(lLevel->exec())
	{
	  filename = lLevel->getFileName();
	  QFile f(filename);
	  if (!f.exists())
	    KMsgBox::message(this,klocale->translate("lade Level"),
			     klocale->translate("Tut mir leid!\nDieser Level ist nicht vorhanden."));
	  else if (!f.open(IO_ReadOnly))
	    KMsgBox::message(this,klocale->translate("lade Level"),
			     klocale->translate("Tut mir leid!\nDer Level scheint mir keine Leseberechtigung zu geben."));
	  else {
	    view->load(f);
	    noname = false;
	    setCaption("kgredit Version 0.1 (Level "+lLevel->getLCD()+")" ); // Title ndern
	    f.close();}
	}
      break;
    case ID_SAVE:  
      if (noname)
	{saveAs();}
      else
	{
	  QFile f(filename);
	  if(!f.open(IO_Raw|IO_Truncate|IO_WriteOnly))
	    KMsgBox::message(this,klocale->translate("Level sichern"),
			     klocale->translate("Tut mir leid!\nDer Level scheint mir keine Scheibberechtigung zu geben."));
	  else  view->save(f);
	  f.close();
	  view->setchanged(false);
	  changed =false;
	  statusBar->changeItem(klocale->translate("keine nderungen"),ID_STATUSTEXT); //Statusbar ndern
	  disableCommand(ID_SAVE);
	}break;
    case ID_SAVEAS: 
      saveAs();break;
    case ID_EXIT: if(myexit()) exit(0);break;
    case ID_HERO: view->setActiveObject('R');break;
    case ID_ENEMY: view->setActiveObject('E');break;
    case ID_NUGGET: view->setActiveObject('N');break;
    case ID_BRICK: view->setActiveObject('M');break;
    case ID_BETON: view->setActiveObject('X');break;
    case ID_FBRICK: view->setActiveObject('F');break;
    case ID_LADDER: view->setActiveObject('H');break;
    case ID_HLADDER: view->setActiveObject('Z');break;
    case ID_POLE: view->setActiveObject('T');break;
    case ID_ERASE: view->setActiveObject(' ');break;
    }
  if ((id >= 200) && (id < 300))
    {
      objtoolBar->setButton(activeObject,false);
      activeObject=id;
      objtoolBar->setButton(activeObject,true);
    }
}

void kgredit::saveAs()
{
  if(sLevel->exec())
    {
      filename = sLevel->getFileName();
      QFile f(filename);
      if (f.exists())
	{
	  if((KMsgBox::yesNo(this,klocale->translate("Level sichern"),
			     klocale->translate("Dieser Level existiert schon.\nTrotzdem sichern?"),8,
			     klocale->translate("Jupps"),klocale->translate("Nee")))==1)
	    {
	      if(!f.open(IO_Raw|IO_Truncate|IO_WriteOnly))
		{
		  KMsgBox::message(this,klocale->translate("Level sichern"),
				   klocale->translate("Tut mir leid!\nDer Level scheint mir keine Scheibberechtigung zu geben."));
		}
	      else
		{
		  view->save(f);
		  view->setchanged(false); 
		  setCaption("kgredit Version 0.1 (Level "+sLevel->getLCD()+")" ); // Title ndern
		  changed =false;
		  noname = false;
		  statusBar->changeItem(klocale->translate("keine nderungen"),ID_STATUSTEXT); //Statusbar ndern
		  disableCommand(ID_SAVE);
		  f.close();
		}
	    }
	}
      else
	{
	  if(!f.open(IO_Raw|IO_Truncate|IO_WriteOnly))
	    {
	      KMsgBox::message(this,klocale->translate("Level sichern"),
			       klocale->translate("Tut mir leid!\nDer Level scheint mir keine Scheibberechtigung zu geben."));
	    }
	  else
	    {
	      view->save(f);
	      view->setchanged(false); 
	      setCaption("kgredit Version 0.1 (Level "+sLevel->getLCD()+")" ); // Title ndern
	      changed =false;
	      noname = false;
	      statusBar->changeItem(klocale->translate("keine nderungen"),ID_STATUSTEXT); //Statusbar ndern
	      disableCommand(ID_SAVE);
	      f.close();
	    }
	}
    }
}

void kgredit::disableCommand(int id)
{
  menuBar->setItemEnabled(id,false);
  if ((id >= 200) && (id < 300))
    {
      objtoolBar->setItemEnabled(id,false);
    } else {
      filetoolBar->setItemEnabled(id,false);
    }
}

void kgredit::enableCommand(int id)
{
  menuBar->setItemEnabled(id,true);
  if ((id >= 200) && (id < 300))
    {
      objtoolBar->setItemEnabled(id,true);
    } else {
      filetoolBar->setItemEnabled(id,true);
    }
}

int kgredit :: myexit()
{
  int ex=0;

  if (!changed)
    ex = 1;
  else
    if (QMessageBox::warning(this,klocale->translate("Ungesicherte nderungen"),
			     klocale->translate("Alle nderungen gehen verloren, wenn Sie\ndies jetzt tun. Sind Sie Sicher?"),
			     klocale->translate("Jupps"),klocale->translate("Nee"),0,1,1))
      ex = 0;
    else 
      ex = 1;
  return ex;
}

void kgredit::initMenubar()
{
  QPopupMenu *file_menu = new QPopupMenu();
  file_menu->insertItem(klocale->translate("&Neu"),ID_NEW);
  file_menu->insertSeparator();
  file_menu->insertItem(klocale->translate("&Laden..."),ID_OPEN);
  file_menu->insertItem(klocale->translate("&Sichern"),ID_SAVE);
  file_menu->insertItem(klocale->translate("&Sichern als..."),ID_SAVEAS);
  file_menu->insertSeparator();
  file_menu->insertItem(klocale->translate("&Schlieen"),ID_EXIT);
  
  QPopupMenu *object_menu = new QPopupMenu();
  object_menu->insertItem(klocale->translate("&Held"),ID_HERO);
  object_menu->insertItem(klocale->translate("&Feind"),ID_ENEMY);
  object_menu->insertItem(klocale->translate("&Leiter"),ID_LADDER);
  object_menu->insertItem(klocale->translate("&versteckte Leiter"),ID_HLADDER);
  object_menu->insertItem(klocale->translate("&Mauerstein"),ID_BRICK);
  object_menu->insertItem(klocale->translate("&Betonstein"),ID_BETON);
  object_menu->insertItem(klocale->translate("&falsche Mauer"),ID_FBRICK);
  object_menu->insertItem(klocale->translate("&Kletterstange"),ID_POLE);
  object_menu->insertItem(klocale->translate("&Goldstck"),ID_NUGGET);
  object_menu->insertSeparator();
  object_menu->insertItem(klocale->translate("L&sche"),ID_ERASE);
  
  menuBar = new KMenuBar(this, "menubar");
  menuBar->insertItem(klocale->translate("&Datei"), file_menu);
  menuBar->insertItem(klocale->translate("&Objekte"), object_menu);
  menuBar->insertSeparator();

  QString about = "KGredit 0.1\n(C) ";
  about += (QString) klocale->translate("von") +
    " Marco Krger\ngrisu@cs.tu-berlin.de";
  menuBar->insertItem( klocale->translate("&Help"), 
		       KApplication::getKApplication()->getHelpMenu(TRUE, about ) );
  connect(file_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(object_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  
  setMenu(menuBar);
}

void kgredit::initStatusbar()
{
  statusBar = new KStatusBar(this);
  statusBar->insertItem(klocale->translate("keine nderungen"),ID_STATUSTEXT);
  statusBar->show();
  setStatusBar(statusBar);
}

void kgredit::initToolbar()
{
  KIconLoader *loader = kapp->getIconLoader();
  
  filetoolBar = new KToolBar(this);
  objtoolBar = new KToolBar(this);

  filetoolBar->insertButton(loader->loadIcon("filenew.xpm"),
			    ID_NEW,TRUE,
			    klocale->translate("neues Level kreieren"));
  filetoolBar->insertButton(loader->loadIcon("fileopen.xpm"),
			    ID_OPEN,TRUE,
			    klocale->translate("bestehendes Level laden"));
  filetoolBar->insertButton(loader->loadIcon("filefloppy.xpm"),
			    ID_SAVE,FALSE,
			    klocale->translate("diesen Level speichern"));

  objtoolBar->insertButton(loader->loadIcon("hero.xpm"),
			   ID_HERO,TRUE,
			   klocale->translate("die Heldenfigur"));
  objtoolBar->insertButton(loader->loadIcon("enemy.xpm"),
			   ID_ENEMY,TRUE,
			   klocale->translate("eine Feindfigur"));
  objtoolBar->insertButton(loader->loadIcon("brick.xpm"),
			   ID_BRICK,TRUE,
			   klocale->translate("Mauersteine"));
  objtoolBar->insertButton(loader->loadIcon("beton.xpm"),
			   ID_BETON,TRUE,
			   klocale->translate("Betonblcke"));
  objtoolBar->insertButton(loader->loadIcon("f_brick.xpm"),
			   ID_FBRICK,TRUE,
			   klocale->translate("falsche Mauer"));
  objtoolBar->insertButton(loader->loadIcon("ladder.xpm"),
			   ID_LADDER,TRUE,
			   klocale->translate("Leiter"));
  objtoolBar->insertButton(loader->loadIcon("hladder1.xpm"),
			   ID_HLADDER,TRUE,
			   klocale->translate("versteckte Leiter"));
  objtoolBar->insertButton(loader->loadIcon("pole.xpm"),
			   ID_POLE,TRUE,
			   klocale->translate("ne' Kletterstange"));
  objtoolBar->insertButton(loader->loadIcon("nugget.xpm"),
			   ID_NUGGET,TRUE,
			   klocale->translate("Goldstck"));
  objtoolBar->insertButton(loader->loadIcon("erase.xpm"),
			   ID_ERASE,TRUE,
			   klocale->translate("Radiergummi"));
  objtoolBar->setToggle(ID_HERO,true);
  objtoolBar->setToggle(ID_ENEMY,true);
  objtoolBar->setToggle(ID_BRICK,true);
  objtoolBar->setToggle(ID_BETON,true);
  objtoolBar->setToggle(ID_FBRICK,true);
  objtoolBar->setToggle(ID_LADDER,true);
  objtoolBar->setToggle(ID_HLADDER,true);
  objtoolBar->setToggle(ID_POLE,true);
  objtoolBar->setToggle(ID_NUGGET,true);
  objtoolBar->setToggle(ID_ERASE,true);

  addToolBar(filetoolBar);
  
  addToolBar(objtoolBar);

  filetoolBar->setBarPos(KToolBar::Top);
  filetoolBar->show();
  
  objtoolBar->setBarPos(KToolBar::Top);
  objtoolBar->show();

  connect(filetoolBar,SIGNAL(clicked(int)),SLOT(commandCallback(int)));
  connect(objtoolBar,SIGNAL(clicked(int)),SLOT(commandCallback(int)));
}

void kgredit :: enableSave()
{
  enableCommand(ID_SAVE);
  changed = true;
  statusBar->changeItem(klocale->translate("nicht gespeicherte nderungen"),ID_STATUSTEXT);  
}


LoadLevel::LoadLevel( QWidget *parent, const char *name )
  : QDialog( parent, name, TRUE )
{
  setFixedSize(290,200);
  
  mainFrame = new QFrame( this, "mainFrame" );
  mainFrame->setGeometry( 5, 5, 280, 190 );
  mainFrame->setFrameStyle(QFrame::Box | QFrame::Raised);
  
  rightBG = new QButtonGroup(mainFrame,"buttonGroup");
  rightBG->setGeometry( 145, 5, 130, 130 );
  rightBG->setFrameStyle(QFrame::Box | QFrame::Raised);

  leftFr = new QFrame(mainFrame,"leftFrame");
  leftFr->setGeometry( 5, 5, 130, 130 );
  leftFr->setFrameStyle(QFrame::Box | QFrame::Raised);

  leftLabel = new QLabel(leftFr,"llabel");
  leftLabel->setGeometry( 5, 5, 115, 55 );
  leftLabel->setFrameStyle(QFrame::NoFrame);
  leftLabel->setText(klocale->translate("Welcher Level soll geladen werden?"));
  leftLabel->setAlignment(AlignLeft|AlignVCenter|WordBreak);

  rightLabel = new QLabel(rightBG,"rlabel");
  rightLabel->setGeometry( 5, 5, 115, 50 );
  rightLabel->setFrameStyle(QFrame::NoFrame);
  rightLabel->setText(klocale->translate("Bitte geben sie die Quelle des Levels an!") );
  rightLabel->setAlignment(AlignLeft|AlignVCenter|WordBreak);

  system = new QRadioButton( rightBG, "RadioButton1" );
  system->setGeometry( 10, 55, 100, 30 );
  system->setText(klocale->translate("Systemweit"));
  system->setAutoRepeat( FALSE );
  system->setAutoResize( FALSE );
  
  local = new QRadioButton( rightBG, "RadioButton2" );
  local->setGeometry( 10, 85, 100, 30 );
  local->setText(klocale->translate("Privat"));
  local->setAutoRepeat( FALSE );
  local->setAutoResize( FALSE );
  local->setChecked( TRUE );

  levelDigit = new QLCDNumber( leftFr, "LCDNumber" );
  levelDigit->setGeometry( 15, 60, 100, 30 );
  levelDigit->setFrameStyle(QFrame::Box | QFrame::Raised);
  levelDigit->setSmallDecimalPoint( FALSE );
  levelDigit->setNumDigits(4);
  levelDigit->setMode( QLCDNumber::DEC );
  levelDigit->setSegmentStyle( QLCDNumber::Outline );
  levelDigit->display(1);

  levelSlider = new QSlider( leftFr, "Lslider" );
  levelSlider->setGeometry( 15, 105, 100, 15 );
  levelSlider->setOrientation( QSlider::Horizontal );
  levelSlider->setRange( 1, 150 );
  levelSlider->setSteps( 1, 1 );
  levelSlider->setValue( 1 );
  levelSlider->setTracking( TRUE );
  levelSlider->setTickmarks(QSlider::Right);
  levelSlider->setTickInterval(10);
  connect(levelSlider,SIGNAL(valueChanged(int)),levelDigit,SLOT(display(int)));
   
  ok = new QPushButton(this,klocale->translate("Ok") );
  ok->setGeometry(15,155,125,30);
  ok->setText( klocale->translate("Ok") );
  connect( ok, SIGNAL(clicked()), SLOT(accept()) );

  cancel = new QPushButton(this,klocale->translate("Abbruch") );
  cancel->setGeometry(150,155,125,30);
  cancel->setText(klocale->translate("Abbruch") );
  connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
}  

LoadLevel::~LoadLevel()
{
 delete ok;
 delete cancel;
 delete mainFrame;
 delete leftFr;
 delete rightBG;
 delete system;
 delete local;
 delete leftLabel;
 delete rightLabel;
 delete leftLabel;
 delete levelSlider;
 delete levelDigit;
}

QString LoadLevel::getFileName()
{
  QString num,z;
  QString f;
 
  if (levelDigit->intValue() < 100)
    {
      if (levelDigit->intValue() < 10)
	{
	  z = QString("00");
	} else {
	  z = QString("0");
	}
    } else {
      z = QString("");
    }
  if (system->isChecked())
    f = QString(KApplication::kde_datadir()+"/kgoldrunner/levels/level"+z+num.setNum(levelDigit->intValue())+".grl");
  else
    f = QString(KApplication::localkdedir()+"/share/apps/kgoldrunner/levels/level"+z+num.setNum(levelDigit->intValue())+".grl") ;
  return f;
}

QString LoadLevel::getLCD()
{
  QString num;
  return num.setNum(levelDigit->intValue());
}

SaveLevel::SaveLevel( QWidget *parent, const char *name )
  : QDialog( parent, name, TRUE )
{
  setFixedSize(290,200);
  
  mainFrame = new QFrame( this, "mainFrame" );
  mainFrame->setGeometry( 5, 5, 280, 190 );
  mainFrame->setFrameStyle(QFrame::Box | QFrame::Raised);
  
  frame = new QFrame(mainFrame,"leftFrame");
  frame->setGeometry( 5, 5, 270, 130 );
  frame->setFrameStyle(QFrame::Box | QFrame::Raised);

  label = new QLabel(frame,"llabel");
  label->setGeometry( 5, 5,260, 55 );
  label->setFrameStyle(QFrame::NoFrame);
  label->setText(klocale->translate("Bitte geben sie die Levelnummer ein, unter der sie den Level sichern mchten!") );
  label->setAlignment(AlignLeft|AlignVCenter|WordBreak);

  levelDigit = new QLCDNumber( frame, "LCDNumber" );
  levelDigit->setGeometry( 30, 60,180, 30 );
  levelDigit->setFrameStyle(QFrame::Box | QFrame::Raised);
  levelDigit->setSmallDecimalPoint( FALSE );
  levelDigit->setNumDigits(4);
  levelDigit->setMode( QLCDNumber::DEC );
  levelDigit->setSegmentStyle( QLCDNumber::Outline );
  levelDigit->display(1);

  levelSlider = new QSlider( frame, "Lslider" );
  levelSlider->setGeometry( 15, 105, 240, 15 );
  levelSlider->setOrientation( QSlider::Horizontal );
  levelSlider->setRange( 1, 150 );
  levelSlider->setSteps( 1, 1 );
  levelSlider->setValue( 1 );
  levelSlider->setTracking( TRUE );
  levelSlider->setTickmarks(QSlider::Right);
  levelSlider->setTickInterval(10);
  connect(levelSlider,SIGNAL(valueChanged(int)),levelDigit,SLOT(display(int)));
   
  ok = new QPushButton(this,klocale->translate("Ok") );
  ok->setGeometry(15,155,125,30);
  ok->setText(klocale->translate( "Ok") );
  connect( ok, SIGNAL(clicked()), SLOT(accept()) );

  cancel = new QPushButton(this,klocale->translate("Abbruch"));
  cancel->setGeometry(150,155,125,30);
  cancel->setText(klocale->translate("Abbruch"));
  connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
}  

SaveLevel::~SaveLevel()
{
 delete ok;
 delete cancel;
 delete mainFrame;
 delete frame;
 delete label;
 delete levelSlider;
 delete levelDigit;
}

QString SaveLevel::getFileName()
{
  QString num,z;
   
  if (levelDigit->intValue() < 100)
    {
      if (levelDigit->intValue() < 10)
	{
	  z = QString("00");
	} else {
	  z = QString("0");
	}
    } else {
      z = QString("");
    }
  return QString(KApplication::localkdedir()+"/share/apps/kgoldrunner/levels/level"+z+num.setNum(levelDigit->intValue())+".grl") ;
}

QString SaveLevel::getLCD()
{
  QString num;
  return num.setNum(levelDigit->intValue());
}
