/* go_view.h
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#ifndef GO_VIEW_H
#define GO_VIEW_H

#define STYLE_OLD 1
#define STYLE_KDE 2
#define STYLE_3D 3

#include "go_board.h"
#include "board_view.h"
#include "includes.h"
#include "KMoveList.h"

class KGoBoardView ;

/**
 * This class is the basic view of Kgo. It shows a Go board and
 * has one label for showing extra information.
 *
 * @short This class shows a go board and implements some functions. 
 */
class KGoView : public QWidget
{
	Q_OBJECT

public:
	KGoView( KGoBoard *b, QWidget *parent=0, const char *name=0 );
	
	~KGoView() ;

public slots:
	void lastMove( int x, int y, int color ) ;
	void setBoard( KGoBoard* ) ;

	void setStyle( int ) ;

	/**
	 * This function enables the legenda
	 */
	void legenda( bool ) ;
	/**
	 * @return true if the legenda is displayed 
	 */ 

	bool legenda() ;
	void boardStateChange(int) ;
	void receiveMove( int x, int y, int p) ;

	void redraw() ;

signals:
	void positionClicked( int, int, int button ) ;
	void positionLeftClicked( int, int ) ;

protected slots:
	void position_clicked(int,int,int) ;
	void resizeEvent( QResizeEvent * ) ;
	void resizeEvent( QRect ) ;
	void info( const char * ) ;

protected:
	KGoBoard *board ;
	KGoBoardView *bview ;

	QLabel *info_label ;
	QLabel *list_title ;
	int style ;
} ;

#endif
