#include <qpainter.h>
#include <qbitmap.h>
#include <strstream.h>
#include <stdlib.h>	  
#include <kmsgbox.h>

#include "board.h"


Square::Square(KChessWidget *_parent, int i, int j, piece p1)
	: KDNDWidget(_parent)
{
	// Nothing to do

	darkSquare = ((i+j) % 2) ? true : false;
	r = i;
	c = j;
	p = p1;
	parent = _parent;

	light.setRgb(0xc8, 0xc3, 0x65);
	dark.setRgb(0x77, 0xa2, 0x6d);
	lightPiece.setNamedColor("white");
	darkPiece.setRgb(0x20, 0x20, 0x20);

	// create a DropZone over the entire window and connect it
	// to the slotDropEvent
	connect(new KDNDDropZone(this, DndRawData), 
			SIGNAL(dropAction(KDNDDropZone *)), 
			SLOT(slotDropEvent(KDNDDropZone *)));

	pressed = 0;

	s.sprintf("%c%d", 'a' + c, 8 - r);
}

void 
Square::slotDropEvent(KDNDDropZone *zone)
{
	// the user dropped something on our window.
	DragPiece *d;

	d = (DragPiece *) zone->getData();

	// cout << "drop: " << d << " " << d->getPiece() << endl;

	if (!d) {
		// complain
		KMsgBox::message(NULL, "Unknown object", 
						 "Dropped object was empty");
		return;
	}

	// Do stuff
	//cout << "debug: drop contains " << d->getPiece() << endl;
#if 0
	Board *b = parent->getBoard();

	p = d->getPiece();
	b->set(r, c, p);
#endif

	if (d->getStartSquare() != this)
		d->getStartSquare()->dragAccepted();

	QString move(d->getStartSquare()->name());
	move += name();

	// XXX: Take care of promotions

	// Make the move
	parent->makeMove(move);

	// Engine requires a newline
	move += '\n';
	parent->tellEngine(move);

	// Plug memory leaks!
	delete d;

	update();
}

void 
Square::dndMouseMoveEvent(QMouseEvent *_mouse) 
{
	// 'pressed' is set in mousePressedEvent(...)
	if ( !pressed )
		return;

	int x = _mouse->pos().x();
	int y = _mouse->pos().y();

	if ((abs( x - press_x ) > Dnd_X_Precision)
		|| (abs( y - press_y ) > Dnd_Y_Precision)) {

		QPoint p1 = mapToGlobal( _mouse->pos() );

		QString& str = getBitmapName();
		QBitmap bitmap(str);
		bitmap.setMask(QBitmap(str));
		delete &str;

		QPainter paint;

		int dx = - bitmap.width() / 2;
		int dy = - bitmap.height() / 2;

		DragPiece *d = new DragPiece(p, this);

		startDrag( new KChessDNDIcon( bitmap, p1.x() + dx, p1.y() + dy, 
									  iswhite(p) ? lightPiece : darkPiece), 
				   (char *) d, sizeof(DragPiece), DndRawData, dx, dy);

		oldPiece = p;
		p = EmptySquare;
		accepted = false;

		update();

		//cout << "drag start: " << d << " " << d->getPiece() << endl;
	}
}

void 
Square::mousePressEvent(QMouseEvent *_mouse) 
{
	press_x = _mouse->pos().x();
	press_y = _mouse->pos().y();

	pressed = true;
}

void 
Square::mouseReleaseEvent(QMouseEvent *_mouse)
{
	pressed = false;
	KDNDWidget::mouseReleaseEvent(_mouse);
}

void 
Square::rootDropEvent()
{
	// In edit mode, this should throw the piece out
	p = oldPiece;
	update();
	//cout << "Root drop" << endl;
} 

void
Square::dragAccepted()
{
	p = EmptySquare;
	update();
	accepted = true;
}

void 
Square::dragEndEvent()
{
	// Cleanup

	if (!accepted) {
		p = oldPiece;
		update();
	}

#if 0
	parent->getBoard()->set(r, c, p);
#endif		

	cout << "Drag ended" << endl;
} 

QString & 
Square::getBitmapName()
{
	strstream s;
	QString *str;

	s << "bitmaps/";

	switch (p) {
	case WhiteKing:
	case BlackKing:
		s << "k";
		break;
	case WhiteQueen:
	case BlackQueen:
		s << "q";
		break;
	case WhiteRook:
	case BlackRook:
		s << "r";
		break;
	case WhiteBishop:
	case BlackBishop:
		s << "b";
		break;
	case WhiteKnight:
	case BlackKnight:
		s << "n";
		break;
	case WhitePawn:
	case BlackPawn:
		s << "p";
		break;
	default:
		break;
	};

	s << "80s";
	s << ".bm";

	str = new QString(s.str());

	return *str;
}

void 
Square::paintEvent(QPaintEvent *e)
{
	QPainter paint;
	QString& str = getBitmapName();

	QBitmap b(str);
	delete &str;

	paint.begin(this);

	if (darkSquare)
		paint.setBackgroundColor(dark);
	else
		paint.setBackgroundColor(light);

	if (iswhite(p)) // is light piece
		paint.setPen(lightPiece);
	else
		paint.setPen(darkPiece);

	paint.setBackgroundMode(OpaqueMode);

	if (p != EmptySquare)
		paint.drawPixmap(0, 0, b);
	else
		paint.fillRect(0, 0, 80, 80, darkSquare ? dark : light);

	paint.end();
}

void 
KChessDNDIcon::paintEvent(QPaintEvent *_event)
{
	QPainter paint;

	paint.begin(this);

	paint.setPen(color);

	paint.drawPixmap(0, 0, pixmap);

	paint.end();
}

Board::Board() 
{
	reset();
}

Board::~Board()
{
}

void
Board::clear()
{
	for (int i = 0; i < 8; i++)
		for (int j = 0; j < 8; j++)
			_board[i][j] = EmptySquare;

}

const piece initPos[8][8] = {
	{ BlackRook, BlackKnight, BlackBishop, BlackQueen,
	  BlackKing, BlackBishop, BlackKnight, BlackRook },
	{ BlackPawn, BlackPawn, BlackPawn, BlackPawn,
	  BlackPawn, BlackPawn, BlackPawn, BlackPawn },
	{ EmptySquare, EmptySquare, EmptySquare, EmptySquare,
	  EmptySquare, EmptySquare, EmptySquare, EmptySquare },
	{ EmptySquare, EmptySquare, EmptySquare, EmptySquare,
	  EmptySquare, EmptySquare, EmptySquare, EmptySquare },
	{ EmptySquare, EmptySquare, EmptySquare, EmptySquare,
	  EmptySquare, EmptySquare, EmptySquare, EmptySquare },
	{ EmptySquare, EmptySquare, EmptySquare, EmptySquare,
	  EmptySquare, EmptySquare, EmptySquare, EmptySquare },
	{ WhitePawn, WhitePawn, WhitePawn, WhitePawn,
	  WhitePawn, WhitePawn, WhitePawn, WhitePawn },
	{ WhiteRook, WhiteKnight, WhiteBishop, WhiteQueen,
	  WhiteKing, WhiteBishop, WhiteKnight, WhiteRook }
};

void
Board::reset()
{
	for (int i = 0; i < 8; i++)
		for (int j = 0; j < 8; j++)
			_board[i][j] = initPos[i][j];

}

void
Board::set(int x, int y, piece p)
{
	_board[x][y] = p;

}

piece
Board::get(int x, int y)
{
	return _board[x][y];

}

