/*
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/



/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "kpathselector.h"

#if 0
#include "DebugInfo.h"
#endif


/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/




KPathSelector::KPathSelector( QWidget *parent, const char* name, QString path )
              :KContainerLayout( parent, name )
{
  // Create the child Widgets
  lined = new KLined( this );
  button = new QButton( this, "myname" );
  dirdialog = 0L;

  button->setText("..."); // picture it 
  connect( button, SIGNAL( pressed() ), SLOT( buttonPressed() ) );

  if ( path != 0 )
  { 
    lined->setText( (const char *)path );
    selectedPath = path;
  }
 
  this->packEnd( button );
  this->packEnd( lined , true, true );
//  this->sizeToFit();
}

KPathSelector::~KPathSelector()
{
  if ( lined != 0L )
    delete lined;

  if ( button != 0L )
    delete button;

}

void KPathSelector::setPath( QString path )
{
  selectedPath=path;
  lined->setText( selectedPath );
}

void  KPathSelector::buttonPressed()
{
  QString tmpStr;

  if ( dirdialog == 0L )
  {
    dirdialog = new  KDirDialog( (const char *)selectedPath, this, 0L );
  }  
  
 
  tmpStr=dirdialog->getDirectory((const char *)selectedPath );
  if ( tmpStr.length() != 0 )
  {
    selectedPath=tmpStr;
    lined->setText( selectedPath );
  }
}



