/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   
/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <kapp.h>
#include <kconfig.h> 
#include <klocale.h>
#include <kmsgbox.h> 
#include <kstdaccel.h> 

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "kalaxTopLevel.h"
#include "optionsDialog.h"
#include "levelGenDialog.h"
#include "DebugInfo.h"

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

   
/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- GLOBAL VARIABLES
-----------------------------------------------------------------------------*/
//
//      Name:  kalaxTopLevel
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
kalaxTopLevel::kalaxTopLevel(const char *name)
                   :KTMainWindow( name )
{
  dprintf( "START::(>%s<)\n", name );
  
  KStdAccel kaccel( kapp->getConfig() );
  
                                
  /* MainView
  -----------*/
  kalaxG=new kalaxGame( this, "Kalax-Game" );
  kalaxG->setMinimumSize( FIELD_WIDTH, FIELD_HEIGHT );
  setView( kalaxG );
  
  /* MenuBar
  ----------*/
  mBar = menuBar();

  filePm = new QPopupMenu();
  filePm->insertItem( klocale->translate("&New"),  kalaxG, SLOT( newGame() ), kaccel.openNew() );
  filePm->insertItem( klocale->translate("&Pause"),  kalaxG, SLOT( pauseGame() ), Key_P );
  filePm->insertItem( klocale->translate("&End"),  kalaxG, SLOT( endGame() ), Key_E );
  filePm->insertSeparator( ); 
  filePm->insertItem( klocale->translate("&Quit"),  this, SLOT( quit() ), kaccel.quit() );
  mBar->insertItem( klocale->translate("&File"), filePm );
  
  optionPm = new QPopupMenu();
  optionPm->setCheckable( TRUE ); 
//  useKeyboardId = optionPm->insertItem( klocale->translate("Use &Keyboard"), this, SLOT( switchKeyboardMouse() ) );
  useMouseId = optionPm->insertItem( klocale->translate("Use &Mouse"), this, SLOT( switchKeyboardMouse() ) );  
  optionPm->insertSeparator( );
  optionPm->insertItem( klocale->translate("&Speed"), this, SLOT( options() ) );  
  
  mBar->insertItem( klocale->translate("&Options"), optionPm );
  
  
  mBar->insertSeparator();

  helpPm = new QPopupMenu();
  helpPm->insertItem( klocale->translate("Contents ..."), this, SLOT(helpContents()), kaccel.help() );
 // helpPm->insertItem( locale->translate("Index ... "), this, SLOT(helpIndex()));
  helpPm->insertSeparator( );
  helpPm->insertItem( klocale->translate("About ..."), this, SLOT(helpAbout()));
  mBar->insertItem( klocale->translate("&Help"), helpPm );
  
  optionPm->setItemChecked( useMouseId, TRUE );  
  kalaxG->mouseGame();
  
  // Set the Window Size  
  resize( FIELD_WIDTH, FIELD_HEIGHT + mBar->height() + 2 );

  dprintf( "END::()\n");
}


//
//      Name:  kalaxTopLevel
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
kalaxTopLevel::~kalaxTopLevel()
{
  dprintf( "START::()\n");


  dprintf( "END::()\n");
}



//
//      Name:  kalaxTopLevel
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxTopLevel::quit()
{
  dprintf( "kalaxTopLevel::quit()\n" );
  kapp->quit();
  dprintf( "kalaxTopLevel::quit(...)=>void<\n" );
}

//
//      Name:  kalaxTopLevel::switchKeyboardMouse
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxTopLevel::switchKeyboardMouse()
{
  dprintf( "START::()\n");
  optionPm->setItemChecked( useKeyboardId, !optionPm->isItemChecked(useKeyboardId) );
  optionPm->setItemChecked( useMouseId, !optionPm->isItemChecked(useMouseId) );
  if ( optionPm->isItemChecked( useKeyboardId ) == true )
  {
     kalaxG->keyboardGame();
  }
  else
  {  
     kalaxG->mouseGame();
  }
  dprintf( "END::()\n");
}

//
//      Name:  kalaxTopLevel::speedOption
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxTopLevel::options()
{
  
  dprintf( "START::()\n");
  
printf("set game values after options dialog\n");
  if ( kalaxG->kalaxOptions->exec() == 1 )
  {
    kalaxG->kalaxOptions->writeConfig();
  }

//  levelGenDialog lgenDia( kalaxG->kalaxOptions->spritesPath );
//  lgenDia.show();
  
  dprintf( "END::()\n");
}

   
//
//      Name:  kalaxTopLevel
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxTopLevel::helpContents()
{
  dprintf( "START::helpContents()\n" );
  QString filename(APPNAME "/" APPNAME ".html" );

  kapp->invokeHTMLHelp( filename,"");

  dprintf( "END::helpContents()=>void<\n");
}


//
//      Name:  kalaxTopLevel
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxTopLevel::helpIndex()
{
  dprintf( "START::helpIndex()\n" );
  QString filename(APPNAME "/" APPNAME ".html" );
  QString topic;
 
  kapp->invokeHTMLHelp( filename,"");
  dprintf( "END::helpIndex()=>void<\n");
}


//
//      Name:  kalaxTopLevel
//
//   Comment:
//
// Parameter:
//
//  RetParam:
//
//  RetValue:
//
//    Extern:
//
void kalaxTopLevel::helpAbout()
{
  char aboutMsg[256];
  dprintf( "START::helpAbout()\n" );

  sprintf( aboutMsg, "%s %s\n" \
                     "%s\n" \
                     "by Matthias Hipp\n" \
                     "matthias.hipp@gmx.de\n" \
                     "http://home.braunschweig.netsurf.de/~matthias.hipp",
                     APPNAME, APPVERS, klocale->translate(APPCAPT) );
  KMsgBox aboutDialog( this, klocale->translate("About"), 
                       aboutMsg, KMsgBox::INFORMATION, "OK" );

  aboutDialog.show();
  
  dprintf( "END::helpAbout()=>void<\n");
}
 










