/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   
#ifndef KALAXGAME_H
#define KALAXGAME_H

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <qwidget.h>
#include <qframe.h>
#include <qlist.h>
#include <qstrlist.h> 
#include <qevent.h> 
#include <QwSpriteField.h>
#include <mediatool.h>  

#include <kconfig.h>
#include <klocale.h>
#include <kaudio.h>

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "playerShip.h"
#include "playerShot.h"
#include "enemyShot.h"
#include "enemy.h"
#include "level.h"
#include "statLine.h"
#include "optionsDialog.h"

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/
    
enum EmitGameValues { ALL, SHIPS, SCORE, STATE };

class kalaxGame: public QWidget      //public QObject
{
  Q_OBJECT;

  public slots:
    void newGame();
    void pauseGame();
    void endGame();
    void mouseGame();
    void keyboardGame();
  
  signals:
    void putScore( char *score );
    void putShips( char *ships );
    void putState( char *state ); 


  private:
    int gameState;
    long gameScore;
    int levelNr;
    bool keybGame;
    int updateTimerId;

                          
    statLine *statusDisplaySprite;
    
    QStrList levelFileNames;
    Level *level;
    flightPlan *defaultPlan;
    
    playerShip *player;

    QList<playerShot> playerShotsList;
    QList<enemyShot> enemyShotsList;
    QList<Enemy> enemyList;
    QList<QwMobileSprite> enemyDestrList;
    QList<playerShip> playerShipsList;       // List to hold all playerships
    QList<EnemyType> enemyTypesList;         // List to hold all enemyTypes
    QList<flightPlan> flightPlanList;
    QwImageSpriteField *backGroundField;     // BackgroundField
    QwSpriteFieldView *backGroundFieldView;  // View for Spritefield
    QwSpritePixmapSequence *destroySequence; // Ani for destroyed enemys and playerships   
    QwMobileSprite *playerDestr;

    KAudio *playSound;   
    QString soundEshoot, soundRshoot, soundEdestroy, soundRdestroy;

    KLocale *locale;
    
    void startPlayerShot();
    void startEnemyShot( Enemy *enemy );
    void emitGameValues( EmitGameValues egv=ALL );
    void startLevel( unsigned int levelNumber );
    bool collision(QwMobileSprite *sp1, QwMobileSprite *sp2);
    void playerHit( playerShip *playerSp );
    void enemyHit( QwMobileSprite *enemySp ); 
    void doSound( int soundIdx );
  
  protected:
    void timerEvent( QTimerEvent * );
    void keyPressEvent( QKeyEvent *event );  // Reimpl. from QWidget
    void keyReleaseEvent( QKeyEvent *event );
    void mouseMoveEvent ( QMouseEvent *event );
    virtual void mousePressEvent ( QMouseEvent *event );
    void resizeEvent ( QResizeEvent *event );
    
  public:
    kalaxGame( QWidget * parent=0, const char * name=0 );

    ~kalaxGame();
           
    KalaxConfigDialog *kalaxOptions;
   
};

#endif  // KALAXGAME_H












