/***************************************************************************
                          cforeignfontoptions.cpp  -  description
                             -------------------
    begin                : Wed Sep 29 1999
    copyright            : (C) 1999 by The team of BibleTime
    email                : BibleTime@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "cforeignfontoptions.h"

CForeignFontOptions::CForeignFontOptions(QWidget *parent, const char *name,  QList<TBibleFont>* fontList) : QWidget(parent,name)
{
	initDialog();
		
	currentItem =0;
	this->fontList=fontList;
  config=kapp->getConfig();
	this->setupFontList();		
	this->readSettings();
	
	fontListView->addColumn(i18n("Module"), fontListView->width()/2);
	fontListView->addColumn(i18n("Font"),		fontListView->width()/2);
	fontListView->header()->hide();
  fontListView->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  fontListView->setLineWidth( 2 );
	
	connect(fontCombo, SIGNAL(activated(const char*)),
					this, SLOT(slotFontChanged(const char*)));
	connect(fontListView, SIGNAL(selectionChanged(QListViewItem*)),
					this, SLOT(slotSelectionChanged(QListViewItem*)));
}

CForeignFontOptions::~CForeignFontOptions()
{
}

void CForeignFontOptions::saveSettings()
{
	config->setGroup("Foreign Fonts");
	
	QListViewItem *currentItem = fontListView->firstChild();
	
	for (int n=0; n < fontListView->childCount(); n++)
	{
		if (currentItem!=0)
			config->writeEntry( currentItem->text(0), currentItem->text(1) );
	
		currentItem = currentItem->nextSibling();
	};
	
	config->sync();
}

void CForeignFontOptions::readSettings()
{
}

void CForeignFontOptions::slotSelectionChanged( QListViewItem* item)
{
	currentItem = item;	
	
	bool found=false;
	for (int n=0; n < fontCombo->count(); n++)
	{
		if ( (QString) item->text(1) == (QString) fontCombo->text(n) )
		{
			fontCombo->setCurrentItem(n);
			found=true;			
			break;
		};
	};
	
	//the font was not found
	if (!found)
		fontCombo->setCurrentItem(0);	
}

void CForeignFontOptions::slotFontChanged(const char* text)
{
	if (currentItem ==0 )
		return;
	
	currentItem->setText(1, text);
		
/*	config->setGroup("Foreign Fonts");
	debug(currentItem->text(0));
	debug(currentItem->text(1));
	
	config->writeEntry( currentItem->text(0), currentItem->text(1) );	
	config->sync();*/
}

/** The resize Event implementation. */
void CForeignFontOptions::resizeEvent(QResizeEvent *event)
{
	fontListView->resize(this->width(), this->height()-40);
	
	QLabel_2->setGeometry(0,fontListView->height()+5,this->width()/2, 30);
	fontCombo->setGeometry(this->width()/2,fontListView->height()+5,this->width()/2, 30);
	
	fontListView->setColumnWidth(0, fontListView->width()/2 -5);
	fontListView->setColumnWidth(1, fontListView->width()/2 -10);	
}

/** Sets up the fonts we can use. */
void CForeignFontOptions::setupFontList()
{
	KDEFonts=new QStrList;
	kapp->getKDEFonts(KDEFonts);
	fontCombo->insertStrList(KDEFonts);

	QString fontname="";
	QListViewItem *item;	
	config->setGroup("Foreign Fonts");
	for (uint n=0; n < fontList->count();n++)
	{
		item=new QListViewItem(fontListView);
		item->setText(0, fontList->at(n)->module);
		
		fontname= config->readEntry(fontList->at(n)->module,"");
		if (fontname != "")
			item->setText(1, fontname);
		else
			item->setText(1, fontList->at(n)->fontname);		
	};
}






