/****************************************************************************************
 * Copyright (c) 2013 Matěj Laitl <matej@laitl.cz>                                      *
 *                                                                                      *
 * This program is free software; you can redistribute it and/or modify it under        *
 * the terms of the GNU General Public License as published by the Free Software        *
 * Foundation; either version 2 of the License, or (at your option) any later           *
 * version.                                                                             *
 *                                                                                      *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY      *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A      *
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.             *
 *                                                                                      *
 * You should have received a copy of the GNU General Public License along with         *
 * this program.  If not, see <http://www.gnu.org/licenses/>.                           *
 ****************************************************************************************/

#ifndef SEMAPHORERELEASER_H
#define SEMAPHORERELEASER_H

#include "core/amarokcore_export.h"

class QSemaphore;

/**
 * Helper RAII class that releases passed QSemaphore upon deletion. Similar to
 * QMutexLocker.
 */
class AMAROK_CORE_EXPORT SemaphoreReleaser
{
    public:
        SemaphoreReleaser( QSemaphore *semaphore );
        ~SemaphoreReleaser();

        /**
         * Tell SemaphoreReleaser not to release the semaphore upon deletion.
         */
        void dontRelease();

    private:
        Q_DISABLE_COPY( SemaphoreReleaser )

        QSemaphore *m_semaphore;
};


#endif // SEMAPHORERELEASER_H
