/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;

class CacheStats {
    private final UsedBytesCount usedBytesCount = new UsedBytesCount();
    private final long maxBytes;

    CacheStats(long maxBytes) {
        this.maxBytes = maxBytes;
    }

    public long getCacheUsed() {
        return this.usedBytesCount.get();
    }

    public long getCacheCapacity() {
        return this.maxBytes;
    }

    long reserve(long count) {
        return this.usedBytesCount.reserve(count);
    }

    long release(long count) {
        return this.usedBytesCount.release(count);
    }

    long releaseRoundDown(long count) {
        return this.usedBytesCount.releaseRoundDown(count);
    }

    long getPageSize() {
        return this.usedBytesCount.rounder.osPageSize;
    }

    long roundUpPageSize(long count) {
        return this.usedBytesCount.rounder.roundUp(count);
    }

    private class UsedBytesCount {
        private final AtomicLong usedBytes = new AtomicLong(0L);
        private PageRounder rounder = new PageRounder();

        private UsedBytesCount() {
        }

        long reserve(long count) {
            long next;
            long cur;
            count = this.rounder.roundUp(count);
            do {
                if ((next = (cur = this.usedBytes.get()) + count) <= CacheStats.this.getCacheCapacity()) continue;
                return -1L;
            } while (!this.usedBytes.compareAndSet(cur, next));
            return next;
        }

        long release(long count) {
            count = this.rounder.roundUp(count);
            return this.usedBytes.addAndGet(-count);
        }

        long releaseRoundDown(long count) {
            count = this.rounder.roundDown(count);
            return this.usedBytes.addAndGet(-count);
        }

        long get() {
            return this.usedBytes.get();
        }
    }

    @VisibleForTesting
    static class PageRounder {
        private final long osPageSize = NativeIO.POSIX.getCacheManipulator().getOperatingSystemPageSize();

        PageRounder() {
        }

        public long roundUp(long count) {
            return count + this.osPageSize - 1L & (this.osPageSize - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        }

        public long roundDown(long count) {
            return count & (this.osPageSize - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

