/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.compress;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;

public class ArrayCompressionStatistics {
    public final long originalSize;
    public final long compressedSizeEstimate;
    public final boolean shouldCompress;
    public final Types.ValueType valueType;
    public final boolean containsNull;
    public final boolean sampledAllRows;
    public final ArrayFactory.FrameArrayType bestType;
    public final int bytePerValue;
    public final int nUnique;

    public ArrayCompressionStatistics(int bytePerValue, int nUnique, boolean shouldCompress, Types.ValueType valueType, boolean containsNull, ArrayFactory.FrameArrayType bestType, long originalSize, long compressedSizeEstimate, boolean sampledAllRows) {
        this.bytePerValue = bytePerValue;
        this.nUnique = nUnique;
        this.shouldCompress = shouldCompress;
        this.valueType = valueType;
        this.containsNull = containsNull;
        this.bestType = bestType;
        this.originalSize = originalSize;
        this.compressedSizeEstimate = compressedSizeEstimate;
        this.sampledAllRows = sampledAllRows;
        if (valueType == null) {
            throw new RuntimeException("Invalid null valuetype in statistics");
        }
    }

    public String toString() {
        if (!this.sampledAllRows) {
            return String.format("Compressed Stats: size:%8d->%8d, Use:%10s, EstUnique:%6d, ValueType:%7s, ContainsNull:%5s", new Object[]{this.originalSize, this.compressedSizeEstimate, this.bestType(), this.nUnique, this.valueType, this.containsNull});
        }
        return String.format("Compressed Stats: size:%8d->%8d, Use:%10s, Unique:%6d, ValueType:%7s, ContainsNull:%5s", new Object[]{this.originalSize, this.compressedSizeEstimate, this.bestType(), this.nUnique, this.valueType, this.containsNull});
    }

    private String bestType() {
        return this.bestType == null ? "None" : this.bestType.toString();
    }
}

