/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor.opt;

import org.apache.sysds.hops.Hop;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptNode;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptTreePlanMapping;

public class OptTree {
    private final OptTreePlanMapping _hlMap;
    private int _ck;
    private double _cm;
    private OptNode _root = null;

    public OptTree(int ck, double cm, OptNode node) {
        this(ck, cm, node, null);
    }

    public OptTree(int ck, double cm, OptNode node, OptTreePlanMapping hlMap) {
        this._ck = ck;
        this._cm = cm;
        this._root = node;
        this._hlMap = hlMap;
    }

    public OptTreePlanMapping getPlanMapping() {
        return this._hlMap;
    }

    public Hop getMappedHop(long id) {
        return this._hlMap.getMappedHop(id);
    }

    public Object[] getMappedProg(long id) {
        return this._hlMap.getMappedProg(id);
    }

    public ProgramBlock getMappedProgramBlock(long id) {
        return this._hlMap.getMappedProgramBlock(id);
    }

    public int getCK() {
        return this._ck;
    }

    public double getCM() {
        return this._cm;
    }

    public OptNode getRoot() {
        return this._root;
    }

    public void setRoot(OptNode n) {
        this._root = n;
    }

    public String explain(boolean withDetails) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("----------------------------\n");
        sb.append(" EXPLAIN OPT TREE (type=HOPS, size=");
        sb.append(this._root.size());
        sb.append(")\n");
        sb.append("----------------------------\n");
        sb.append(this._root.explain(1, withDetails));
        sb.append("----------------------------\n");
        return sb.toString();
    }
}

