/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.IMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToInt;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class AMapToData
implements Serializable {
    private static final long serialVersionUID = 1208906071822976041L;
    protected static final Log LOG = LogFactory.getLog((String)AMapToData.class.getName());
    private int nUnique;

    protected AMapToData(int nUnique) {
        this.nUnique = nUnique;
    }

    public final int getUnique() {
        return this.nUnique;
    }

    public final void setUnique(int nUnique) {
        this.nUnique = nUnique;
    }

    public abstract int getIndex(int var1);

    public void set(int n, Integer v) {
        this.set(n, (int)v);
    }

    public abstract void set(int var1, int var2);

    public abstract void set(int var1, int var2, int var3, AMapToData var4);

    public abstract int setAndGet(int var1, int var2);

    public abstract void fill(int var1);

    public abstract int getUpperBoundValue();

    public abstract long getInMemorySize();

    public abstract long getExactSizeOnDisk();

    public abstract int size();

    public abstract void write(DataOutput var1) throws IOException;

    public abstract void replace(int var1, int var2);

    public abstract MapToFactory.MAP_TYPE getType();

    public final void preAggregateDense(MatrixBlock m, double[] preAV, int rl, int ru, int cl, int cu) {
        DenseBlock db = m.getDenseBlock();
        if (rl == ru - 1) {
            this.preAggregateDenseSingleRow(db.values(rl), db.pos(rl), preAV, cl, cu);
        } else {
            this.preAggregateDenseMultiRow(m, preAV, rl, ru, cl, cu);
        }
    }

    protected void preAggregateDenseSingleRow(double[] mV, int off, double[] preAV, int cl, int cu) {
        if (cu - cl > 64) {
            this.preAggregateDenseToRowBy8(mV, preAV, cl, cu, off);
        } else {
            off += cl;
            int rc = cl;
            while (rc < cu) {
                int n = this.getIndex(rc);
                preAV[n] = preAV[n] + mV[off];
                ++rc;
                ++off;
            }
        }
    }

    protected void preAggregateDenseToRowBy8(double[] mV, double[] preAV, int cl, int cu, int off) {
        int h = (cu - cl) % 8;
        off += cl;
        int rc = cl;
        while (rc < cl + h) {
            int n = this.getIndex(rc);
            preAV[n] = preAV[n] + mV[off];
            ++rc;
            ++off;
        }
        rc = cl + h;
        while (rc < cu) {
            this.preAggregateDenseToRowVec8(mV, preAV, rc, off);
            rc += 8;
            off += 8;
        }
    }

    protected void preAggregateDenseToRowVec8(double[] mV, double[] preAV, int rc, int off) {
        int n = this.getIndex(rc);
        preAV[n] = preAV[n] + mV[off];
        int n2 = this.getIndex(rc + 1);
        preAV[n2] = preAV[n2] + mV[off + 1];
        int n3 = this.getIndex(rc + 2);
        preAV[n3] = preAV[n3] + mV[off + 2];
        int n4 = this.getIndex(rc + 3);
        preAV[n4] = preAV[n4] + mV[off + 3];
        int n5 = this.getIndex(rc + 4);
        preAV[n5] = preAV[n5] + mV[off + 4];
        int n6 = this.getIndex(rc + 5);
        preAV[n6] = preAV[n6] + mV[off + 5];
        int n7 = this.getIndex(rc + 6);
        preAV[n7] = preAV[n7] + mV[off + 6];
        int n8 = this.getIndex(rc + 7);
        preAV[n8] = preAV[n8] + mV[off + 7];
    }

    protected void preAggregateDenseMultiRow(MatrixBlock m, double[] preAV, int rl, int ru, int cl, int cu) {
        int nVal = this.getUnique();
        DenseBlock db = m.getDenseBlock();
        if (!db.isContiguous()) {
            throw new NotImplementedException();
        }
        double[] mV = m.getDenseBlockValues();
        int nCol = m.getNumColumns();
        this.preAggregateDenseMultiRowContiguous(mV, nCol, nVal, preAV, rl, ru, cl, cu);
    }

    protected void preAggregateDenseMultiRowContiguous(double[] mV, int nCol, int nVal, double[] preAV, int rl, int ru, int cl, int cu) {
        if (cu - cl > 64) {
            this.preAggregateDenseMultiRowContiguousBy8(mV, nCol, nVal, preAV, rl, ru, cl, cu);
        } else {
            this.preAggregateDenseMultiRowContiguousBy1(mV, nCol, nVal, preAV, rl, ru, cl, cu);
        }
    }

    protected void preAggregateDenseMultiRowContiguousBy8(double[] mV, int nCol, int nVal, double[] preAV, int rl, int ru, int cl, int cu) {
        int h = (cu - cl) % 8;
        this.preAggregateDenseMultiRowContiguousBy1(mV, nCol, nVal, preAV, rl, ru, cl, cl + h);
        int offR = nCol * rl;
        int offE = nCol * ru;
        for (int c = cl + h; c < cu; c += 8) {
            int id1 = this.getIndex(c);
            int id2 = this.getIndex(c + 1);
            int id3 = this.getIndex(c + 2);
            int id4 = this.getIndex(c + 3);
            int id5 = this.getIndex(c + 4);
            int id6 = this.getIndex(c + 5);
            int id7 = this.getIndex(c + 6);
            int id8 = this.getIndex(c + 7);
            int start = c + offR;
            int end = c + offE;
            int nValOff = 0;
            for (int off = start; off < end; off += nCol) {
                int n = id1 + nValOff;
                preAV[n] = preAV[n] + mV[off];
                int n2 = id2 + nValOff;
                preAV[n2] = preAV[n2] + mV[off + 1];
                int n3 = id3 + nValOff;
                preAV[n3] = preAV[n3] + mV[off + 2];
                int n4 = id4 + nValOff;
                preAV[n4] = preAV[n4] + mV[off + 3];
                int n5 = id5 + nValOff;
                preAV[n5] = preAV[n5] + mV[off + 4];
                int n6 = id6 + nValOff;
                preAV[n6] = preAV[n6] + mV[off + 5];
                int n7 = id7 + nValOff;
                preAV[n7] = preAV[n7] + mV[off + 6];
                int n8 = id8 + nValOff;
                preAV[n8] = preAV[n8] + mV[off + 7];
                nValOff += nVal;
            }
        }
    }

    protected void preAggregateDenseMultiRowContiguousBy1(double[] mV, int nCol, int nVal, double[] preAV, int rl, int ru, int cl, int cu) {
        int offR = nCol * rl;
        int offE = nCol * ru;
        for (int c = cl; c < cu; ++c) {
            int idx = this.getIndex(c);
            int start = c + offR;
            int end = c + offE;
            int offOut = idx;
            for (int off = start; off < end; off += nCol) {
                int n = offOut;
                preAV[n] = preAV[n] + mV[off];
                offOut += nVal;
            }
        }
    }

    public final void preAggregateDense(DenseBlock m, double[] preAV, int rl, int ru, int cl, int cu, AOffset indexes) {
        indexes.preAggregateDenseMap(m, preAV, rl, ru, cl, cu, this.getUnique(), this);
    }

    public final void preAggregateSparse(SparseBlock sb, double[] preAV, int rl, int ru, AOffset indexes) {
        indexes.preAggSparseMap(sb, preAV, rl, ru, this.getUnique(), this);
    }

    public final void preAggregateSparse(SparseBlock sb, double[] preAV, int rl, int ru) {
        if (rl == ru - 1) {
            this.preAggregateSparseSingleRow(sb, preAV, rl);
        } else {
            this.preAggregateSparseMultiRow(sb, preAV, rl, ru);
        }
    }

    private final void preAggregateSparseSingleRow(SparseBlock sb, double[] preAV, int r) {
        if (sb.isEmpty(r)) {
            return;
        }
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] avals = sb.values(r);
        for (int j = apos; j < alen; ++j) {
            int n = this.getIndex(aix[j]);
            preAV[n] = preAV[n] + avals[j];
        }
    }

    private final void preAggregateSparseMultiRow(SparseBlock sb, double[] preAV, int rl, int ru) {
        int unique = this.getUnique();
        for (int r = rl; r < ru; ++r) {
            if (sb.isEmpty(r)) continue;
            int apos = sb.pos(r);
            int alen = sb.size(r) + apos;
            int[] aix = sb.indexes(r);
            double[] avals = sb.values(r);
            int off = unique * (r - rl);
            for (int j = apos; j < alen; ++j) {
                int n = off + this.getIndex(aix[j]);
                preAV[n] = preAV[n] + avals[j];
            }
        }
    }

    public final int[] getCounts() {
        return this.getCounts(new int[this.getUnique()]);
    }

    public abstract int[] getCounts(int[] var1);

    public final void preAggregateDDC_DDC(AMapToData tm, IDictionary td, Dictionary ret, int nCol) {
        if (nCol == 1) {
            this.preAggregateDDC_DDCSingleCol(tm, td.getValues(), ret.getValues());
        } else {
            this.preAggregateDDC_DDCMultiCol(tm, td, ret.getValues(), nCol);
        }
    }

    protected void preAggregateDDC_DDCSingleCol(AMapToData tm, double[] td, double[] v) {
        int r;
        int sz = this.size();
        int h = sz % 8;
        for (r = 0; r < h; ++r) {
            int n = this.getIndex(r);
            v[n] = v[n] + td[tm.getIndex(r)];
        }
        for (r = h; r < sz; r += 8) {
            this.preAggregateDDC_DDCSingleCol_vec(tm, td, v, r);
        }
    }

    protected void preAggregateDDC_DDCSingleCol_vec(AMapToData tm, double[] td, double[] v, int r) {
        int r2 = r + 1;
        int r3 = r + 2;
        int r4 = r + 3;
        int r5 = r + 4;
        int r6 = r + 5;
        int r7 = r + 6;
        int r8 = r + 7;
        int n = this.getIndex(r);
        v[n] = v[n] + td[tm.getIndex(r)];
        int n2 = this.getIndex(r2);
        v[n2] = v[n2] + td[tm.getIndex(r2)];
        int n3 = this.getIndex(r3);
        v[n3] = v[n3] + td[tm.getIndex(r3)];
        int n4 = this.getIndex(r4);
        v[n4] = v[n4] + td[tm.getIndex(r4)];
        int n5 = this.getIndex(r5);
        v[n5] = v[n5] + td[tm.getIndex(r5)];
        int n6 = this.getIndex(r6);
        v[n6] = v[n6] + td[tm.getIndex(r6)];
        int n7 = this.getIndex(r7);
        v[n7] = v[n7] + td[tm.getIndex(r7)];
        int n8 = this.getIndex(r8);
        v[n8] = v[n8] + td[tm.getIndex(r8)];
    }

    protected void preAggregateDDC_DDCMultiCol(AMapToData tm, IDictionary td, double[] v, int nCol) {
        int r;
        int sz = this.size();
        int h = sz % 8;
        for (r = 0; r < h; ++r) {
            td.addToEntry(v, tm.getIndex(r), this.getIndex(r), nCol);
        }
        for (r = h; r < sz; r += 8) {
            this.preAggregateDDC_DDCMultiCol_vec(tm, td, v, nCol, r);
        }
    }

    protected void preAggregateDDC_DDCMultiCol_vec(AMapToData tm, IDictionary td, double[] v, int nCol, int r) {
        int r2 = r + 1;
        int r3 = r + 2;
        int r4 = r + 3;
        int r5 = r + 4;
        int r6 = r + 5;
        int r7 = r + 6;
        int r8 = r + 7;
        td.addToEntryVectorized(v, tm.getIndex(r), tm.getIndex(r2), tm.getIndex(r3), tm.getIndex(r4), tm.getIndex(r5), tm.getIndex(r6), tm.getIndex(r7), tm.getIndex(r8), this.getIndex(r), this.getIndex(r2), this.getIndex(r3), this.getIndex(r4), this.getIndex(r5), this.getIndex(r6), this.getIndex(r7), this.getIndex(r8), nCol);
    }

    public final void preAggregateDDC_SDCZ(AMapToData tm, IDictionary td, AOffset tof, Dictionary ret, int nCol) {
        if (nCol == 1) {
            this.preAggregateDDC_SDCZSingleCol(tm, td.getValues(), tof, ret.getValues());
        } else {
            this.preAggregateDDC_SDCZMultiCol(tm, td, tof, ret.getValues(), nCol);
        }
    }

    public void preAggregateDDC_SDCZSingleCol(AMapToData tm, double[] td, AOffset tof, double[] v) {
        AOffsetIterator itThat = tof.getOffsetIterator();
        int size = tm.size() - 1;
        for (int i = 0; i < size; ++i) {
            int to = this.getIndex(itThat.value());
            int fr = tm.getIndex(i);
            int n = to;
            v[n] = v[n] + td[fr];
            itThat.next();
        }
        int to = this.getIndex(itThat.value());
        int fr = tm.getIndex(size);
        int n = to;
        v[n] = v[n] + td[fr];
    }

    public void preAggregateDDC_SDCZMultiCol(AMapToData tm, IDictionary td, AOffset tof, double[] v, int nCol) {
        int fr;
        int to;
        int i;
        AOffsetIterator it = tof.getOffsetIterator();
        int size = tm.size() - 1;
        int n = i = size > 8 ? this.preAggregateDDC_SDCZMultiCol_vect(tm, td, v, nCol, it, size) : 0;
        while (i < size) {
            to = this.getIndex(it.value());
            fr = tm.getIndex(i);
            td.addToEntry(v, fr, to, nCol);
            it.next();
            ++i;
        }
        to = this.getIndex(it.value());
        fr = tm.getIndex(size);
        td.addToEntry(v, fr, to, nCol);
    }

    private int preAggregateDDC_SDCZMultiCol_vect(AMapToData tm, IDictionary td, double[] v, int nCol, AOffsetIterator it, int size) {
        int i;
        int h = size % 8;
        for (i = 0; i < size - h; i += 8) {
            int t1 = it.value();
            int t2 = it.next();
            int t3 = it.next();
            int t4 = it.next();
            int t5 = it.next();
            int t6 = it.next();
            int t7 = it.next();
            int t8 = it.next();
            t1 = this.getIndex(t1);
            t2 = this.getIndex(t2);
            t3 = this.getIndex(t3);
            t4 = this.getIndex(t4);
            t5 = this.getIndex(t5);
            t6 = this.getIndex(t6);
            t7 = this.getIndex(t7);
            t8 = this.getIndex(t8);
            int f1 = tm.getIndex(i);
            int f2 = tm.getIndex(i + 1);
            int f3 = tm.getIndex(i + 2);
            int f4 = tm.getIndex(i + 3);
            int f5 = tm.getIndex(i + 4);
            int f6 = tm.getIndex(i + 5);
            int f7 = tm.getIndex(i + 6);
            int f8 = tm.getIndex(i + 7);
            it.next();
            td.addToEntryVectorized(v, f1, f2, f3, f4, f5, f6, f7, f8, t1, t2, t3, t4, t5, t6, t7, t8, nCol);
        }
        return i;
    }

    public final void preAggregateSDCZ_DDC(AMapToData tm, IDictionary td, AOffset of, Dictionary ret, int nCol) {
        if (nCol == 1) {
            this.preAggregateSDCZ_DDCSingleCol(tm, td.getValues(), of, ret.getValues());
        } else {
            this.preAggregateSDCZ_DDCMultiCol(tm, td, of, ret.getValues(), nCol);
        }
    }

    protected void preAggregateSDCZ_DDCSingleCol(AMapToData tm, double[] td, AOffset of, double[] v) {
        AOffsetIterator itThis = of.getOffsetIterator();
        int size = this.size() - 1;
        int tv = itThis.value();
        for (int i = 0; i < size; ++i) {
            int n = this.getIndex(i);
            v[n] = v[n] + td[tm.getIndex(tv)];
            tv = itThis.next();
        }
        int n = this.getIndex(size);
        v[n] = v[n] + td[tm.getIndex(tv)];
    }

    protected void preAggregateSDCZ_DDCMultiCol(AMapToData tm, IDictionary td, AOffset of, double[] v, int nCol) {
        int size;
        AOffsetIterator itThis = of.getOffsetIterator();
        int tv = itThis.value();
        for (int i = (size = this.size() - 1) > 8 ? this.preAggregateSDCZ_DDCMultiCol_vect(tm, td, v, nCol, itThis, size) : 0; i < size; ++i) {
            td.addToEntry(v, tm.getIndex(tv), this.getIndex(i), nCol);
            tv = itThis.next();
        }
        td.addToEntry(v, tm.getIndex(tv), this.getIndex(size), nCol);
    }

    private int preAggregateSDCZ_DDCMultiCol_vect(AMapToData tm, IDictionary td, double[] v, int nCol, AOffsetIterator it, int size) {
        int i;
        int h = size % 8;
        for (i = 0; i < size - h; i += 8) {
            int t1 = this.getIndex(i);
            int t2 = this.getIndex(i + 1);
            int t3 = this.getIndex(i + 2);
            int t4 = this.getIndex(i + 3);
            int t5 = this.getIndex(i + 4);
            int t6 = this.getIndex(i + 5);
            int t7 = this.getIndex(i + 6);
            int t8 = this.getIndex(i + 7);
            int f1 = it.value();
            int f2 = it.next();
            int f3 = it.next();
            int f4 = it.next();
            int f5 = it.next();
            int f6 = it.next();
            int f7 = it.next();
            int f8 = it.next();
            f1 = tm.getIndex(f1);
            f2 = tm.getIndex(f2);
            f3 = tm.getIndex(f3);
            f4 = tm.getIndex(f4);
            f5 = tm.getIndex(f5);
            f6 = tm.getIndex(f6);
            f7 = tm.getIndex(f7);
            f8 = tm.getIndex(f8);
            it.next();
            td.addToEntryVectorized(v, f1, f2, f3, f4, f5, f6, f7, f8, t1, t2, t3, t4, t5, t6, t7, t8, nCol);
        }
        return i;
    }

    public final void preAggregateSDCZ_SDCZ(AMapToData tm, IDictionary td, AOffset tof, AOffset of, Dictionary ret, int nCol) {
        if (nCol == 1) {
            this.preAggregateSDCZ_SDCZSingleCol(tm, td.getValues(), tof, of, ret.getValues());
        } else {
            this.preAggregateSDCZ_SDCZMultiCol(tm, td, tof, of, ret.getValues(), nCol);
        }
    }

    private final void preAggregateSDCZ_SDCZSingleCol(AMapToData tm, double[] td, AOffset tof, AOffset of, double[] dv) {
        AOffsetIterator itThat = tof.getOffsetIterator();
        AOffsetIterator itThis = of.getOffsetIterator();
        int tSize = tm.size() - 1;
        int size = this.size() - 1;
        this.preAggregateSDCZ_SDCZSingleCol(tm, td, dv, itThat, itThis, tSize, size);
    }

    protected void preAggregateSDCZ_SDCZSingleCol(AMapToData tm, double[] td, double[] dv, AOffsetIterator itThat, AOffsetIterator itThis, int tSize, int size) {
        int i = 0;
        int j = 0;
        int tv = itThat.value();
        int v = itThis.value();
        while (i < tSize && j < size) {
            if (tv == v) {
                int n = this.getIndex(j);
                dv[n] = dv[n] + td[tm.getIndex(i)];
                tv = itThat.next();
                v = itThis.next();
                ++i;
                ++j;
                continue;
            }
            if (tv < v) {
                tv = itThat.next();
                ++i;
                continue;
            }
            v = itThis.next();
            ++j;
        }
        AMapToData.preAggregateSDCZ_SDCZMultiCol_tail(tm, this, Dictionary.create(td), dv, 1, itThat, itThis, tSize, size, i, j);
    }

    protected void preAggregateSDCZ_SDCZMultiCol(AMapToData tm, IDictionary td, AOffset tof, AOffset of, double[] dv, int nCol) {
        AOffsetIterator itThat = tof.getOffsetIterator();
        AOffsetIterator itThis = of.getOffsetIterator();
        int tSize = tm.size() - 1;
        int size = this.size() - 1;
        int i = 0;
        int j = 0;
        while (i < tSize && j < size) {
            int v;
            int tv = itThat.value();
            if (tv == (v = itThis.value())) {
                int fr = tm.getIndex(i);
                int to = this.getIndex(j);
                td.addToEntry(dv, fr, to, nCol);
                itThat.next();
                itThis.next();
                ++i;
                ++j;
                continue;
            }
            if (tv < v) {
                itThat.next();
                ++i;
                continue;
            }
            itThis.next();
            ++j;
        }
        AMapToData.preAggregateSDCZ_SDCZMultiCol_tail(tm, this, td, dv, nCol, itThat, itThis, tSize, size, i, j);
    }

    protected static void preAggregateSDCZ_SDCZMultiCol_tail(AMapToData tm, AMapToData m, IDictionary td, double[] dv, int nCol, AOffsetIterator itThat, AOffsetIterator itThis, int tSize, int size, int i, int j) {
        int v;
        int tv = itThat.value();
        if (tv == (v = itThis.value())) {
            int fr = tm.getIndex(i);
            int to = m.getIndex(j);
            td.addToEntry(dv, fr, to, nCol);
            return;
        }
        while (i < tSize && tv < v) {
            itThat.next();
            ++i;
            tv = itThat.value();
            if (tv != v) continue;
            int fr = tm.getIndex(i);
            int to = m.getIndex(j);
            td.addToEntry(dv, fr, to, nCol);
            return;
        }
        while (j < size && v < tv) {
            itThis.next();
            ++j;
            v = itThis.value();
            if (tv != v) continue;
            int fr = tm.getIndex(i);
            int to = m.getIndex(j);
            td.addToEntry(dv, fr, to, nCol);
            return;
        }
    }

    public void preAggregateRLE_DDC(int[] ptr, char[] data, IDictionary td, Dictionary ret, int nCol) {
        if (nCol == 1) {
            this.preAggregateRLE_DDCSingleCol(ptr, data, td.getValues(), ret.getValues());
        } else {
            this.preAggregateRLE_DDCMultiCol(ptr, data, td, ret.getValues(), nCol);
        }
    }

    protected void preAggregateRLE_DDCSingleCol(int[] ptr, char[] data, double[] td, double[] ret) {
        for (int k = 0; k < ret.length; ++k) {
            int blen = ptr[k + 1];
            int rs = 0;
            int re = 0;
            for (int apos = ptr[k]; apos < blen; apos += 2) {
                rs = re + data[apos];
                re = rs + data[apos + 1];
                for (int rix = rs; rix < re; ++rix) {
                    int n = k;
                    ret[n] = ret[n] + td[this.getIndex(rix)];
                }
            }
        }
    }

    protected void preAggregateRLE_DDCMultiCol(int[] ptr, char[] data, IDictionary td, double[] ret, int nCol) {
        for (int k = 0; k < ret.length / nCol; ++k) {
            int blen = ptr[k + 1];
            int rs = 0;
            int re = 0;
            for (int apos = ptr[k]; apos < blen; apos += 2) {
                rs = re + data[apos];
                re = rs + data[apos + 1];
                for (int rix = rs; rix < re; ++rix) {
                    td.addToEntry(ret, this.getIndex(rix), k, nCol);
                }
            }
        }
    }

    public void preAggregateDDC_RLE(int[] ptr, char[] data, IDictionary td, Dictionary ret, int nCol) {
        double[] v = ret.getValues();
        for (int k = 0; k < ptr.length - 1; ++k) {
            int blen = ptr[k + 1];
            int rs = 0;
            int re = 0;
            for (int apos = ptr[k]; apos < blen; apos += 2) {
                rs = re + data[apos];
                re = rs + data[apos + 1];
                for (int rix = rs; rix < re; ++rix) {
                    td.addToEntry(v, k, this.getIndex(rix), nCol);
                }
            }
        }
    }

    public void copy(AMapToData d) {
        if (d.nUnique == 1) {
            this.fill(0);
        } else if (d instanceof MapToBit) {
            this.copyBit((MapToBit)d);
        } else if (d instanceof MapToInt) {
            this.copyInt((MapToInt)d);
        } else {
            int sz = this.size();
            for (int i = 0; i < sz; ++i) {
                this.set(i, d.getIndex(i));
            }
        }
    }

    protected void copyInt(MapToInt d) {
        this.copyInt(d.getData());
    }

    public void copyInt(int[] d) {
        this.copyInt(d, 0, Math.min(d.length, this.size()));
    }

    public abstract void copyInt(int[] var1, int var2, int var3);

    public void copyBit(MapToBit d) {
        this.fill(0);
        int i = d.nextSetBit(0);
        while (i >= 0) {
            this.set(i, 1);
            i = d.nextSetBit(i + 1);
        }
    }

    public int getMax() {
        int m = -1;
        for (int i = 0; i < this.size(); ++i) {
            int v = this.getIndex(i);
            m = v > m ? v : m;
        }
        return m;
    }

    public abstract AMapToData resize(int var1);

    public abstract int countRuns();

    public int countRuns(AOffset off) {
        int c = 1;
        int size = this.size();
        AOffsetIterator of = off.getOffsetIterator();
        for (int i = 1; i < size; ++i) {
            int id = of.value();
            if (id + 1 == of.next()) {
                c += this.getIndex(i - 1) == this.getIndex(i) ? 0 : 1;
                continue;
            }
            ++c;
        }
        return c;
    }

    public abstract AMapToData slice(int var1, int var2);

    public abstract AMapToData append(AMapToData var1);

    public abstract AMapToData appendN(IMapToDataGroup[] var1);

    public boolean equals(Object e) {
        return this == e || e instanceof AMapToData && this.equals((AMapToData)e);
    }

    public abstract boolean equals(AMapToData var1);

    public void verify() {
        if (CompressedMatrixBlock.debug) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.getIndex(i) < this.nUnique) continue;
                throw new DMLCompressionException("Invalid construction of Mapping data containing values above unique");
            }
        }
    }

    public void lmSparseMatrixRow(SparseBlock sb, int r, DenseBlock db, IColIndex colIndexes, IDictionary dict) {
        if (sb.isEmpty(r)) {
            return;
        }
        int pos = db.pos(r);
        double[] retV = db.values(r);
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] aval = sb.values(r);
        for (int i = apos; i < alen; ++i) {
            dict.multiplyScalar(aval[i], retV, pos, this.getIndex(aix[i]), colIndexes);
        }
    }

    public void decompressToRange(double[] c, int rl, int ru, int offR, double[] values) {
        if (offR == 0) {
            this.decompressToRangeNoOff(c, rl, ru, values);
        } else {
            this.decompressToRangeOff(c, rl, ru, offR, values);
        }
    }

    protected void decompressToRangeOff(double[] c, int rl, int ru, int offR, double[] values) {
        int offT = rl + offR;
        for (int i = rl; i < ru; ++i) {
            int n = offT++;
            c[n] = c[n] + values[this.getIndex(i)];
        }
    }

    protected void decompressToRangeNoOffBy8(double[] c, int r, double[] values) {
        int n = r;
        c[n] = c[n] + values[this.getIndex(r)];
        int n2 = r + 1;
        c[n2] = c[n2] + values[this.getIndex(r + 1)];
        int n3 = r + 2;
        c[n3] = c[n3] + values[this.getIndex(r + 2)];
        int n4 = r + 3;
        c[n4] = c[n4] + values[this.getIndex(r + 3)];
        int n5 = r + 4;
        c[n5] = c[n5] + values[this.getIndex(r + 4)];
        int n6 = r + 5;
        c[n6] = c[n6] + values[this.getIndex(r + 5)];
        int n7 = r + 6;
        c[n7] = c[n7] + values[this.getIndex(r + 6)];
        int n8 = r + 7;
        c[n8] = c[n8] + values[this.getIndex(r + 7)];
    }

    protected void decompressToRangeNoOff(double[] c, int rl, int ru, double[] values) {
        int rc;
        int h = (ru - rl) % 8;
        for (rc = rl; rc < rl + h; ++rc) {
            int n = rc;
            c[n] = c[n] + values[this.getIndex(rc)];
        }
        for (rc = rl + h; rc < ru; rc += 8) {
            this.decompressToRangeNoOffBy8(c, rc, values);
        }
    }

    public AMapToData[] splitReshapeDDC(int multiplier) {
        int s = this.size();
        AMapToData[] ret = new AMapToData[multiplier];
        int eachSize = s / multiplier;
        for (int i = 0; i < multiplier; ++i) {
            ret[i] = MapToFactory.create(eachSize, this.getUnique());
        }
        int blkz = Math.max(eachSize / 8, 2048) * multiplier;
        for (int i = 0; i < s; i += blkz) {
            this.splitReshapeDDCBlock(ret, multiplier, i, Math.min(i + blkz, s));
        }
        return ret;
    }

    public AMapToData[] splitReshapeDDCPushDown(int multiplier, ExecutorService pool) throws Exception {
        int s = this.size();
        AMapToData[] ret = new AMapToData[multiplier];
        int eachSize = s / multiplier;
        for (int i = 0; i < multiplier; ++i) {
            ret[i] = MapToFactory.create(eachSize, this.getUnique());
        }
        int blkz = Math.max(eachSize / 8, 2048) * multiplier;
        ArrayList tasks = new ArrayList();
        for (int i = 0; i < s; i += blkz) {
            int n = i;
            int end = Math.min(i + blkz, s);
            tasks.add(pool.submit(() -> this.splitReshapeDDCBlock(ret, multiplier, start, end)));
        }
        for (Future future : tasks) {
            future.get();
        }
        return ret;
    }

    private void splitReshapeDDCBlock(AMapToData[] ret, int multiplier, int start, int end) {
        for (int i = start; i < end; i += multiplier) {
            this.splitReshapeDDCRow(ret, multiplier, i);
        }
    }

    private void splitReshapeDDCRow(AMapToData[] ret, int multiplier, int i) {
        int off = i / multiplier;
        int end = i + multiplier;
        for (int j = i; j < end; ++j) {
            ret[j % multiplier].set(off, this.getIndex(j));
        }
    }

    public String toString() {
        int sz = this.size();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        for (int i = 0; i < sz - 1; ++i) {
            sb.append(this.getIndex(i) + ", ");
        }
        sb.append(this.getIndex(sz - 1));
        sb.append("]");
        return sb.toString();
    }
}

