/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ADictBasedColGroup;
import org.apache.sysds.runtime.compress.colgroup.AOffsetsGroup;
import org.apache.sysds.runtime.compress.colgroup.ASDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupIO;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUtils;
import org.apache.sysds.runtime.compress.colgroup.IContainDefaultTuple;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.PlaceHolderDict;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetEmpty;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.estim.encoding.EncodingFactory;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupSDCSingle
extends ASDC {
    private static final long serialVersionUID = 3883228464052204200L;
    protected final double[] _defaultTuple;

    private ColGroupSDCSingle(IColIndex colIndices, int numRows, IDictionary dict, double[] defaultTuple, AOffset offsets, int[] cachedCounts) {
        super(colIndices, numRows, dict == null ? Dictionary.createNoCheck(new double[colIndices.size()]) : dict, offsets, cachedCounts);
        this._defaultTuple = defaultTuple;
        if (CompressedMatrixBlock.debug) {
            this._indexes.verify(this._indexes.getSize());
        }
    }

    public static AColGroup create(IColIndex colIndexes, int numRows, IDictionary dict, double[] defaultTuple, AOffset offsets, int[] cachedCounts) {
        if (offsets instanceof OffsetEmpty) {
            return ColGroupConst.create(colIndexes, defaultTuple);
        }
        boolean allZero = ColGroupUtils.allZero(defaultTuple);
        if (dict == null && allZero) {
            return new ColGroupEmpty(colIndexes);
        }
        if (dict == null && offsets.getSize() * 2 > numRows + 2) {
            AOffset rev = offsets.reverse(numRows);
            return ColGroupSDCSingleZeros.create(colIndexes, numRows, Dictionary.create(defaultTuple), rev, cachedCounts);
        }
        if (dict == null) {
            return new ColGroupSDCSingle(colIndexes, numRows, null, defaultTuple, offsets, cachedCounts);
        }
        if (allZero) {
            return ColGroupSDCSingleZeros.create(colIndexes, numRows, dict, offsets, cachedCounts);
        }
        if (offsets.getSize() * 2 > numRows + 2 && !(dict instanceof PlaceHolderDict)) {
            AOffset rev = offsets.reverse(numRows);
            return new ColGroupSDCSingle(colIndexes, numRows, Dictionary.create(defaultTuple), dict.getValues(), rev, null);
        }
        return new ColGroupSDCSingle(colIndexes, numRows, dict, defaultTuple, offsets, cachedCounts);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.SDC;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.SDCSingle;
    }

    @Override
    public double[] getDefaultTuple() {
        return this._defaultTuple;
    }

    @Override
    public double getIdx(int r, int colIdx) {
        AIterator it = this._indexes.getIterator(r);
        if (it == null || it.value() != r) {
            return this._defaultTuple[colIdx];
        }
        return this._dict.getValue(colIdx);
    }

    @Override
    protected double[] preAggSumRows() {
        return this._dict.sumAllRowsToDoubleWithDefault(this._defaultTuple);
    }

    @Override
    protected double[] preAggSumSqRows() {
        return this._dict.sumAllRowsToDoubleSqWithDefault(this._defaultTuple);
    }

    @Override
    protected double[] preAggProductRows() {
        return this._dict.productAllRowsToDoubleWithDefault(this._defaultTuple);
    }

    @Override
    protected double[] preAggBuiltinRows(Builtin builtin) {
        return this._dict.aggregateRowsWithDefault(builtin, this._defaultTuple);
    }

    @Override
    protected double computeMxx(double c, Builtin builtin) {
        double ret = this._dict.aggregate(c, builtin);
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            ret = builtin.execute(ret, this._defaultTuple[i]);
        }
        return ret;
    }

    @Override
    protected void computeColMxx(double[] c, Builtin builtin) {
        this._dict.aggregateCols(c, builtin, this._colIndexes);
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            c[this._colIndexes.get((int)x)] = builtin.execute(c[this._colIndexes.get(x)], this._defaultTuple[x]);
        }
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        ColGroupSDCSingle.computeRowSums(c, rl, ru, preAgg, this._indexes, this._numRows);
    }

    protected static final void computeRowSums(double[] c, int rl, int ru, double[] preAgg, AOffset indexes, int nRows) {
        double def;
        int r;
        block10: {
            r = rl;
            AIterator it = indexes.getIterator(rl);
            def = preAgg[1];
            double norm = preAgg[0];
            if (it != null) {
                if (it.value() > ru) {
                    indexes.cacheIterator(it, ru);
                } else {
                    if (ru > indexes.getOffsetToLast()) {
                        int maxOff = indexes.getOffsetToLast();
                        while (true) {
                            if (it.value() == r) {
                                int n = r++;
                                c[n] = c[n] + norm;
                                if (it.value() >= maxOff) break block10;
                                it.next();
                            } else {
                                int n = r;
                                c[n] = c[n] + def;
                            }
                            ++r;
                        }
                    }
                    while (r < ru) {
                        if (it.value() == r) {
                            int n = r++;
                            c[n] = c[n] + norm;
                            it.next();
                            continue;
                        }
                        int n = r++;
                        c[n] = c[n] + def;
                    }
                    indexes.cacheIterator(it, ru);
                }
            }
        }
        while (r < ru) {
            int n = r++;
            c[n] = c[n] + def;
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        ColGroupSDCSingle.computeRowMxx(c, builtin, rl, ru, this._indexes, this._numRows, preAgg[1], preAgg[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static final void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, AOffset indexes, int nRows, double def, double norm) {
        int r;
        block7: {
            AIterator it;
            block9: {
                block8: {
                    it = indexes.getIterator(rl);
                    if (it == null) break block7;
                    if (it.value() <= ru) break block8;
                    indexes.cacheIterator(it, ru);
                    break block7;
                }
                if (ru <= indexes.getOffsetToLast()) break block9;
                int maxOff = indexes.getOffsetToLast();
                while (true) {
                    block11: {
                        block10: {
                            if (it.value() != r) break block10;
                            c[r] = builtin.execute(c[r], norm);
                            if (it.value() < maxOff) {
                                it.next();
                                break block11;
                            } else {
                                ++r;
                                break block7;
                            }
                        }
                        c[r] = builtin.execute(c[r], def);
                    }
                    ++r;
                }
            }
            for (r = rl; r < ru; ++r) {
                if (it.value() == r) {
                    c[r] = builtin.execute(c[r], norm);
                    it.next();
                    continue;
                }
                c[r] = builtin.execute(c[r], def);
            }
            indexes.cacheIterator(it, ru);
        }
        while (r < ru) {
            c[r] = builtin.execute(c[r], def);
            ++r;
        }
        return;
    }

    @Override
    protected void computeRowProduct(double[] c, int rl, int ru, double[] preAgg) {
        ColGroupSDCSingle.computeRowProduct(c, rl, ru, this._indexes, this._numRows, preAgg[1], preAgg[0]);
    }

    protected static final void computeRowProduct(double[] c, int rl, int ru, AOffset indexes, int nRows, double def, double norm) {
        int r;
        block10: {
            r = rl;
            AIterator it = indexes.getIterator(rl);
            if (it != null) {
                if (it.value() > ru) {
                    indexes.cacheIterator(it, ru);
                } else {
                    if (ru > indexes.getOffsetToLast()) {
                        int maxOff = indexes.getOffsetToLast();
                        while (true) {
                            if (it.value() == r) {
                                int n = r++;
                                c[n] = c[n] * norm;
                                if (it.value() >= maxOff) break block10;
                                it.next();
                            } else {
                                int n = r;
                                c[n] = c[n] * def;
                            }
                            ++r;
                        }
                    }
                    while (r < ru) {
                        if (it.value() == r) {
                            int n = r++;
                            c[n] = c[n] * norm;
                            it.next();
                            continue;
                        }
                        int n = r++;
                        c[n] = c[n] * def;
                    }
                    indexes.cacheIterator(it, ru);
                }
            }
        }
        while (r < ru) {
            int n = r++;
            c[n] = c[n] * def;
        }
    }

    @Override
    protected void computeSum(double[] c, int nRows) {
        super.computeSum(c, nRows);
        int count = this._numRows - this._indexes.getSize();
        for (int x = 0; x < this._defaultTuple.length; ++x) {
            c[0] = c[0] + this._defaultTuple[x] * (double)count;
        }
    }

    @Override
    public void computeColSums(double[] c, int nRows) {
        super.computeColSums(c, nRows);
        int count = this._numRows - this._indexes.getSize();
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            int n = this._colIndexes.get(x);
            c[n] = c[n] + this._defaultTuple[x] * (double)count;
        }
    }

    @Override
    protected void computeSumSq(double[] c, int nRows) {
        super.computeSumSq(c, nRows);
        int count = this._numRows - this._indexes.getSize();
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            c[0] = c[0] + this._defaultTuple[x] * this._defaultTuple[x] * (double)count;
        }
    }

    @Override
    protected void computeColSumsSq(double[] c, int nRows) {
        super.computeColSumsSq(c, nRows);
        int count = this._numRows - this._indexes.getSize();
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            int n = this._colIndexes.get(x);
            c[n] = c[n] + this._defaultTuple[x] * this._defaultTuple[x] * (double)count;
        }
    }

    @Override
    protected void computeProduct(double[] c, int nRows) {
        int count = this._numRows - this._indexes.getSize();
        this._dict.productWithDefault(c, this.getCounts(), this._defaultTuple, count);
    }

    @Override
    protected void computeColProduct(double[] c, int nRows) {
        super.computeColProduct(c, nRows);
        int count = this._numRows - this._indexes.getSize();
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            double v = c[this._colIndexes.get(x)];
            c[this._colIndexes.get((int)x)] = v != 0.0 ? v * Math.pow(this._defaultTuple[x], count) : 0.0;
        }
    }

    @Override
    public int[] getCounts(int[] counts) {
        counts[0] = this._indexes.getSize();
        return counts;
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += this._indexes.getInMemorySize();
        return size += (long)(8 * this._colIndexes.size());
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = op.executeScalar(this._defaultTuple[i]);
        }
        IDictionary nDict = this._dict.applyScalarOp(op);
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, nDict, newDefaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = op.fn.execute(this._defaultTuple[i]);
        }
        IDictionary nDict = this._dict.applyUnaryOp(op);
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, nDict, newDefaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = op.fn.execute(v[this._colIndexes.get(i)], this._defaultTuple[i]);
        }
        IDictionary newDict = this._dict.binOpLeft(op, v, this._colIndexes);
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, newDict, newDefaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = op.fn.execute(this._defaultTuple[i], v[this._colIndexes.get(i)]);
        }
        IDictionary newDict = this._dict.binOpRight(op, v, this._colIndexes);
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, newDict, newDefaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._indexes.write(out);
        for (double d : this._defaultTuple) {
            out.writeDouble(d);
        }
    }

    public static ColGroupSDCSingle read(DataInput in, int nRows) throws IOException {
        IColIndex cols = ColIndexFactory.read(in);
        IDictionary dict = DictionaryFactory.read(in);
        AOffset indexes = OffsetFactory.readIn(in);
        double[] defaultTuple = ColGroupIO.readDoubleArray(cols.size(), in);
        return new ColGroupSDCSingle(cols, nRows, dict, defaultTuple, indexes, null);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ret += this._indexes.getExactSizeOnDisk();
        return ret += (long)(8 * this._colIndexes.size());
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        IDictionary replaced = this._dict.replace(pattern, replace, this._colIndexes.size());
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = Util.eq(this._defaultTuple[i], pattern) ? replace : this._defaultTuple[i];
        }
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, replaced, newDefaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup extractCommon(double[] constV) {
        for (int i = 0; i < this._colIndexes.size(); ++i) {
            int n = this._colIndexes.get(i);
            constV[n] = constV[n] + this._defaultTuple[i];
        }
        IDictionary subtractedDict = this._dict.subtractTuple(this._defaultTuple);
        return ColGroupSDCSingleZeros.create(this._colIndexes, this._numRows, subtractedDict, this._indexes, this.getCachedCounts());
    }

    @Override
    public long getNumberNonZeros(int nRows) {
        long nnz = super.getNumberNonZeros(nRows);
        int count = this._numRows - this._indexes.getSize();
        for (int x = 0; x < this._colIndexes.size(); ++x) {
            nnz += this._defaultTuple[x] != 0.0 ? (long)count : 0L;
        }
        return nnz;
    }

    @Override
    public CM_COV_Object centralMoment(CMOperator op, int nRows) {
        return this._dict.centralMomentWithDefault(op.fn, this.getCounts(), this._defaultTuple[0], nRows);
    }

    @Override
    public AColGroup rexpandCols(int max, boolean ignore, boolean cast, int nRows) {
        IDictionary d = this._dict.rexpandCols(max, ignore, cast, this._colIndexes.size());
        int def = (int)this._defaultTuple[0];
        if (d == null) {
            if (def <= 0) {
                if (max > 0) {
                    return ColGroupEmpty.create(max);
                }
                return null;
            }
            if (def > max && max > 0) {
                return ColGroupEmpty.create(max);
            }
            if (max <= 0) {
                return null;
            }
            double[] retDef = new double[max];
            retDef[(int)this._defaultTuple[0] - 1] = 1.0;
            return ColGroupSDCSingle.create(ColIndexFactory.create(max), nRows, null, retDef, this._indexes, null);
        }
        IColIndex outCols = ColIndexFactory.create(d.getNumberOfColumns(this._dict.getNumberOfValues(1)));
        if (def <= 0) {
            if (ignore) {
                return ColGroupSDCSingleZeros.create(outCols, nRows, d, this._indexes, this.getCachedCounts());
            }
            throw new DMLRuntimeException("Invalid content of zero in rexpand");
        }
        if (def > max) {
            return ColGroupSDCSingleZeros.create(outCols, nRows, d, this._indexes, this.getCachedCounts());
        }
        double[] retDef = new double[max];
        retDef[(int)this._defaultTuple[0] - 1] = 1.0;
        return ColGroupSDCSingle.create(outCols, nRows, d, retDef, this._indexes, this.getCachedCounts());
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nVals = this.getNumValues();
        int nCols = this.getNumCols();
        int nRowsScanned = this._indexes.getSize();
        return e.getCost(nRows, nRowsScanned, nCols, nVals, this._dict.getSparsity());
    }

    @Override
    protected AColGroup sliceMultiColumns(int idStart, int idEnd, IColIndex outputCols) {
        AColGroup ret = super.sliceMultiColumns(idStart, idEnd, outputCols);
        double[] defTuple = new double[idEnd - idStart];
        int i = idStart;
        int j = 0;
        while (i < idEnd) {
            defTuple[j] = this._defaultTuple[i];
            ++i;
            ++j;
        }
        if (ret instanceof ColGroupEmpty) {
            return ColGroupSDCSingle.create(ret._colIndexes, this._numRows, null, defTuple, this._indexes, null);
        }
        ColGroupSDCSingle retSDC = (ColGroupSDCSingle)ret;
        return ColGroupSDCSingle.create(retSDC._colIndexes, this._numRows, retSDC._dict, defTuple, this._indexes, null);
    }

    @Override
    protected AColGroup sliceSingleColumn(int idx) {
        AColGroup ret = super.sliceSingleColumn(idx);
        double[] defTuple = new double[]{this._defaultTuple[idx]};
        if (ret instanceof ColGroupEmpty) {
            return ColGroupSDCSingle.create(ret._colIndexes, this._numRows, null, defTuple, this._indexes, null);
        }
        ColGroupSDCSingle retSDC = (ColGroupSDCSingle)ret;
        return ColGroupSDCSingle.create(retSDC._colIndexes, this._numRows, retSDC._dict, defTuple, this._indexes, null);
    }

    @Override
    public boolean containsValue(double pattern) {
        if (this._dict.containsValue(pattern)) {
            return true;
        }
        for (double v : this._defaultTuple) {
            if (v != pattern) continue;
            return true;
        }
        return false;
    }

    @Override
    public double[] getCommon() {
        return this._defaultTuple;
    }

    @Override
    protected AColGroup allocateRightMultiplicationCommon(double[] common, IColIndex colIndexes, IDictionary preAgg) {
        return ColGroupSDCSingle.create(colIndexes, this._numRows, preAgg, common, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup sliceRows(int rl, int ru) {
        AOffset.OffsetSliceInfo off = this._indexes.slice(rl, ru);
        if (off.lIndex == -1) {
            return ColGroupConst.create(this._colIndexes, (IDictionary)Dictionary.create(this._defaultTuple));
        }
        return ColGroupSDCSingle.create(this._colIndexes, ru - rl, this._dict, this._defaultTuple, off.offsetSlice, null);
    }

    @Override
    protected AColGroup copyAndSet(IColIndex colIndexes, IDictionary newDictionary) {
        return ColGroupSDCSingle.create(colIndexes, this._numRows, newDictionary, this._defaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup append(AColGroup g) {
        return null;
    }

    @Override
    public AColGroup appendNInternal(AColGroup[] g, int blen, int rlen) {
        for (int i = 1; i < g.length; ++i) {
            ADictBasedColGroup gc;
            AColGroup gs = g[i];
            if (!this._colIndexes.equals(gs._colIndexes)) {
                throw new DMLCompressionException("Not same columns therefore not appending \n" + this._colIndexes + "\n\n" + gs._colIndexes);
            }
            if (!(gs instanceof AOffsetsGroup)) {
                throw new DMLCompressionException("Not SDC but " + gs.getClass().getSimpleName());
            }
            if (gs instanceof ColGroupSDC) {
                gc = (ColGroupSDC)gs;
                if (gc._dict.equals(this._dict)) continue;
                throw new DMLCompressionException("Not same Dictionaries therefore not appending \n" + this._dict + "\n\n" + gc._dict);
            }
            if (!(gs instanceof ColGroupConst)) continue;
            gc = (ColGroupConst)gs;
            if (((ColGroupConst)gc)._dict instanceof PlaceHolderDict || !((ColGroupConst)gc)._dict.equals(this._defaultTuple)) continue;
            throw new DMLCompressionException("Not same default values therefore not appending:\n" + ((ColGroupConst)gc)._dict + "\n\n" + Arrays.toString(this._defaultTuple));
        }
        AOffset no = this._indexes.appendN((AOffsetsGroup[])Arrays.copyOf(g, g.length, AOffsetsGroup[].class), this.getNumRows());
        return ColGroupSDCSingle.create(this._colIndexes, rlen, this._dict, this._defaultTuple, no, null);
    }

    @Override
    public AColGroup recompress() {
        return this;
    }

    @Override
    public IEncode getEncoding() {
        return EncodingFactory.create(new MapToZero(this.getCounts()[0]), this._indexes, this._numRows);
    }

    @Override
    public int getNumberOffsets() {
        return this.getCounts()[0];
    }

    @Override
    public boolean sameIndexStructure(AColGroupCompressed that) {
        if (that instanceof ColGroupSDCSingleZeros) {
            ColGroupSDCSingleZeros th = (ColGroupSDCSingleZeros)that;
            return th._indexes == this._indexes;
        }
        if (that instanceof ColGroupSDCSingle) {
            ColGroupSDCSingle th = (ColGroupSDCSingle)that;
            return th._indexes == this._indexes;
        }
        return false;
    }

    @Override
    protected AColGroup fixColIndexes(IColIndex newColIndex, int[] reordering) {
        return ColGroupSDCSingle.create(newColIndex, this.getNumRows(), this._dict.reorder(reordering), ColGroupUtils.reorderDefault(this._defaultTuple, reordering), this._indexes, this.getCachedCounts());
    }

    @Override
    protected void sparseSelection(MatrixBlock selection, ColGroupUtils.P[] points, MatrixBlock ret, int rl, int ru) {
        throw new NotImplementedException();
    }

    @Override
    protected void denseSelection(MatrixBlock selection, ColGroupUtils.P[] points, MatrixBlock ret, int rl, int ru) {
        throw new NotImplementedException();
    }

    @Override
    public AColGroupCompressed combineWithSameIndex(int nRow, int nCol, AColGroup right) {
        ColGroupSDCSingle rightSDC = (ColGroupSDCSingle)right;
        IDictionary b = rightSDC.getDictionary();
        IDictionary combined = DictionaryFactory.cBindDictionaries(this._dict, b, this.getNumCols(), right.getNumCols());
        IColIndex combinedColIndex = this._colIndexes.combine(right.getColIndices().shift(nCol));
        double[] combinedDefaultTuple = new double[this._defaultTuple.length + rightSDC._defaultTuple.length];
        System.arraycopy(this._defaultTuple, 0, combinedDefaultTuple, 0, this._defaultTuple.length);
        System.arraycopy(rightSDC._defaultTuple, 0, combinedDefaultTuple, this._defaultTuple.length, rightSDC._defaultTuple.length);
        return new ColGroupSDCSingle(combinedColIndex, this.getNumRows(), combined, combinedDefaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroupCompressed combineWithSameIndex(int nRow, int nCol, List<AColGroup> right) {
        IDictionary combined = this.combineDictionaries(nCol, right);
        IColIndex combinedColIndex = this.combineColIndexes(nCol, right);
        double[] combinedDefaultTuple = IContainDefaultTuple.combineDefaultTuples(this._defaultTuple, right);
        return new ColGroupSDCSingle(combinedColIndex, this.getNumRows(), combined, combinedDefaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup[] splitReshape(int multiplier, int nRow, int nColOrg) {
        int outM;
        int outV;
        int v;
        IntArrayList[] splitOffs = new IntArrayList[multiplier];
        for (int i = 0; i < multiplier; ++i) {
            splitOffs[i] = new IntArrayList();
        }
        AIterator it = this._indexes.getIterator();
        int last = this._indexes.getOffsetToLast();
        while (it.value() != last) {
            v = it.value();
            outV = v / multiplier;
            outM = v % multiplier;
            splitOffs[outM].appendValue(outV);
            it.next();
        }
        v = it.value();
        outV = v / multiplier;
        outM = v % multiplier;
        splitOffs[outM].appendValue(outV);
        AOffset[] offs = new AOffset[multiplier];
        for (int i = 0; i < multiplier; ++i) {
            offs[i] = OffsetFactory.createOffset(splitOffs[i]);
        }
        AColGroup[] res = new AColGroup[multiplier];
        for (int i = 0; i < multiplier; ++i) {
            IColIndex ci = i == 0 ? this._colIndexes : this._colIndexes.shift(i * nColOrg);
            res[i] = ColGroupSDCSingle.create(ci, this._numRows / multiplier, this._dict, this._defaultTuple, offs[i], null);
        }
        return res;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s", "Default: "));
        sb.append(Arrays.toString(this._defaultTuple));
        sb.append(String.format("\n%15s", "Indexes: "));
        sb.append(this._indexes.toString());
        return sb.toString();
    }
}

