/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops.compile.linearization;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.lops.compile.linearization.IDagLinearizer;
import org.apache.sysds.lops.compile.linearization.LinearizerBreadthFirst;
import org.apache.sysds.lops.compile.linearization.LinearizerCostBased;
import org.apache.sysds.lops.compile.linearization.LinearizerDepthFirst;
import org.apache.sysds.lops.compile.linearization.LinearizerMaxParallelism;
import org.apache.sysds.lops.compile.linearization.LinearizerMinIntermediates;
import org.apache.sysds.lops.compile.linearization.LinearizerPipelineAware;
import org.apache.sysds.lops.compile.linearization.LinearizerResourceAwareFast;
import org.apache.sysds.lops.compile.linearization.LinearizerResourceAwareOptimal;

public class IDagLinearizerFactory {
    public static Log LOG = LogFactory.getLog((String)IDagLinearizerFactory.class.getName());

    public static IDagLinearizer createDagLinearizer() {
        DagLinearizer type = ConfigurationManager.getLinearizationOrder();
        return IDagLinearizerFactory.createDagLinearizer(type);
    }

    public static IDagLinearizer createDagLinearizer(DagLinearizer type) {
        switch (type) {
            case AUTO: {
                return new LinearizerCostBased();
            }
            case BREADTH_FIRST: {
                return new LinearizerBreadthFirst();
            }
            case DEPTH_FIRST: {
                return new LinearizerDepthFirst();
            }
            case MAX_PARALLELIZE: {
                return new LinearizerMaxParallelism();
            }
            case MIN_INTERMEDIATE: {
                return new LinearizerMinIntermediates();
            }
            case PIPELINE_DEPTH_FIRST: {
                return new LinearizerPipelineAware();
            }
            case RESOURCE_AWARE_FAST: {
                return new LinearizerResourceAwareFast();
            }
            case RESOURCE_AWARE_OPTIMAL: {
                return new LinearizerResourceAwareOptimal();
            }
        }
        LOG.warn((Object)("Invalid DAG_LINEARIZATION: " + type + ", falling back to DEPTH_FIRST ordering"));
        return new LinearizerDepthFirst();
    }

    public static enum DagLinearizer {
        DEPTH_FIRST,
        BREADTH_FIRST,
        MIN_INTERMEDIATE,
        MAX_PARALLELIZE,
        AUTO,
        PIPELINE_DEPTH_FIRST,
        RESOURCE_AWARE_FAST,
        RESOURCE_AWARE_OPTIMAL;

    }
}

