/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl;

import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import jakarta.servlet.Servlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingJakartaSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"service.description=Sling Info Servlet", "service.vendor=The Apache Software Foundation", "sling.servlet.paths=/system/sling/info"})
public class SlingInfoServlet
extends SlingJakartaSafeMethodsServlet {
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String CACHE_CONTROL_HEADER_VALUE = "private, no-store, no-cache, max-age=0, must-revalidate";
    static final String PROVIDER_LABEL = "sessionInfo";

    private Map<String, String> getInfo(SlingJakartaHttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        ResourceResolver resolver = request.getResourceResolver();
        result.put("userID", resolver.getUserID());
        if (request.getAuthType() != null) {
            result.put("authType", request.getAuthType());
        }
        return result;
    }

    protected void doGet(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
        String label;
        Map<String, String> data = null;
        if (request.getRequestPathInfo().getSelectors().length > 0 && PROVIDER_LABEL.equals(label = request.getRequestPathInfo().getSelectors()[0])) {
            data = this.getInfo(request);
        }
        if (data == null) {
            response.sendError(404, "Unknown Info Request");
        } else {
            response.setHeader(CACHE_CONTROL_HEADER, CACHE_CONTROL_HEADER_VALUE);
            String extension = request.getRequestPathInfo().getExtension();
            if ("json".equals(extension)) {
                this.renderJson(response, data);
            } else if ("txt".equals(extension)) {
                this.renderPlainText(response, data);
            } else {
                this.renderHtml(response, data);
            }
        }
    }

    private void renderJson(SlingJakartaHttpServletResponse response, Map<String, String> data) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        JsonGenerator w = Json.createGenerator((Writer)out);
        w.writeStartObject();
        for (Map.Entry<String, String> e : data.entrySet()) {
            w.write(e.getKey(), e.getValue());
        }
        w.writeEnd();
        w.flush();
    }

    private void renderHtml(SlingJakartaHttpServletResponse response, Map<String, String> data) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
        out.println("<html><head><title>Apche Sling Info</title></head>");
        out.println("<body><h1>Apache Sling Info</h1>");
        out.println("<table>");
        for (Map.Entry<String, String> e : data.entrySet()) {
            out.print("<tr><td>");
            out.print(ResponseUtil.escapeXml((String)e.getKey()));
            out.print("</td><td>");
            out.print(ResponseUtil.escapeXml((String)e.getValue()));
            out.println("</td></tr>");
        }
        out.println("</table>");
        out.println("</body>");
        out.flush();
    }

    private void renderPlainText(SlingJakartaHttpServletResponse response, Map<String, String> data) throws IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        for (Map.Entry<String, String> e : data.entrySet()) {
            out.print(e.getKey());
            out.print(": ");
            out.println(e.getValue());
        }
        out.flush();
    }
}

