/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.runtime;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.scripting.sightly.render.AbstractRuntimeObjectModel;

public class SlingRuntimeObjectModel
extends AbstractRuntimeObjectModel {
    private final boolean legacyToBoolean;
    private static final String EMPTY_STRING = "";

    SlingRuntimeObjectModel() {
        this(true);
    }

    SlingRuntimeObjectModel(boolean legacyToBoolean) {
        this.legacyToBoolean = legacyToBoolean;
    }

    public boolean toBoolean(Object object) {
        if (this.legacyToBoolean) {
            if (object == null) {
                return false;
            }
            if (object instanceof Number) {
                Number number = (Number)object;
                return number.doubleValue() != 0.0;
            }
            String s = object.toString();
            if (s != null) {
                s = s.trim();
            }
            if (EMPTY_STRING.equals(s)) {
                return false;
            }
            if ("true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s)) {
                return Boolean.parseBoolean(s);
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                return !collection.isEmpty();
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                return !map.isEmpty();
            }
            if (object instanceof Iterable) {
                return ((Iterable)object).iterator().hasNext();
            }
            if (object instanceof Iterator) {
                return ((Iterator)object).hasNext();
            }
            if (object instanceof Optional) {
                Optional optional = (Optional)object;
                return this.toBoolean(optional.orElse(false));
            }
            if (object.getClass().isArray()) {
                return Array.getLength(object) > 0;
            }
            return true;
        }
        return super.toBoolean(object);
    }

    protected Object getProperty(Object target, Object propertyObj) {
        Adaptable adaptable;
        ValueMap valueMap;
        if (target == null || propertyObj == null) {
            return null;
        }
        Object result = super.getProperty(target, propertyObj);
        if (result == null && target instanceof Adaptable && (valueMap = (ValueMap)(adaptable = (Adaptable)target).adaptTo(ValueMap.class)) != null) {
            String property = this.toString(propertyObj);
            result = valueMap.get((Object)property);
        }
        return result;
    }
}

