/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.nav;

import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class PackageExplorerOpenActionProvider
extends CommonActionProvider {
    private boolean fInViewPart = true;
    private OpenFileAction action;
    private TreeViewer treeViewer;

    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public void fillActionBars(IActionBars actionBars) {
        IStructuredSelection iss;
        ISelection selection;
        if (this.fInViewPart && (selection = this.treeViewer.getSelection()) instanceof IStructuredSelection && (iss = (IStructuredSelection)selection).getFirstElement() instanceof JcrNode) {
            JcrNode node = (JcrNode)iss.getFirstElement();
            final IFile file = node.getFileForEditor();
            if (file != null) {
                actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)new OpenFileAction(this.getActivePage()){

                    public void run() {
                        try {
                            IDE.openEditor((IWorkbenchPage)PackageExplorerOpenActionProvider.this.getActivePage(), (IFile)file, (boolean)true);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            return;
        }
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.action);
    }

    public void fillContextMenu(IMenuManager menu) {
    }

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.action = new OpenFileAction(this.getActivePage());
        ICommonViewerWorkbenchSite workbenchSite = null;
        if (site.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            workbenchSite = (ICommonViewerWorkbenchSite)site.getViewSite();
        }
        if (workbenchSite != null && workbenchSite.getPart() != null && workbenchSite.getPart() instanceof IViewPart) {
            IViewPart cfr_ignored_0 = (IViewPart)workbenchSite.getPart();
            if (site.getStructuredViewer() instanceof TreeViewer) {
                this.treeViewer = (TreeViewer)site.getStructuredViewer();
                this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.action);
            }
            this.fInViewPart = true;
        }
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
    }

    public void dispose() {
        super.dispose();
    }
}

