/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.graphql.api.SlingTypeResolver;
import org.apache.sling.graphql.core.osgi.ServiceReferenceObjectTuple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingTypeResolverSelector.class})
public class SlingTypeResolverSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlingTypeResolverSelector.class);
    static final Pattern RESOLVER_NAME_PATTERN = Pattern.compile("\\w+(/\\w+)+");
    private final Map<String, TreeSet<ServiceReferenceObjectTuple<SlingTypeResolver<Object>>>> typeResolvers = new HashMap<String, TreeSet<ServiceReferenceObjectTuple<SlingTypeResolver<Object>>>>();
    public static final String RESERVED_NAME_PREFIX = "sling/";
    public static final String RESERVED_PACKAGE_PREFIX = "org.apache.sling.";

    @Nullable
    public SlingTypeResolver<Object> getSlingTypeResolver(@NotNull String name) {
        TreeSet<ServiceReferenceObjectTuple<SlingTypeResolver<Object>>> resolvers = this.typeResolvers.get(name);
        if (resolvers != null && !resolvers.isEmpty()) {
            return resolvers.last().getServiceObject();
        }
        return null;
    }

    private boolean hasValidName(@NotNull ServiceReference<SlingTypeResolver<Object>> serviceReference, @NotNull SlingTypeResolver<Object> slingTypeResolver) {
        String name = PropertiesUtil.toString((Object)serviceReference.getProperty("name"), null);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            if (!SlingTypeResolverSelector.nameMatchesPattern(name)) {
                LOGGER.error("Invalid SlingTypeResolver {}: type resolver name is not namespaced (e.g. ns/myTypeResolver)", (Object)slingTypeResolver.getClass().getName());
                return false;
            }
            if (name.startsWith(RESERVED_NAME_PREFIX)) {
                String className = slingTypeResolver.getClass().getName();
                if (!slingTypeResolver.getClass().getName().startsWith(RESERVED_PACKAGE_PREFIX)) {
                    LOGGER.error("Invalid SlingTypeResolver {}: type resolver names starting with '{}' are reserved for Apache Sling Java packages", (Object)className, (Object)RESERVED_NAME_PREFIX);
                    return false;
                }
            }
        } else {
            LOGGER.error("Invalid {} implementation: type resolver {} is missing the mandatory value for its {} service property.", new Object[]{SlingTypeResolver.class.getName(), slingTypeResolver.getClass().getName(), "name"});
            return false;
        }
        return true;
    }

    static boolean nameMatchesPattern(String name) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            return RESOLVER_NAME_PATTERN.matcher(name).matches();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=SlingTypeResolver.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private void bindSlingTypeResolver(ServiceReference<SlingTypeResolver<Object>> reference, SlingTypeResolver<Object> slingTypeResolver) {
        if (this.hasValidName(reference, slingTypeResolver)) {
            Map<String, TreeSet<ServiceReferenceObjectTuple<SlingTypeResolver<Object>>>> map = this.typeResolvers;
            synchronized (map) {
                String name = (String)reference.getProperty("name");
                TreeSet resolvers = this.typeResolvers.computeIfAbsent(name, key -> new TreeSet());
                resolvers.add(new ServiceReferenceObjectTuple<SlingTypeResolver<Object>>(reference, slingTypeResolver));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindSlingTypeResolver(ServiceReference<SlingTypeResolver<Object>> reference) {
        String name = (String)reference.getProperty("name");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            Map<String, TreeSet<ServiceReferenceObjectTuple<SlingTypeResolver<Object>>>> map = this.typeResolvers;
            synchronized (map) {
                TreeSet<ServiceReferenceObjectTuple<SlingTypeResolver<Object>>> resolvers = this.typeResolvers.get(name);
                if (resolvers != null) {
                    Optional<ServiceReferenceObjectTuple> tupleToRemove = resolvers.stream().filter(tuple -> reference.equals(tuple.getServiceReference())).findFirst();
                    tupleToRemove.ifPresent(resolvers::remove);
                }
            }
        }
    }
}

